/*****************************************************************************
 * Copyright (c) 2016 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *
 *****************************************************************************/

package org.eclipse.papyrus.designer.transformation.library.iconfigurators;

import org.eclipse.papyrus.designer.deployment.tools.DepPlanUtils;
import org.eclipse.papyrus.designer.transformation.extensions.IInstanceConfigurator;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;

/**
 * Configurator of a call event (for a state machine): it sets the
 * portID attribute of the call event interceptor. The interceptor uses this
 * attribute to initialize the portID attribute within the produced CallEvent
 * data structure.
 *
 * @author ansgar
 *
 */
public class CallEventConfigurator implements IInstanceConfigurator {

	public final static String portAttribute = "portID"; //$NON-NLS-1$

	/**
	 * Configure the instance of a CallEvent interceptor. The configuration parameter is the
	 * index of the port which gets intercepted. It is obtained via an enumeration
	 *
	 * @param instance
	 *            the instance that should be configured
	 * @param componentPart
	 *            the part representing this instance
	 * @param parentInstance
	 *            the instance of the parent
	 */
	@Override
	public void configureInstance(InstanceSpecification instance, Property componentPart, InstanceSpecification parentInstance)
	{
		if (parentInstance != null) {
			// make sure that there is an enum par port
			// String literalName = "port_" + UMLTool.varName(context.port); //$NON-NLS-1$

			// the associated enumeration is declared by the statemachine (which is included by the bootloader as well)

			DepPlanUtils.configureProperty(instance, portAttribute, 0);
		}
	}

}
