/*****************************************************************************
 * Copyright (c) 2019 CIL4Sys Engineering
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Yoann Farré - yoann.farre@cil4sys.com
 *
 *****************************************************************************/
package org.eclipse.papyrus.designer.transformation.library.utils;

import java.text.Normalizer;

import org.eclipse.uml2.uml.NamedElement;

public class NameNormalizer {
	
	/**
	 * Replace special chars in the name of a named element by code compatible characters
	 * @param namedElement
	 */
	public static void normalizeName(NamedElement namedElement){
		String oldName = namedElement.getName();
		if (oldName != null && !oldName.isEmpty()) {
			String newName = Normalizer.normalize(namedElement.getName(), Normalizer.Form.NFD)
					.replaceAll("[^\\p{ASCII}]", "")
					.replaceAll(" ", "_")
					.replaceAll("'", "_");

			namedElement.setName(newName);
		}
	}

}
