/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base;

import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.ModelElementsCreator;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;

public abstract class CommonLangCodegen
implements ILangCodegen {
    protected ModelElementsCreator creator = null;
    protected IProject lastProject = null;

    public void generateCode(IProject project, PackageableElement element, IProgressMonitor monitor) {
        this.manageCreator(project, element);
        this.creator.createPackageableElement(element, monitor);
    }

    public void cleanCode(IProject project, PackageableElement element, IProgressMonitor monitor) {
        this.manageCreator(project, element);
        this.creator.removePackageableElement(element, monitor);
    }

    public void cleanCode(IProject project, PackageableElement element, List<String> keepFiles, IProgressMonitor monitor) {
        this.manageCreator(project, element);
        IFolder folder = project.getFolder(GenUtils.getSourceFolder((Element)element));
        this.creator.cleanUntouched(folder, keepFiles, monitor);
    }

    public String getFileName(IProject project, NamedElement element) {
        if (element instanceof PackageableElement) {
            this.manageCreator(project, (PackageableElement)element);
            return this.creator.getFileName(element);
        }
        return null;
    }

    protected void manageCreator(IProject project, PackageableElement element) {
        if (project == null && element instanceof PackageableElement) {
            project = this.getTargetProject(element, false);
        }
        if (this.creator == null || project != this.lastProject) {
            this.lastProject = project;
            this.creator = this.newCreator(project, element);
        }
    }

    protected abstract ModelElementsCreator newCreator(IProject var1, PackageableElement var2);
}

