/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.DataTypeImpl;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class TupleTypeImpl
extends DataTypeImpl
implements TupleType {
    public static final int TUPLE_TYPE_FEATURE_COUNT = 23;
    public static final int TUPLE_TYPE_OPERATION_COUNT = 8;
    private TupleTypeId tupleTypeId;

    protected TupleTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.TUPLE_TYPE;
    }

    public TupleTypeImpl(@NonNull TupleTypeId tupleTypeId) {
        this.tupleTypeId = tupleTypeId;
        this.setName(tupleTypeId.getName());
    }

    @Override
    public @NonNull TypeId computeId() {
        TupleTypeId tupleTypeId2 = this.tupleTypeId;
        if (tupleTypeId2 == null) {
            String name2 = NameUtil.getSafeName(this);
            List<Property> parts = this.getOwnedProperties();
            int iSize = parts.size();
            ArrayList<@NonNull TuplePartId> partIds = new ArrayList<TuplePartId>(iSize);
            int i = 0;
            while (i < iSize) {
                @NonNull TypedElement part = parts.get(i);
                String partName = NameUtil.getSafeName(part);
                TypeId partTypeId = part.getTypeId();
                partIds.add(IdManager.getTuplePartId(i, partName, partTypeId));
                ++i;
            }
            this.tupleTypeId = tupleTypeId2 = IdManager.getTupleTypeId(name2, partIds);
        }
        return tupleTypeId2;
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitTupleType(this);
    }

    @Override
    public @NonNull CompleteInheritance getInheritance(@NonNull StandardLibrary standardLibrary) {
        Class tupleType = standardLibrary.getOclTupleType();
        return tupleType.getInheritance(standardLibrary);
    }

    @Override
    public @NonNull TupleTypeId getTupleTypeId() {
        return this.getTypeId();
    }

    @Override
    public @NonNull TupleTypeId getTypeId() {
        return (TupleTypeId)super.getTypeId();
    }
}

