/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.simpletransformationschain;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.usecase.simpletransformationschain.DiscoverUmlModelFromJavaProject;
import org.eclipse.modisco.usecase.simpletransformationschain.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverUmlModelFromProject
extends AbstractModelDiscoverer<IProject> {
    private URL customTransformation = null;

    @Parameter(name="CUSTOM_TRANSFORMATION", description="A URL pointing to an ATL transformation that will be used instead of the default one.")
    public void setCustomTransformation(URL customTransformation) {
        this.customTransformation = customTransformation;
    }

    protected URL getCustomTransformation() {
        return this.customTransformation;
    }

    public boolean isApplicableTo(IProject source) {
        try {
            return source.isAccessible() && source.getNature("org.eclipse.jdt.core.javanature") != null;
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return false;
        }
    }

    protected void basicDiscoverElement(IProject source, IProgressMonitor monitor) throws DiscoveryException {
        DiscoverUmlModelFromJavaProject discoverer = new DiscoverUmlModelFromJavaProject();
        discoverer.setCustomTransformation(this.getCustomTransformation());
        discoverer.setRefreshSourceBeforeDiscovery(this.getRefreshSourceBeforeDiscovery());
        discoverer.setSerializeTarget(this.isTargetSerializationChosen());
        discoverer.setTargetModel(this.getTargetModel());
        discoverer.setTargetURI(this.getTargetURI());
        discoverer.discoverElement(JavaCore.create((IProject)source), monitor);
        this.setTargetModel(discoverer.getTargetModel());
    }
}

