/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.PropertyImpl;
import org.eclipse.internal.xtend.util.StringHelper;
import org.eclipse.xtend.typesystem.AbstractTypeImpl;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.emf.EmfRegistryMetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EClassType
extends AbstractTypeImpl {
    private static final Log log = LogFactory.getLog(EClassType.class);
    private final EmfRegistryMetaModel emfMetaModel;
    private final EClass eClass;

    public EClassType(EmfRegistryMetaModel model, String name, EClass class1) {
        super(model.getTypeSystem(), name);
        this.emfMetaModel = model;
        this.eClass = class1;
    }

    public Feature[] getContributedFeatures() {
        HashSet<Object> result = new HashSet<Object>();
        for (final EStructuralFeature feature : this.eClass.getEStructuralFeatures()) {
            Type t = this.emfMetaModel.getTypeForETypedElement((ETypedElement)feature);
            if (t == null) {
                if (feature.getEType().eIsProxy()) {
                    log.warn((Object)String.format("Unresolved proxy for type of feature %s::%s, eProxyURI: %s", this.eClass.getName(), feature.getName(), EcoreUtil.getURI((EObject)feature.getEType())));
                    continue;
                }
                log.warn((Object)("Couldn't resolve type for " + this.getTypeName(feature.getEType())));
                continue;
            }
            result.add(new PropertyImpl((Type)this, feature.getName(), t){

                public Object get(Object target) {
                    return ((EObject)target).eGet(feature);
                }

                public void set(Object target, Object newValue) {
                    if (feature.isChangeable() && !feature.isUnsettable() && !feature.isDerived()) {
                        if (feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum)) {
                            EDataType dt = (EDataType)feature.getEType();
                            newValue = this.getReturnType().convert(newValue, dt.getInstanceClass());
                        }
                    } else {
                        throw new UnsupportedOperationException("setting property '" + feature.getName() + "' is not allowed!");
                    }
                    ((EObject)target).eSet(feature, newValue);
                }
            });
            if (feature.isChangeable() && !feature.isMany()) {
                result.add(new OperationImpl((Type)this, "set" + StringHelper.firstUpper((String)feature.getName()), (Type)this, new Type[]{t}){

                    protected Object evaluateInternal(Object target, Object[] params) {
                        Object newValue = params[0];
                        if (newValue != null && feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum)) {
                            EDataType dt = (EDataType)feature.getEType();
                            newValue = ((Type)this.getParameterTypes().get(0)).convert(newValue, dt.getInstanceClass());
                        }
                        ((EObject)target).eSet(feature, newValue);
                        return target;
                    }
                });
                continue;
            }
            if (!feature.isMany()) continue;
            result.add(new OperationImpl((Type)this, "set" + StringHelper.firstUpper((String)feature.getName()), (Type)this, new Type[]{t}){

                protected Object evaluateInternal(Object target, Object[] params) {
                    if (params != null) {
                        Object newValue = params[0];
                        if (newValue != null && feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum)) {
                            EDataType dt = (EDataType)feature.getEType();
                            newValue = ((Type)this.getParameterTypes().get(0)).convert(newValue, dt.getInstanceClass());
                        }
                        BasicEList newColl = new BasicEList((Collection)((List)newValue));
                        EObject targetObject = (EObject)target;
                        EClass targetClass = targetObject.eClass();
                        EStructuralFeature eStructuralFeature = targetClass.getEStructuralFeature(feature.getName());
                        EList coll = (EList)targetObject.eGet(eStructuralFeature);
                        ECollections.setEList((EList)coll, (List)newColl);
                        return target;
                    }
                    return null;
                }
            });
        }
        EList eOperations = this.eClass.getEOperations();
        for (EOperation op : eOperations) {
            final EList emfParams = op.getEParameters();
            Type[] paramTypes = new Type[emfParams.size()];
            boolean errors = false;
            int i = 0;
            int x = emfParams.size();
            while (i < x) {
                EParameter param = (EParameter)emfParams.get(i);
                paramTypes[i] = this.emfMetaModel.getTypeForETypedElement((ETypedElement)param);
                if (paramTypes[i] == null) {
                    log.warn((Object)("Couldn't resolve type for " + this.getTypeName(param.getEType())));
                    errors = true;
                }
                ++i;
            }
            Type t = this.emfMetaModel.getTypeForETypedElement((ETypedElement)op);
            if (t == null) {
                log.warn((Object)("Couldn't resolve type for " + this.getTypeName(op.getEType())));
                errors = true;
            }
            if (errors) continue;
            result.add(new OperationImpl((Type)this, op.getName(), t, paramTypes){

                protected Object evaluateInternal(Object target, Object[] params) {
                    Class[] paramClasses = new Class[emfParams.size()];
                    int i = 0;
                    int x = emfParams.size();
                    while (i < x) {
                        EParameter param = (EParameter)emfParams.get(i);
                        paramClasses[i] = param.isMany() ? EList.class : param.getEType().getInstanceClass();
                        params[i] = ((Type)this.getParameterTypes().get(i)).convert(params[i], paramClasses[i]);
                        ++i;
                    }
                    try {
                        Method m = target.getClass().getMethod(this.getName(), paramClasses);
                        return m.invoke(target, params);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return result.toArray(new Feature[result.size()]);
    }

    private String getTypeName(EClassifier type) {
        if (type == null) {
            return "null";
        }
        return type.getName();
    }

    public boolean isInstance(Object o) {
        return this.eClass.isInstance(o);
    }

    public Object newInstance() {
        return this.eClass.getEPackage().getEFactoryInstance().create(this.eClass);
    }

    protected Set<Type> internalGetSuperTypes() {
        EList superTypes = this.eClass.getESuperTypes();
        HashSet<Type> result = new HashSet<Type>();
        for (EClass element : superTypes) {
            result.add(this.emfMetaModel.getTypeForEClassifier((EClassifier)element));
        }
        result.add((Type)this.emfMetaModel.getEobjectType());
        return result;
    }

    public boolean isAbstract() {
        return this.eClass.isAbstract();
    }

    protected boolean internalIsAssignableFrom(Type t) {
        if (super.internalIsAssignableFrom(t)) {
            return true;
        }
        if (this.getName().equals("ecore::EObject")) {
            if (t instanceof EClassType) {
                return true;
            }
            Set superTypes = t.getSuperTypes();
            for (Type type : superTypes) {
                if (!(type instanceof EClassType)) continue;
                return true;
            }
        }
        return false;
    }
}

