/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.Advice;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.ImportDeclaration;
import org.eclipse.internal.xpand2.model.XpandAdvice;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandUtil;
import org.eclipse.xtend.expression.AnalysationIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends SyntaxElement
implements XpandResource {
    private ImportDeclaration[] imports;
    private Definition[] definitions;
    private String fullyQualifiedName;
    private ImportDeclaration[] extensions;
    private Advice[] advices;
    private String[] commonPrefixes = null;
    String[] importedExtensions = null;

    public ImportDeclaration[] getExtensions() {
        return this.extensions;
    }

    public List<String> getImportedExtensionsAsList() {
        ArrayList<String> result = new ArrayList<String>();
        ImportDeclaration[] importDeclarationArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ImportDeclaration ext = importDeclarationArray[n2];
            result.add(ext.getImportString().getValue());
            ++n2;
        }
        return result;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Template(ImportDeclaration[] imports, ImportDeclaration[] extensions, Definition[] definitions, Advice[] advices) {
        this.imports = imports;
        this.extensions = extensions;
        int i = 0;
        while (i < definitions.length) {
            definitions[i].setOwner(this);
            ++i;
        }
        this.definitions = definitions;
        i = 0;
        while (i < advices.length) {
            advices[i].setOwner(this);
            ++i;
        }
        this.advices = advices;
    }

    @Override
    public XpandDefinition[] getDefinitions() {
        return this.definitions;
    }

    public List<XpandDefinition> getDefinitionsAsList() {
        return Arrays.asList(this.definitions);
    }

    public AbstractDefinition[] getAllDefinitions() {
        ArrayList l = new ArrayList();
        l.addAll(Arrays.asList(this.definitions));
        l.addAll(Arrays.asList(this.advices));
        Collections.sort(l, new Comparator<SyntaxElement>(){

            @Override
            public int compare(SyntaxElement o1, SyntaxElement o2) {
                return new Integer(o1.getStart()).compareTo(o2.getStart());
            }
        });
        return l.toArray(new AbstractDefinition[l.size()]);
    }

    public ImportDeclaration[] getImports() {
        return this.imports;
    }

    public List<ImportDeclaration> getImportsAsList() {
        return Arrays.asList(this.imports);
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            ctx = (XpandExecutionContext)ctx.cloneWithResource(this);
            int i = 0;
            while (i < this.definitions.length) {
                this.definitions[i].analyze(ctx, issues);
                ++i;
            }
            i = 0;
            while (i < this.advices.length) {
                this.advices[i].analyze(ctx, issues);
                ++i;
            }
        }
        catch (RuntimeException ex) {
            ctx.handleRuntimeException(ex, this, null);
        }
    }

    @Override
    public XpandDefinition[] getDefinitionsByName(String aName) {
        ArrayList<Definition> defs = new ArrayList<Definition>();
        int i = 0;
        while (i < this.definitions.length) {
            Definition def = this.definitions[i];
            if (def.getName().equals(aName)) {
                defs.add(def);
            }
            ++i;
        }
        return defs.toArray(new XpandDefinition[defs.size()]);
    }

    public String[] getImportedNamespaces() {
        if (this.commonPrefixes == null) {
            ArrayList<String> l = new ArrayList<String>();
            String thisNs = XpandUtil.withoutLastSegment(this.getFullyQualifiedName());
            if (thisNs != null) {
                l.add(thisNs);
            }
            int i = 0;
            while (i < this.getImports().length) {
                ImportDeclaration anImport = this.getImports()[i];
                l.add(anImport.getImportString().getValue());
                ++i;
            }
            this.commonPrefixes = l.toArray(new String[l.size()]);
        }
        return this.commonPrefixes;
    }

    public List<String> getImportedNamespacesAsList() {
        return Arrays.asList(this.getImportedNamespaces());
    }

    public String[] getImportedExtensions() {
        if (this.importedExtensions == null) {
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < this.getExtensions().length) {
                ImportDeclaration anImport = this.getExtensions()[i];
                l.add(anImport.getImportString().getValue());
                ++i;
            }
            this.importedExtensions = l.toArray(new String[l.size()]);
        }
        return this.importedExtensions;
    }

    @Override
    public XpandAdvice[] getAdvices() {
        return this.advices;
    }
}

