/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.properties.PropertyMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.IWriterListenerExtension;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.taglib.DocumentHelper;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.TagUtil;
import org.eclipse.jet.transform.TransformContextExtender;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class MergeTag
extends AbstractEmptyTag {
    private static final String EMF_CODEGEN_RULES_URL = "platform:/plugin/org.eclipse.emf.codegen.ecore/templates/emf-merge.xml";
    private static final String AST_FACADE = "org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper";
    private static final String JDOM_FACADE = "org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMFacadeHelper";
    private static final String JMERGE_POSITION_CATEGORY;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.internal.taglib.java.MergeTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JMERGE_POSITION_CATEGORY = clazz.getName();
    }

    public void doAction(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        String facade;
        String rulesContext;
        if (!(out instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        BufferedJET2Writer bufferedWriter = (BufferedJET2Writer)out;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument document = (IDocument)bufferedWriter.getAdapter((Class)clazz);
        String rules = this.getAttribute("rules");
        if (rules == null) {
            rules = EMF_CODEGEN_RULES_URL;
        }
        if ((rulesContext = this.getAttribute("rulesContext")) == null) {
            rulesContext = "transform";
        }
        if ((facade = this.getAttribute("facade")) == null) {
            String emfCodeGenVersion = (String)CodeGenPlugin.getPlugin().getBundle().getHeaders().get("Bundle-Version");
            facade = emfCodeGenVersion.startsWith("2.2.") ? JDOM_FACADE : AST_FACADE;
        }
        URL baseURL = TransformContextExtender.getInstance(context).getBaseURL(rulesContext);
        if (rules.startsWith("/")) {
            rules = rules.substring(1);
        }
        try {
            FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper((String)facade);
            if (facadeHelper == null) {
                throw new JET2TagException(MessageFormat.format(JET2Messages.MergeTag_UnknownJMergeFacadeHelper, facade));
            }
            URL rulesURL = new URL(baseURL, rules);
            DocumentHelper.installPositionCategory(document, JMERGE_POSITION_CATEGORY);
            document.addPosition(JMERGE_POSITION_CATEGORY, (Position)new MergePosition(rulesURL, bufferedWriter.getContentLength(), facadeHelper));
            bufferedWriter.addEventListener(JMERGE_POSITION_CATEGORY, (IWriterListener)new JMergeProcessor());
        }
        catch (MalformedURLException malformedURLException) {
            String msg = JET2Messages.MergeTag_CouldNotCreateURL;
            throw new JET2TagException(MessageFormat.format(msg, baseURL.toExternalForm(), rules));
        }
        catch (BadLocationException e) {
            throw new JET2TagException((Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            throw new JET2TagException((Throwable)e);
        }
    }

    public static class JMergeProcessor
    implements IWriterListener,
    IWriterListenerExtension {
        public void finalizeContent(JET2Writer writer, Object file) throws JET2TagException {
            if (file instanceof IFile) {
                IFile iFile = (IFile)file;
                if (!iFile.exists()) {
                    return;
                }
                if ("java".equals(iFile.getFileExtension())) {
                    this.jmerge(writer, iFile);
                } else if ("properties".equals(iFile.getFileExtension())) {
                    this.propmerge(writer, iFile);
                }
            }
        }

        public void finalizeContent(JET2Writer writer, Object fileObject, String existingContent) throws JET2TagException {
            if (fileObject instanceof IFile && existingContent != null) {
                IFile iFile = (IFile)fileObject;
                if ("java".equals(iFile.getFileExtension())) {
                    this.jmerge(writer, iFile, existingContent);
                } else if ("properties".equals(iFile.getFileExtension())) {
                    this.propmerge(writer, iFile, existingContent);
                }
            }
        }

        private void propmerge(JET2Writer writer, IFile file) throws JET2TagException {
            try {
                this.propmerge(writer, file, TagUtil.getContents(file.getLocation()));
            }
            catch (CoreException coreException) {
                String msg = JET2Messages.MergeTag_CouldNotRead;
                throw new JET2TagException(MessageFormat.format(msg, file.getFullPath()));
            }
        }

        private void propmerge(JET2Writer writer, IFile file, String targetPropertiesString) throws JET2TagException {
            PropertyMerger merger = new PropertyMerger();
            merger.setSourceProperties(((BufferedJET2Writer)writer).getContent());
            merger.setTargetProperties(targetPropertiesString);
            merger.merge();
            ((BufferedJET2Writer)writer).setContent(merger.getTargetProperties());
        }

        private void jmerge(JET2Writer writer, IFile iFile) throws JET2TagException {
            try {
                this.jmerge(writer, iFile, TagUtil.getContents(iFile.getLocation()));
            }
            catch (CoreException coreException) {
                String msg = JET2Messages.MergeTag_CouldNotRead;
                throw new JET2TagException(MessageFormat.format(msg, iFile.getFullPath()));
            }
        }

        private void jmerge(JET2Writer writer, IFile iFile, String targetCUSource) throws JET2TagException {
            BufferedJET2Writer bufferedJET2Writer = (BufferedJET2Writer)writer;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IDocument document = (IDocument)bufferedJET2Writer.getAdapter((Class)clazz);
            try {
                Position[] positions = document.getPositions(JMERGE_POSITION_CATEGORY);
                MergePosition mergePosition = (MergePosition)positions[0];
                FacadeHelper facadeHelper = mergePosition.getFacadeHelper();
                JControlModel controlModel = new JControlModel();
                controlModel.initialize(facadeHelper, mergePosition.getRulesURL().toExternalForm());
                JMerger merger = new JMerger(controlModel);
                JCompilationUnit sourceCU = facadeHelper.createCompilationUnit(iFile.getName(), writer.toString());
                JCompilationUnit targetCU = facadeHelper.createCompilationUnit(iFile.getName(), targetCUSource);
                merger.setSourceCompilationUnit(sourceCU);
                merger.setTargetCompilationUnit(targetCU);
                merger.merge();
                ((BufferedJET2Writer)writer).setContent(targetCU.getContents());
            }
            catch (BadPositionCategoryException e) {
                throw new RuntimeException(e);
            }
            catch (WrappedException e) {
                String baseMsg = JET2Messages.MergeTag_FailedOnCompilerError;
                String msg = MessageFormat.format(baseMsg, iFile.getFullPath().makeRelative());
                throw new JET2TagException(msg, (Throwable)e.exception());
            }
        }

        public void postCommitContent(JET2Writer writer, Object file) {
        }
    }

    public static class MergePosition
    extends Position {
        private final URL rulesURL;
        private final FacadeHelper facadeHelper;

        public MergePosition(URL rulesURL, int offset, FacadeHelper facadeHelper) {
            super(offset);
            this.rulesURL = rulesURL;
            this.facadeHelper = facadeHelper;
        }

        public final URL getRulesURL() {
            return this.rulesURL;
        }

        public FacadeHelper getFacadeHelper() {
            return this.facadeHelper;
        }
    }
}

