/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.text.MessageFormat;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPathRuntimeException;
import org.eclipse.jet.xpath.XPathVariableResolver;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public class Variable
extends ExprNode {
    private final String name;

    public Variable(String name) {
        this.name = name;
    }

    public Object evalAsObject(Context context) {
        INodeInspector inspector;
        XPathVariableResolver resolver = context.getVariableResolver();
        Object varValue = resolver.resolveVariable(this.name);
        if (varValue == null) {
            String msg = JET2Messages.XPath_VariableUndefined;
            throw new XPathRuntimeException(MessageFormat.format(msg, this.name));
        }
        if (!(varValue instanceof String || varValue instanceof NodeSet || varValue instanceof Boolean || varValue instanceof Number || (inspector = InspectorManager.getInstance().getInspector(varValue)) == null || inspector.getNodeKind(varValue) == null)) {
            NodeSetImpl nodeSet = new NodeSetImpl(1);
            nodeSet.add(varValue);
            varValue = nodeSet;
        }
        return varValue;
    }

    public String getVariableName() {
        return this.name;
    }

    public String toString() {
        return "$" + this.getVariableName();
    }
}

