/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import org.eclipse.jet.JET2Context;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.taglib.control.BreadthFirstStrategy;
import org.eclipse.jet.internal.taglib.control.IDeepIterateStrategy;
import org.eclipse.jet.internal.taglib.control.Messages;
import org.eclipse.jet.internal.taglib.control.PreorderStrategy;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.osgi.util.NLS;

public class DeepIteratorStrategyBuilder {
    private final JET2Context context;
    private final String select;
    private String var;
    private String filter;
    private Object contextObject;
    private boolean allowDuplicates = true;
    private String varStatus;
    private final String tagName;
    private static final int DEPTH_FIRST_TRAVERSAL = 1;
    private static final int BREADTH_FIRST_TRAVERSAL = 2;
    private int traversal = 1;

    public DeepIteratorStrategyBuilder(JET2Context context, String tagName, String select) {
        this.context = context;
        this.tagName = tagName;
        this.select = select;
        this.contextObject = XPathContextExtender.getInstance(context).currentXPathContextObject();
    }

    public DeepIteratorStrategyBuilder var(String var) {
        this.var = var;
        return this;
    }

    public DeepIteratorStrategyBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    public DeepIteratorStrategyBuilder contextObject(Object contextObject) {
        this.contextObject = contextObject;
        return this;
    }

    public DeepIteratorStrategyBuilder allowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
        return this;
    }

    public IDeepIterateStrategy build() {
        if (this.traversal == 1) {
            return new PreorderStrategy(this);
        }
        return new BreadthFirstStrategy(this);
    }

    final JET2Context getContext() {
        return this.context;
    }

    final String getSelect() {
        return this.select;
    }

    final String getVar() {
        return this.var;
    }

    final String getFilter() {
        return this.filter;
    }

    final Object getContextObject() {
        return this.contextObject;
    }

    final boolean isAllowDuplicates() {
        return this.traversal == 1 ? this.allowDuplicates : false;
    }

    public DeepIteratorStrategyBuilder varStatus(String varStatus) {
        this.varStatus = varStatus;
        return this;
    }

    final String getVarStatus() {
        return this.varStatus;
    }

    final String getTagName() {
        return this.tagName;
    }

    public DeepIteratorStrategyBuilder traversal(String traversal) throws JET2TagException {
        if ("depthFirst".equals(traversal)) {
            this.traversal = 1;
        } else if ("breadthFirst".equals(traversal)) {
            this.traversal = 2;
        } else if (traversal != null) {
            throw new JET2TagException(NLS.bind((String)Messages.DeepIteratorStrategyBuilder_UnrecognizedTraversalStrategy, (Object[])new Object[]{traversal, "depthFirst", "breadthFirst"}));
        }
        return this;
    }
}

