/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.internal.extensionpoints.TransformDataFactory;
import org.eclipse.jet.internal.runtime.IJETBundleProvider;
import org.eclipse.jet.internal.runtime.JETBundleDescriptor;
import org.eclipse.jet.internal.runtime.JETBundleManifest;
import org.eclipse.jet.internal.runtime.NotABundleException;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public final class InstalledJETBundleProvider
implements IRegistryChangeListener,
IJETBundleProvider {
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "transform";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.transform";
    private final Map pluginBundleDescriptorsById = Collections.synchronizedMap(new HashMap());

    public void startup() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.addConfigElements(registry.getConfigurationElementsFor(EXTENSION_POINT_ID));
        registry.addRegistryChangeListener((IRegistryChangeListener)this, PLUGIN_ID);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(EXTENSION_POINT_ID);
        int i = 0;
        while (i < deltas.length) {
            IExtension ext = deltas[i].getExtension();
            if (deltas[i].getKind() == 1) {
                this.addConfigElements(ext.getConfigurationElements());
            } else {
                this.removeConfigElements(ext.getConfigurationElements());
            }
            ++i;
        }
    }

    public void shutdown() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeRegistryChangeListener((IRegistryChangeListener)this);
        registry = null;
    }

    private void addConfigElements(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement element = configElements[i];
            if (EXTENSION_NAME.equals(element.getName())) {
                String transformId = element.getDeclaringExtension().getNamespace();
                this.addJETPlugin(transformId, element);
            }
            ++i;
        }
    }

    private void removeConfigElements(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement element = configElements[i];
            if (EXTENSION_NAME.equals(element.getName())) {
                String transformId = element.getDeclaringExtension().getNamespace();
                this.removeJETPlugin(transformId);
            }
            ++i;
        }
    }

    public Set getAllJETBundleIds() {
        return this.pluginBundleDescriptorsById.keySet();
    }

    public IJETBundleDescriptor getDescriptor(String id) {
        return (IJETBundleDescriptor)this.pluginBundleDescriptorsById.get(id);
    }

    public void addJETPlugin(String id, IConfigurationElement transformElement) {
        try {
            Bundle bundle = Platform.getBundle((String)id);
            JETBundleManifest manifest = new JETBundleManifest(bundle.getHeaders(Platform.getNL()));
            this.pluginBundleDescriptorsById.put(id, new JETBundleDescriptor(manifest, TransformDataFactory.INSTANCE.createTransformData(transformElement), bundle.getEntry("/")));
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (NotABundleException e) {
            e.printStackTrace();
        }
    }

    public void removeJETPlugin(String id) {
        this.pluginBundleDescriptorsById.remove(id);
    }

    public Bundle load(String id, IProgressMonitor monitor) {
        Bundle bundle = null;
        if (this.pluginBundleDescriptorsById.containsKey(id)) {
            bundle = Platform.getBundle((String)id);
        }
        return bundle;
    }

    public void unload(String id) {
    }

    public void unload(Bundle bundle) throws BundleException {
    }

    public Collection getAllJETBundleDescriptors() {
        return this.pluginBundleDescriptorsById.values();
    }
}

