/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public final class LineInfo {
    private final int start;
    private final int end;
    private final String delimiter;

    public LineInfo(int start, int end, String delimiter) {
        this.start = start;
        this.end = end;
        this.delimiter = delimiter;
    }

    public final String getDelimiter() {
        return this.delimiter;
    }

    public final int getEnd() {
        return this.end;
    }

    public final int getStart() {
        return this.start;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + ") ";
    }

    public static LineInfo[] calculateLines(char[] buffer) {
        ArrayList<LineInfo> list = new ArrayList<LineInfo>();
        int start = 0;
        int i = 0;
        while (i < buffer.length) {
            block8: {
                String separator;
                switch (buffer[i]) {
                    case '\r': {
                        if (i + 1 < buffer.length && buffer[i + 1] == '\n') {
                            separator = "\r\n";
                            break;
                        }
                        separator = "\r";
                        break;
                    }
                    case '\n': {
                        separator = "\n";
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                LineInfo lineInfo = new LineInfo(start, i, separator);
                list.add(lineInfo);
                if (separator.length() == 2) {
                    ++i;
                }
                start = i + 1;
            }
            ++i;
        }
        if (start < buffer.length) {
            LineInfo lineInfo = new LineInfo(start, buffer.length, "");
            list.add(lineInfo);
        }
        return list.toArray(new LineInfo[list.size()]);
    }

    public static LineInfo getLineInfo(LineInfo[] lineInfo, int offset) {
        int index = LineInfo.getLineNo(lineInfo, offset) - 1;
        return index < lineInfo.length ? lineInfo[index] : null;
    }

    public static int getLineNo(LineInfo[] lineInfo, final int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset = " + offset);
        }
        int index = Arrays.binarySearch(lineInfo, null, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                LineInfo li = (LineInfo)arg0;
                if (offset < li.start) {
                    return 1;
                }
                if (li.start <= offset && offset < li.end + li.delimiter.length()) {
                    return 0;
                }
                return -1;
            }
        });
        return (index >= 0 ? index : -index - 1) + 1;
    }

    public boolean hasDelimiter() {
        return this.getDelimiter().length() > 0;
    }
}

