/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.extensionpoints.XPathFunctionLazyLoadWrapper;
import org.eclipse.jet.xpath.XPathFunctionMetaData;

public final class XPathFunctionsManager
implements IRegistryChangeListener {
    public static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/ext/xpathFunctions")) != false;
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "xpathFunctions";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.xpathFunctions";
    private static final String E_FUNCTION = "function";
    private static final String A_FUNCTION_NAME = "name";
    private static final String A_FUNCTION_IMPLEMENTATION = "implementation";
    private static final String A_FUNCTION_MINARGS = "minArgs";
    private static final String A_FUNCTION_MAXARGS = "maxArgs";
    private final Map functionMap = new HashMap();

    private void addConfigElements(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            XPathFunctionMetaData functionData;
            if (E_FUNCTION.equals(configElements[i].getName()) && (functionData = this.buildFunctionMetaData(configElements[i])) != null) {
                if (DEBUG) {
                    System.out.println("defining function: " + functionData.getName());
                }
                this.functionMap.put(functionData.getName(), functionData);
            }
            ++i;
        }
    }

    private XPathFunctionMetaData buildFunctionMetaData(IConfigurationElement configElement) {
        try {
            String name = configElement.getAttribute(A_FUNCTION_NAME);
            int minArgs = Integer.parseInt(configElement.getAttribute(A_FUNCTION_MINARGS));
            int maxArgs = Integer.parseInt(configElement.getAttribute(A_FUNCTION_MAXARGS));
            return new XPathFunctionMetaData(name, configElement.getContributor().getName(), new XPathFunctionLazyLoadWrapper(name, configElement, A_FUNCTION_IMPLEMENTATION), minArgs, maxArgs);
        }
        catch (NumberFormatException e) {
            InternalJET2Platform.log(InternalJET2Platform.newStatus(4, "", e));
        }
        catch (NullPointerException e) {
            InternalJET2Platform.log(InternalJET2Platform.newStatus(4, "", e));
        }
        catch (IllegalArgumentException e) {
            InternalJET2Platform.log(InternalJET2Platform.newStatus(4, "", e));
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
        }
        catch (IllegalStateException illegalStateException) {}
        return null;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        int i;
        IExtensionDelta[] deltas;
        if (DEBUG) {
            System.out.println("Received registry change event");
        }
        if (DEBUG) {
            deltas = event.getExtensionDeltas();
            i = 0;
            while (i < deltas.length) {
                IExtensionDelta id = deltas[i];
                System.out.println(" " + id.getExtension().getContributor().getName() + ": " + id.getExtensionPoint().getUniqueIdentifier() + " (" + (id.getKind() == 1 ? "added" : "removed") + ")");
                System.out.println("   matches = " + EXTENSION_POINT_ID.equals(id.getExtensionPoint().getUniqueIdentifier()));
                ++i;
            }
        }
        deltas = event.getExtensionDeltas(PLUGIN_ID, EXTENSION_NAME);
        if (DEBUG) {
            System.out.println("Found " + deltas.length + " deltas for " + EXTENSION_POINT_ID);
        }
        i = 0;
        while (i < deltas.length) {
            IExtension ext = deltas[i].getExtension();
            if (deltas[i].getKind() == 1) {
                if (DEBUG) {
                    System.out.println("adding config elements");
                }
                this.addConfigElements(ext.getConfigurationElements());
            } else {
                if (DEBUG) {
                    System.out.println("removing config elements");
                }
                this.removeConfigElements(ext.getConfigurationElements());
            }
            ++i;
        }
    }

    private void removeConfigElements(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            String name;
            if (E_FUNCTION.equals(configElements[i].getName()) && (name = configElements[i].getAttribute(A_FUNCTION_NAME)) != null) {
                if (DEBUG) {
                    System.out.println("undefining function: " + name);
                }
                this.functionMap.remove(name);
            }
            ++i;
        }
    }

    public void shutdown() {
        InternalJET2Platform.IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(this.getClass(), "shutdown()");
        if (DEBUG) {
            System.out.println("shutting down XPath function manager");
        }
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
        this.functionMap.clear();
        timer.done();
    }

    public void startup() {
        InternalJET2Platform.IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(this.getClass(), "startup()");
        if (DEBUG) {
            System.out.println("starting XPath function manager");
        }
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = reg.getConfigurationElementsFor(EXTENSION_POINT_ID);
        this.addConfigElements(configElements);
        reg.addRegistryChangeListener((IRegistryChangeListener)this, PLUGIN_ID);
        timer.done();
    }

    public XPathFunctionMetaData[] getCustomFunctions() {
        if (DEBUG) {
            System.out.println("Custom functions: " + this.functionMap.keySet());
        }
        return this.functionMap.values().toArray(new XPathFunctionMetaData[this.functionMap.size()]);
    }

    public void forceRefresh(String id) {
        if (DEBUG) {
            System.out.println("XPathFunctionManager: forced refresh on " + id);
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensions(id);
        int i = 0;
        while (i < extensions.length) {
            if (EXTENSION_POINT_ID.equals(extensions[i].getExtensionPointUniqueIdentifier())) {
                this.addConfigElements(extensions[i].getConfigurationElements());
            }
            ++i;
        }
    }
}

