/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.builder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.compiler.CompileOptionsManager;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.compiler.SimplifiedCompiler;
import org.eclipse.jet.internal.compiler.UnicodeEscapeUtil;
import org.eclipse.jet.internal.core.compiler.ICompilerOutput;
import org.eclipse.jet.internal.core.compiler.IJETCompiler;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.parser.resources.WorkspaceTemplateResolverBuilder;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryManager;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jet.transform.IJETBundleDescriptor;

public class WorkspaceCompiler
implements IJETCompiler,
ICompilerOutput,
ITagLibraryResolver {
    public static final String RUNTIME_PROBLEM_MARKER = "org.eclipse.jet.runtimeProblem";
    public static final String COMPILE_PROBLEM_MARKER = "org.eclipse.jet.compileProblem";
    private final IJETCompiler simplifiedCompiler;
    private final IProject project;
    private final IContainer outputLocation;
    private final boolean writeFilesAsDerived;
    private final IProgressMonitor monitor;

    public WorkspaceCompiler(IProject project, Serializable savedState, IProgressMonitor monitor) {
        this(project, savedState, CompileOptionsManager.getOptions(project), monitor);
    }

    public WorkspaceCompiler(IProject project, Serializable savedState, Map options, IProgressMonitor monitor) {
        this.project = project;
        IJETBundleDescriptor descriptor = JET2Platform.getProjectDescription(project.getName());
        SimplifiedCompiler.Builder builder = new SimplifiedCompiler.Builder(JETCompilerOptions.getIntOption((Map)options, (String)"org.eclipse.jet.jetSpecificationVersion"), this).templateResolver(this.buildTemplateResolver(project, options)).options(options).enableEmbeddedExpressions(descriptor != null ? descriptor.isEnableEmbeddedExpressions() : false).tagLibraryResolver(this);
        if (descriptor != null) {
            builder.predefinedTagLibraries(this.getPredefinitionMap(descriptor.getTagLibraryReferences()));
            String templateLoaderClass = descriptor.getTemplateLoaderClass();
            if (templateLoaderClass != null && templateLoaderClass.length() > 0) {
                builder.templateLoaderFQN(templateLoaderClass);
            }
        }
        if (savedState != null) {
            builder.savedState(savedState);
        }
        this.simplifiedCompiler = builder.build();
        String javaSrcFolder = JETCompilerOptions.getStringOption((Map)options, (String)"org.eclipse.jet.compiledTemplateSrcDir").trim();
        this.outputLocation = javaSrcFolder.length() == 0 ? project : project.getFolder(javaSrcFolder);
        this.writeFilesAsDerived = JETCompilerOptions.getBooleanOption((Map)options, (String)"org.eclipse.jet.setJavaDerived");
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
    }

    private ITemplateResolver buildTemplateResolver(IProject project, Map options) {
        WorkspaceTemplateResolverBuilder templateResolverWorkspaceTemplateResolverBuilder = new WorkspaceTemplateResolverBuilder(project);
        URI[] altBaseLocations = this.getAltBaseLocations(options);
        if (altBaseLocations.length > 0) {
            templateResolverWorkspaceTemplateResolverBuilder.addAltBaseLocations(altBaseLocations);
        }
        ITemplateResolver templateResolver = templateResolverWorkspaceTemplateResolverBuilder.build();
        return templateResolver;
    }

    private URI[] getAltBaseLocations(Map options) {
        String value = JETCompilerOptions.getStringOption((Map)options, (String)"org.eclipse.jet.v1BaseTransformationID");
        if (value == null || value.trim().length() == 0) {
            return new URI[0];
        }
        String[] uriStrings = value.split(",");
        ArrayList<URI> altLocations = new ArrayList<URI>(uriStrings.length);
        int i = 0;
        while (i < uriStrings.length) {
            String uriString = uriStrings[i].endsWith("/") ? uriStrings[i] : String.valueOf(uriStrings[i]) + "/";
            try {
                URI uri = new URI(uriString);
                altLocations.add(uri);
            }
            catch (URISyntaxException e) {
                InternalJET2Platform.logError(null, e);
            }
            ++i;
        }
        return altLocations.toArray(new URI[altLocations.size()]);
    }

    private Map getPredefinitionMap(TagLibraryReference[] tagLibraryReferences) {
        HashMap<String, String> predefinedMap = new HashMap<String, String>(tagLibraryReferences.length);
        int i = 0;
        while (i < tagLibraryReferences.length) {
            if (tagLibraryReferences[i].isAutoImport()) {
                predefinedMap.put(tagLibraryReferences[i].getPrefix(), tagLibraryReferences[i].getTagLibraryId());
            }
            ++i;
        }
        return predefinedMap;
    }

    public void clean() {
        this.simplifiedCompiler.clean();
    }

    public IJETCompiler.CompileResult compile(String templatePath) {
        return this.simplifiedCompiler.compile(templatePath);
    }

    public void finish() {
        this.simplifiedCompiler.finish();
    }

    public Serializable getMemento() {
        return this.simplifiedCompiler.getMemento();
    }

    public String[] getTagLibaryDependencies() {
        return this.simplifiedCompiler.getTagLibaryDependencies();
    }

    public void removeTemplate(String templatePath) {
        this.simplifiedCompiler.removeTemplate(templatePath);
    }

    public boolean isTemplate(String templatePath) {
        return this.simplifiedCompiler.isTemplate(templatePath);
    }

    public void removeOutput(String outputFilePath) {
        IFile file = this.outputLocation.getFile((IPath)new Path(outputFilePath));
        if (file.exists() || file.isDerived()) {
            try {
                file.delete(false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException e) {
                InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, (Exception)((Object)e));
            }
        }
    }

    public void writeOutput(String outputFilePath, String contents, String encoding) {
        try {
            IStatus status;
            IFile file = this.outputLocation.getFile((IPath)new Path(outputFilePath));
            this.ensureDirsExist(file.getParent());
            Charset cs = Charset.forName(file.getCharset());
            ByteBuffer newContents = UnicodeEscapeUtil.encode(contents, cs);
            if (file.exists()) {
                boolean writeNewContents = true;
                try {
                    InputStream inputStream = file.getContents();
                    ReadableByteChannel channel = Channels.newChannel(inputStream);
                    ByteBuffer originalContents = ByteBuffer.allocate(inputStream.available());
                    channel.read(originalContents);
                    channel.close();
                    writeNewContents = !newContents.equals(originalContents);
                    newContents.rewind();
                }
                catch (IOException iOException) {}
                if (!writeNewContents) {
                    return;
                }
            }
            if (file.exists() && file.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
                throw new CoreException(status);
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(newContents.array(), 0, newContents.remaining());
            if (!file.exists()) {
                file.create((InputStream)stream, true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            } else {
                file.setContents((InputStream)stream, true, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            file.setDerived(this.writeFilesAsDerived);
        }
        catch (CoreException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, (Exception)((Object)e));
        }
        catch (CharacterCodingException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, e);
        }
    }

    private void ensureDirsExist(IContainer container) throws CoreException {
        if (container != null && !container.exists() && container.getType() == 2) {
            this.ensureDirsExist(container.getParent());
            ((IFolder)container).create(false, true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
    }

    public void recordProblems(String templatePath, List problems) {
        IFile file = this.project.getFile(templatePath);
        if (file.exists()) {
            try {
                Iterator i = problems.iterator();
                while (i.hasNext()) {
                    Problem problem = (Problem)i.next();
                    IMarker marker = file.createMarker(COMPILE_PROBLEM_MARKER);
                    marker.setAttribute("lineNumber", problem.getLineNumber());
                    marker.setAttribute("charStart", problem.getStart());
                    marker.setAttribute("charEnd", problem.getEnd());
                    marker.setAttribute("message", (Object)problem.getMessage());
                    marker.setAttribute("priority", 2);
                    if (problem.getProblemSeverity() == ProblemSeverity.ERROR) {
                        marker.setAttribute("priority", 2);
                        marker.setAttribute("severity", 2);
                        continue;
                    }
                    if (problem.getProblemSeverity() == ProblemSeverity.WARNING) {
                        marker.setAttribute("priority", 1);
                        marker.setAttribute("severity", 1);
                        continue;
                    }
                    marker.setAttribute("priority", 0);
                    marker.setAttribute("severity", 0);
                }
            }
            catch (CoreException e) {
                InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, (Exception)((Object)e));
            }
        }
    }

    public void preCompile(String templatePath) {
        IFile file = this.project.getFile(templatePath);
        try {
            if (file.exists()) {
                file.deleteMarkers(COMPILE_PROBLEM_MARKER, false, 2);
                file.deleteMarkers(RUNTIME_PROBLEM_MARKER, false, 2);
            }
        }
        catch (CoreException e) {
            InternalJET2Platform.logError(JET2Messages.JET2Compiler_ErrorWritingJava, (Exception)((Object)e));
        }
    }

    public TagLibrary getLibrary(String tagLibraryID) {
        return TagLibraryManager.getInstance().getTagLibrary(tagLibraryID);
    }

    public String[] getAffectedTemplatePaths(String changedFilePath) {
        return this.simplifiedCompiler.getAffectedTemplatePaths(changedFilePath);
    }
}

