/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jet.CoreJETException;

public class CoreExceptionWrapper
extends CoreJETException {
    private static final long serialVersionUID = 5977946863300207215L;

    public CoreExceptionWrapper(CoreException e) {
        super(CoreExceptionWrapper.diagnosticFor(e.getStatus()));
    }

    public static Diagnostic diagnosticFor(IStatus status) {
        BasicDiagnostic bd = new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), new Object[]{status.getException()});
        List childDiagnostics = CoreExceptionWrapper.childDiagnosticsFor(status);
        Iterator i = childDiagnostics.iterator();
        while (i.hasNext()) {
            Diagnostic diagnostic = (Diagnostic)i.next();
            bd.add(diagnostic);
        }
        return bd;
    }

    private static List childDiagnosticsFor(IStatus status) {
        if (!status.isMultiStatus()) {
            return Collections.EMPTY_LIST;
        }
        IStatus[] childStati = status.getChildren();
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>(childStati.length);
        int i = 0;
        while (i < childStati.length) {
            result.add(CoreExceptionWrapper.diagnosticFor(childStati[i]));
            ++i;
        }
        return result;
    }
}

