/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import org.eclipse.jet.compiler.Comment;
import org.eclipse.jet.compiler.DefaultJET2ASTVisitor;
import org.eclipse.jet.compiler.JET2ASTElement;
import org.eclipse.jet.compiler.JET2ASTVisitor;
import org.eclipse.jet.compiler.JET2Declaration;
import org.eclipse.jet.compiler.JET2Directive;
import org.eclipse.jet.compiler.JET2Expression;
import org.eclipse.jet.compiler.JET2Scriptlet;
import org.eclipse.jet.compiler.TextElement;
import org.eclipse.jet.compiler.XMLBodyElement;
import org.eclipse.jet.compiler.XMLBodyElementEnd;
import org.eclipse.jet.compiler.XMLEmptyElement;
import org.eclipse.jet.internal.parser.LineInfo;

public class TextTrimmingVisitor
extends DefaultJET2ASTVisitor
implements JET2ASTVisitor {
    private void checkAndStrip(JET2ASTElement element) {
        if (element.removeLineWhenOtherwiseEmpty()) {
            JET2ASTElement prev = element.getPrevElement();
            JET2ASTElement next = element.getNextElement();
            if (this.endsWithEmtpyLine(prev) && this.startsWithEmptyLine(next)) {
                this.trimLastLine(prev);
                this.trimFirstLine(next);
            }
        }
    }

    private void trimLastLine(JET2ASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            text.setTrimLastLine(true);
        }
    }

    private void trimFirstLine(JET2ASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            text.setTrimFirstLine(true);
        }
    }

    private boolean startsWithEmptyLine(JET2ASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            LineInfo[] lines = text.getLines();
            if (lines.length > 0 && lines[0].hasDelimiter()) {
                LineInfo line = lines[0];
                if (new String(text.getRawText(), line.getStart(), line.getEnd() - line.getStart()).trim().length() == 0) {
                    return true;
                }
            }
        } else if (element == null) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean endsWithEmtpyLine(JET2ASTElement element) {
        if (element instanceof TextElement) {
            TextElement text = (TextElement)element;
            LineInfo[] lines = text.getLines();
            if (lines.length <= 0) return false;
            LineInfo line = lines[lines.length - 1];
            if (line.hasDelimiter()) {
                return true;
            }
            if (lines.length <= 1 || new String(text.getRawText(), line.getStart(), line.getEnd() - line.getStart()).trim().length() != 0) return false;
            return true;
        }
        if (element != null) return false;
        return true;
    }

    public void visit(JET2Declaration declaration) {
        this.checkAndStrip(declaration);
    }

    public void visit(JET2Directive directive) {
        this.checkAndStrip(directive);
    }

    public void visit(JET2Expression expression) {
        this.checkAndStrip(expression);
    }

    public void visit(JET2Scriptlet scriptlet) {
        this.checkAndStrip(scriptlet);
    }

    public void visit(XMLEmptyElement xmlEmptyElement) {
        this.checkAndStrip(xmlEmptyElement);
    }

    public void visit(XMLBodyElement xmlBodyElement) {
        this.checkAndStrip(xmlBodyElement);
    }

    public void visit(XMLBodyElementEnd xmlBodyElementEnd) {
        this.checkAndStrip(xmlBodyElementEnd);
    }

    public void visit(Comment comment) {
        this.checkAndStrip(comment);
    }
}

