/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.compiler.BodyElements;
import org.eclipse.jet.compiler.JET2AST;
import org.eclipse.jet.compiler.JET2ASTElement;
import org.eclipse.jet.compiler.JET2ASTVisitor;
import org.eclipse.jet.compiler.XMLBodyElementEnd;
import org.eclipse.jet.compiler.XMLElement;
import org.eclipse.jet.taglib.TagDefinition;

public final class XMLBodyElement
extends XMLElement {
    private BodyElements bodyElements = null;
    private XMLBodyElementEnd endTag = null;

    XMLBodyElement(JET2AST ast, int line, int colOffset, int start, int end, String name, Map attributes, TagDefinition td) {
        super(ast, line, colOffset, start, end, name, attributes, td);
    }

    BodyElements getInternalBodyElements() {
        if (this.bodyElements == null) {
            this.bodyElements = new BodyElements(this);
        }
        return this.bodyElements;
    }

    public final List getBodyElements() {
        if (this.bodyElements == null) {
            return Collections.EMPTY_LIST;
        }
        return this.bodyElements.getBodyElements();
    }

    public void accept(JET2ASTVisitor visitor) {
        visitor.visit(this);
        Iterator i = this.getBodyElements().iterator();
        while (i.hasNext()) {
            JET2ASTElement element = (JET2ASTElement)i.next();
            element.accept(visitor);
        }
        visitor.endVisit(this);
    }

    void setEndTag(XMLBodyElementEnd endTag) {
        this.endTag = endTag;
    }

    public final XMLBodyElementEnd getEndTag() {
        return this.endTag;
    }

    public String toString() {
        return "Line " + this.getLine() + ": <" + this.getName() + ">";
    }

    public JET2ASTElement getNextElement() {
        if (this.getBodyElements().size() > 0) {
            return (JET2ASTElement)this.getBodyElements().get(0);
        }
        return super.getNextElement();
    }
}

