/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.text.MessageFormat;
import org.eclipse.jet.internal.parser.ParseProblemSeverity;

public class Problem {
    public static final int MissingXmlStartTag = 1;
    public static final int MissingXmlEndTag = 2;
    public static final int MissingRequiredAttribute = 3;
    public static final int DuplicateXMLNamespacePrefix = 4;
    public static final int UnknownTagLibrary = 5;
    public static final int UnknownAttributeInTag = 6;
    public static final int UnterminatedXMLTag = 7;
    public static final int DuplicateAttribute = 8;
    public static final int JETException = 9;
    public static final int MultipleTemplatesWithSameJavaClass = 10;
    public static final int DeprecatedAttribute = 11;
    public static final int TagCannotHaveContent = 12;
    public static final int TagCannotBeEmpty = 13;
    public static final int DeprecatedTag = 14;
    public static final int UnsupportedDirective = 15;
    public static final int UnknownXMLTag = 16;
    public static final int TagInterpretedAsEmptyTag = 17;
    private final String originatingFileName;
    private final int id;
    private final String message;
    private final Object[] messageArgs;
    private final int start;
    private final int end;
    private final int lineNumber;
    private final ParseProblemSeverity severity;
    private final int colOffset;

    public Problem(String originatingFileName, ParseProblemSeverity severity, int id, String message, Object[] messageArgs, int start, int end, int lineNumber, int colOffset) {
        this.originatingFileName = originatingFileName;
        this.severity = severity;
        this.id = id;
        this.colOffset = colOffset;
        this.message = messageArgs != null && messageArgs.length > 0 ? MessageFormat.format(message, messageArgs) : message;
        this.messageArgs = messageArgs;
        this.start = start;
        this.end = end;
        this.lineNumber = lineNumber;
    }

    public int getEnd() {
        return this.end;
    }

    public int getId() {
        return this.id;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    public String getOriginatingFileName() {
        return this.originatingFileName;
    }

    public ParseProblemSeverity getSeverity() {
        return this.severity;
    }

    public int getStart() {
        return this.start;
    }

    public final int getColOffset() {
        return this.colOffset;
    }
}

