/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.WriterPositionException;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.Position;

public class BodyContentWriter
implements JET2Writer {
    private final BodyContentWriter parentWriter;
    private final IDocument document = new StringBufferDocument();
    private final Map listeners;

    public BodyContentWriter() {
        this.parentWriter = null;
        this.listeners = new LinkedHashMap(5);
    }

    private BodyContentWriter(BodyContentWriter parentWriter) {
        this.parentWriter = parentWriter;
        this.listeners = Collections.EMPTY_MAP;
    }

    public final void write(String string) {
        try {
            this.document.replace(this.document.getLength(), 0, string);
        }
        catch (BadLocationException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
    }

    public final void write(JET2Writer bodyContent) {
        int positionDelta = this.document.getLength();
        this.write(bodyContent.toString());
        try {
            IDocument childDocument = bodyContent.getDocument();
            String[] categories = childDocument.getPositionCategories();
            int i = 0;
            while (i < categories.length) {
                this.addPositionCategory(categories[i]);
                Position[] positions = childDocument.getPositions(categories[i]);
                int j = 0;
                while (j < positions.length) {
                    childDocument.removePosition(categories[i], positions[j]);
                    positions[j].setOffset(positions[j].getOffset() + positionDelta);
                    this.document.addPosition(categories[i], positions[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
        catch (BadLocationException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
    }

    public final void write(int i) {
        this.write(String.valueOf(i));
    }

    public String toString() {
        return this.document.get();
    }

    public final JET2Writer newNestedContentWriter() {
        return new BodyContentWriter(this);
    }

    public final int getLength() {
        return this.document.getLength();
    }

    public final IDocument getDocument() {
        return this.document;
    }

    public final void addEventListener(String category, IWriterListener listener) {
        if (this.parentWriter != null) {
            this.parentWriter.addEventListener(category, listener);
        } else if (!this.listeners.containsKey(category)) {
            this.listeners.put(category, listener);
        }
    }

    public final void finalizeContent(Object file) throws JET2TagException {
        Iterator i = this.listeners.values().iterator();
        while (i.hasNext()) {
            IWriterListener listener = (IWriterListener)i.next();
            listener.finalizeContent(this, file);
        }
    }

    public final void contentCommitted(Object committedObject) throws JET2TagException {
        Iterator i = this.listeners.values().iterator();
        while (i.hasNext()) {
            IWriterListener listener = (IWriterListener)i.next();
            listener.postCommitContent(this, committedObject);
        }
    }

    public final void addPositionCategory(String category) {
        if (!this.document.containsPositionCategory(category)) {
            this.document.addPositionCategory(category);
            this.document.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater(category));
        }
    }

    public final void addPosition(String category, Position position) {
        try {
            this.document.addPosition(category, position);
        }
        catch (BadLocationException e) {
            throw new WriterPositionException(e);
        }
        catch (BadPositionCategoryException e) {
            throw new WriterPositionException(e);
        }
    }

    public final Position[] getPositions(String category) {
        try {
            return this.document.getPositions(category);
        }
        catch (BadPositionCategoryException e) {
            throw new WriterPositionException(e);
        }
    }

    public final void replace(int offset, int length, String text) {
        try {
            this.document.replace(offset, length, text);
        }
        catch (BadLocationException e) {
            throw new WriterPositionException(e);
        }
    }

    public final JET2Writer getParentWriter() {
        return this.parentWriter;
    }

    public final void write(boolean b) {
        this.write(String.valueOf(b));
    }

    public final void write(char c) {
        this.write(String.valueOf(c));
    }

    public final void write(char[] data) {
        this.write(String.valueOf(data));
    }

    public final void write(double d) {
        this.write(String.valueOf(d));
    }

    public final void write(float f) {
        this.write(String.valueOf(f));
    }

    public final void write(long l) {
        this.write(String.valueOf(l));
    }

    public final void write(Object obj) {
        this.write(obj != null ? obj.toString() : "");
    }

    private static class StringBufferDocument
    extends AbstractDocument {
        public StringBufferDocument() {
            this.setTextStore(new StringBufferTextStore());
            this.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.completeInitialization();
        }
    }

    private static class StringBufferTextStore
    implements ITextStore {
        private final StringBuffer buffer = new StringBuffer();

        private StringBufferTextStore() {
        }

        public char get(int offset) {
            return this.buffer.charAt(offset);
        }

        public String get(int offset, int length) {
            return this.buffer.substring(offset, offset + length);
        }

        public void set(String text) {
            this.buffer.replace(0, this.buffer.length(), text);
        }

        public int getLength() {
            return this.buffer.length();
        }

        public void replace(int offset, int length, String text) {
            if (offset == this.buffer.length() && length == 0) {
                this.buffer.append(text);
            } else {
                this.buffer.replace(offset, offset + length, text);
            }
        }
    }
}

