/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.baseimpl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.internal.xtend.type.baseimpl.types.BooleanTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.CollectionTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.FeatureTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.IntegerTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.ListTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.ObjectTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.OperationTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.PropertyTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.RealTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.SetTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.StaticPropertyTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.StringTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.TypeTypeImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.VoidType;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuiltinMetaModel
implements MetaModel {
    public static final String OBJECT = "Object";
    public static final String STRING = "String";
    public static final String BOOLEAN = "Boolean";
    public static final String INTEGER = "Integer";
    public static final String REAL = "Real";
    public static final String COLLECTION = "Collection";
    public static final String SET = "Set";
    public static final String LIST = "List";
    public static final String TYPE = "xpand2::Type";
    public static final String FEATURE = "xpand2::Feature";
    public static final String PROPERTY = "xpand2::Property";
    public static final String OPERATION = "xpand2::Operation";
    private static final String STATIC_PROPERTY = "xpand2::StaticProperty";
    public static final String VOID = "Void";
    private Type stringType = null;
    private Type booleanType = null;
    private Type integerType = null;
    private Type realType = null;
    private Type objectType = null;
    private Type typeType = null;
    private Type featureType = null;
    private Type propertyType = null;
    private Type operationType = null;
    private Type staticPropertyType = null;
    private Type voidType = null;
    private final Map<String, Type> _builtinTypes = new HashMap<String, Type>();
    private TypeSystem typeSystem;
    private final Cache<Object, Type> typeCache = new Cache<Object, Type>(){
        {
            this.internal = new WeakHashMap();
        }

        @Override
        protected Type createNew(Object obj) {
            if (obj == null) {
                return BuiltinMetaModel.this.getVoidType();
            }
            if (obj instanceof Set) {
                return BuiltinMetaModel.this.getSetType(BuiltinMetaModel.this.getObjectType());
            }
            if (obj instanceof List) {
                return BuiltinMetaModel.this.getListType(BuiltinMetaModel.this.getObjectType());
            }
            if (obj instanceof Collection) {
                return BuiltinMetaModel.this.getCollectionType(BuiltinMetaModel.this.getObjectType());
            }
            if (BuiltinMetaModel.this.stringType.isInstance(obj)) {
                return BuiltinMetaModel.this.stringType;
            }
            if (BuiltinMetaModel.this.integerType.isInstance(obj)) {
                return BuiltinMetaModel.this.integerType;
            }
            if (BuiltinMetaModel.this.booleanType.isInstance(obj)) {
                return BuiltinMetaModel.this.booleanType;
            }
            if (BuiltinMetaModel.this.realType.isInstance(obj)) {
                return BuiltinMetaModel.this.realType;
            }
            if (BuiltinMetaModel.this.typeType.isInstance(obj)) {
                return BuiltinMetaModel.this.typeType;
            }
            if (BuiltinMetaModel.this.propertyType.isInstance(obj)) {
                return BuiltinMetaModel.this.propertyType;
            }
            if (BuiltinMetaModel.this.operationType.isInstance(obj)) {
                return BuiltinMetaModel.this.operationType;
            }
            if (BuiltinMetaModel.this.staticPropertyType.isInstance(obj)) {
                return BuiltinMetaModel.this.staticPropertyType;
            }
            return BuiltinMetaModel.this.objectType;
        }
    };
    HashSet<Type> _knownTypes;

    @Override
    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public BuiltinMetaModel(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
        this.stringType = new StringTypeImpl(this.getTypeSystem(), STRING);
        this.booleanType = new BooleanTypeImpl(this.getTypeSystem(), BOOLEAN);
        this.integerType = new IntegerTypeImpl(this.getTypeSystem(), INTEGER);
        this.realType = new RealTypeImpl(this.getTypeSystem(), REAL);
        this.objectType = new ObjectTypeImpl(this.getTypeSystem(), OBJECT);
        this.typeType = new TypeTypeImpl(this.getTypeSystem(), TYPE);
        this.featureType = new FeatureTypeImpl(this.getTypeSystem(), FEATURE);
        this.propertyType = new PropertyTypeImpl(this.getTypeSystem(), PROPERTY);
        this.staticPropertyType = new StaticPropertyTypeImpl(this.getTypeSystem(), STATIC_PROPERTY);
        this.operationType = new OperationTypeImpl(this.getTypeSystem(), OPERATION);
        this.voidType = new VoidType(this.getTypeSystem(), VOID);
        this._builtinTypes.put(OBJECT, this.objectType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Object.class.getName()), this.objectType);
        this._builtinTypes.put(VOID, this.voidType);
        this._builtinTypes.put(STRING, this.stringType);
        this._builtinTypes.put(BuiltinMetaModel.convert(String.class.getName()), this.stringType);
        this._builtinTypes.put(BuiltinMetaModel.convert(StringBuffer.class.getName()), this.stringType);
        this._builtinTypes.put(Character.TYPE.getName(), this.stringType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Character.class.getName()), this.stringType);
        this._builtinTypes.put(BOOLEAN, this.booleanType);
        this._builtinTypes.put(Boolean.TYPE.getName(), this.booleanType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Boolean.class.getName()), this.booleanType);
        this._builtinTypes.put(INTEGER, this.integerType);
        this._builtinTypes.put(Integer.TYPE.getName(), this.integerType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Integer.class.getName()), this.integerType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Long.class.getName()), this.integerType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Short.class.getName()), this.integerType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Byte.class.getName()), this.integerType);
        this._builtinTypes.put(BuiltinMetaModel.convert(BigInteger.class.getName()), this.integerType);
        this._builtinTypes.put(REAL, this.realType);
        this._builtinTypes.put(Double.TYPE.getName(), this.realType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Double.class.getName()), this.realType);
        this._builtinTypes.put(BuiltinMetaModel.convert(Float.class.getName()), this.realType);
        this._builtinTypes.put(BuiltinMetaModel.convert(BigDecimal.class.getName()), this.realType);
        this._builtinTypes.put(TYPE, this.typeType);
        this._builtinTypes.put(FEATURE, this.featureType);
        this._builtinTypes.put(PROPERTY, this.propertyType);
        this._builtinTypes.put(OPERATION, this.operationType);
        this._builtinTypes.put(STATIC_PROPERTY, this.staticPropertyType);
        this._builtinTypes.put(COLLECTION, this.getCollectionType(this.objectType));
        this._builtinTypes.put(Collection.class.getName(), this.getCollectionType(this.objectType));
        this._builtinTypes.put(BuiltinMetaModel.convert(Collection.class.getName()), this.getCollectionType(this.objectType));
        this._builtinTypes.put(SET, this.getSetType(this.objectType));
        this._builtinTypes.put(Set.class.getName(), this.getSetType(this.objectType));
        this._builtinTypes.put(BuiltinMetaModel.convert(Set.class.getName()), this.getSetType(this.objectType));
        this._builtinTypes.put(LIST, this.getListType(this.objectType));
        this._builtinTypes.put(List.class.getName(), this.getListType(this.objectType));
        this._builtinTypes.put(BuiltinMetaModel.convert(List.class.getName()), this.getListType(this.objectType));
        this._knownTypes = new HashSet<Type>(this._builtinTypes.values());
    }

    public String getName() {
        return "built-in";
    }

    public final Type getObjectType() {
        return this.objectType;
    }

    public final Type getBooleanType() {
        return this.booleanType;
    }

    public final Type getIntegerType() {
        return this.integerType;
    }

    public Type getRealType() {
        return this.realType;
    }

    public final Type getStringType() {
        return this.stringType;
    }

    public final Type getTypeType() {
        return this.typeType;
    }

    public final Type getFeatureType() {
        return this.featureType;
    }

    public final Type getPropertyType() {
        return this.propertyType;
    }

    public final Type getOperationType() {
        return this.operationType;
    }

    public Type getStaticPropertyType() {
        return this.staticPropertyType;
    }

    public final ParameterizedType getCollectionType(Type innerType) {
        return new CollectionTypeImpl(innerType, this.getTypeSystem(), COLLECTION);
    }

    public final ParameterizedType getListType(Type innerType) {
        return new ListTypeImpl(innerType, this.getTypeSystem(), LIST);
    }

    public final ParameterizedType getSetType(Type innerType) {
        return new SetTypeImpl(innerType, this.getTypeSystem(), SET);
    }

    @Override
    public Type getType(Object obj) {
        return this.typeCache.get(obj);
    }

    @Override
    public Type getTypeForName(String typeName) {
        return this._builtinTypes.get(typeName);
    }

    public Set<Type> getKnownTypes() {
        return this._knownTypes;
    }

    private static final String convert(String javaclassname) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < javaclassname.length()) {
            char c = javaclassname.charAt(i);
            if (c == '.') {
                sb.append("::");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public Type getVoidType() {
        return this.voidType;
    }

    @Override
    public void setTypeSystem(TypeSystem typeSystem) {
        if (typeSystem != null) {
            this.typeSystem = typeSystem;
        }
    }

    @Override
    public Set<String> getNamespaces() {
        return new HashSet<String>();
    }
}

