/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui.launching.strategy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitor;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.launching.strategy.IAcceleoLaunchingStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.debug.core.AcceleoDebugger;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoDebugTarget;
import org.eclipse.acceleo.internal.ide.ui.launching.AcceleoLaunchOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoPluginLaunchingStrategy
implements IAcceleoLaunchingStrategy {
    @Override
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject(configuration);
        if (project != null) {
            AcceleoDebugger debugger = null;
            if ("debug".equals(mode)) {
                debugger = new AcceleoDebugger(project);
                launch.addDebugTarget((IDebugTarget)new AcceleoDebugTarget(launch, debugger));
                AcceleoEvaluationVisitor.setDebug((IDebugAST)debugger);
                debugger.start();
            }
            try {
                String model = this.getModelPath(configuration);
                String target = this.getTargetPath(configuration);
                String message = model.length() == 0 ? AcceleoUIMessages.getString("AcceleoLaunchDelegate.MissingModel") : (target.length() == 0 ? AcceleoUIMessages.getString("AcceleoLaunchDelegate.MissingTarget") : null);
                if (message != null) {
                    AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", message));
                } else {
                    Path targetPath = new Path(target);
                    Object container = targetPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(targetPath.lastSegment()) : (targetPath.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)targetPath) : null);
                    if (container instanceof IFolder && !container.exists()) {
                        ((IFolder)container).create(true, true, monitor);
                    } else if (container instanceof IProject && !container.exists()) {
                        container.create(monitor);
                        container.open(monitor);
                        container.refreshLocal(2, monitor);
                    }
                    if (container != null) {
                        String qualifiedName = this.getMainType(configuration);
                        File targetFolder = container.getLocation().toFile();
                        List<String> args = this.getArguments(configuration);
                        this.launch(project, qualifiedName, model, targetFolder, args, monitor);
                        container.refreshLocal(2, monitor);
                    }
                }
            }
            finally {
                if ("debug".equals(mode)) {
                    AcceleoEvaluationVisitor.setDebug(null);
                    debugger.end();
                }
            }
        }
    }

    protected void launch(IProject project, String qualifiedName, String model, File targetFolder, List<String> args, IProgressMonitor monitor) {
        AcceleoLaunchOperation operation = new AcceleoLaunchOperation(project, qualifiedName, model, targetFolder, args);
        try {
            operation.run(monitor);
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
    }

    protected IProject getProject(ILaunchConfiguration configuration) {
        String projectName;
        try {
            projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException e) {
            projectName = "";
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.isAccessible()) {
            return project;
        }
        return null;
    }

    protected String getMainType(ILaunchConfiguration configuration) {
        String type = "";
        try {
            type = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        }
        catch (CoreException e) {
            type = "";
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return type;
    }

    protected String getModelPath(ILaunchConfiguration configuration) {
        String model = "";
        try {
            model = configuration.getAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH", "");
        }
        catch (CoreException e) {
            model = "";
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return model;
    }

    protected String getTargetPath(ILaunchConfiguration configuration) {
        String target = "";
        try {
            target = configuration.getAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH", "");
        }
        catch (CoreException e) {
            target = "";
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return target;
    }

    protected List<String> getArguments(ILaunchConfiguration configuration) {
        String args = "";
        try {
            args = configuration.getAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS", "");
        }
        catch (CoreException e) {
            args = "";
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(args, "\n");
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }
        return result;
    }
}

