/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoServicesEclipseUtil {
    private static final Set<String> REGISTERED_SERVICES = new LinkedHashSet<String>();

    private AcceleoServicesEclipseUtil() {
    }

    public static void clearRegistry() {
        REGISTERED_SERVICES.clear();
    }

    public static Set<Object> getRegisteredServices() {
        return AcceleoWorkspaceUtil.INSTANCE.refreshInstances(REGISTERED_SERVICES, false);
    }

    public static Object getService(String qualifiedName) {
        return AcceleoWorkspaceUtil.INSTANCE.refreshInstance(qualifiedName, false);
    }

    public static Object registerService(Bundle bundle, String qualifiedName) {
        Object instance = null;
        try {
            Class clazz = bundle.loadClass(qualifiedName);
            instance = clazz.newInstance();
            if (instance != null) {
                REGISTERED_SERVICES.add(qualifiedName);
            }
        }
        catch (ClassNotFoundException e) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassLookupFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        catch (IllegalAccessException e) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassConstructorFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        catch (InstantiationException e) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassInstantiationFailure", qualifiedName, bundle.getSymbolicName()), e, false);
        }
        return instance;
    }

    public static Object registerService(IProject project, String qualifiedName) {
        AcceleoWorkspaceUtil.INSTANCE.addWorkspaceContribution(project);
        AcceleoWorkspaceUtil.INSTANCE.refreshContributions();
        Object instance = AcceleoWorkspaceUtil.INSTANCE.getClassInstance(qualifiedName);
        if (instance != null) {
            REGISTERED_SERVICES.add(qualifiedName);
        }
        return instance;
    }

    public static Object registerService(String bundleName, String qualifiedName) {
        Object instance = null;
        IProject project = AcceleoWorkspaceUtil.INSTANCE.getProject(bundleName);
        instance = project != null ? AcceleoServicesEclipseUtil.registerService(project, qualifiedName) : AcceleoServicesEclipseUtil.registerService(Platform.getBundle((String)bundleName), qualifiedName);
        return instance;
    }
}

