/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.samples.wizards.launch;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.m2m.internal.qvt.oml.samples.wizards.launch.ILaunchData;

public class Launch {
    private String myLaunchName;
    private final ILaunchData myLaunchData;

    public Launch(String defaultLaunchName, ILaunchData launchData) {
        this.myLaunchName = defaultLaunchName;
        this.myLaunchData = launchData;
    }

    public String getLaunchName() {
        return this.myLaunchName;
    }

    public void setLaunchName(String newLaunchName) {
        this.myLaunchName = newLaunchName;
    }

    public void registerLaunchConfiguration(IContainer location) throws CoreException {
        String transformationType = this.myLaunchData.getTransformationType();
        String configName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(this.getLaunchName());
        ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(transformationType);
        ILaunchConfigurationWorkingCopy store = launchType.newInstance(location, configName);
        Map<String, Object> attributesMap = this.myLaunchData.getAttributesMap();
        for (String atrKey : attributesMap.keySet()) {
            Object atrVal = attributesMap.get(atrKey);
            if (atrVal == null) {
                throw new IllegalStateException(atrKey);
            }
            this.setAttribute(store, atrKey, atrVal);
        }
        ILaunchConfiguration launchConfig = store.doSave();
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)new org.eclipse.debug.core.Launch(launchConfig, "debug", null));
    }

    private void setAttribute(ILaunchConfigurationWorkingCopy store, String atrKey, Object atrVal) {
        if (atrVal instanceof String) {
            String string = (String)atrVal;
            store.setAttribute(atrKey, string);
            return;
        }
        if (atrVal instanceof Map) {
            Map map = (Map)atrVal;
            store.setAttribute(atrKey, map);
            return;
        }
        if (atrVal instanceof Boolean) {
            Boolean bool = (Boolean)atrVal;
            store.setAttribute(atrKey, bool.booleanValue());
            return;
        }
        if (atrVal instanceof Integer) {
            Integer val = (Integer)atrVal;
            store.setAttribute(atrKey, val.intValue());
            return;
        }
        if (atrVal instanceof List) {
            List list = (List)atrVal;
            store.setAttribute(atrKey, list);
            return;
        }
        throw new IllegalArgumentException(atrVal.toString());
    }
}

