/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.viewsupport;

import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.m2m.atl.adt.ui.viewsupport.IProblemChangedListener;

public class ProblemMarkerManager
implements IResourceChangeListener {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private ListenerList fListeners = new ListenerList();

    public void resourceChanged(IResourceChangeEvent event) {
        HashSet changedElements = new HashSet();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(changedElements));
            }
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        if (!changedElements.isEmpty()) {
            IResource[] changes = changedElements.toArray(new IResource[changedElements.size()]);
            this.fireChanges(changes, true);
        }
    }

    public void addListener(IProblemChangedListener listener) {
        if (this.fListeners.isEmpty()) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IProblemChangedListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    private void fireChanges(final IResource[] changes, final boolean isMarkerChange) {
        Thread fireChange = new Thread(){

            public void run() {
                Object[] listeners = ProblemMarkerManager.this.fListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IProblemChangedListener curr = (IProblemChangedListener)listeners[i];
                    curr.problemsChanged(changes, isMarkerChange);
                    ++i;
                }
            }
        };
        fireChange.start();
    }

    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet changedElements;

        public ProjectErrorVisitor(HashSet changedElements) {
            this.changedElements = changedElements;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IProject project;
            IResource res = delta.getResource();
            if (res instanceof IProject && delta.getKind() == 4 && !(project = (IProject)res).isAccessible()) {
                return false;
            }
            this.checkInvalidate(delta, res);
            return true;
        }

        private void checkInvalidate(IResourceDelta delta, IResource resource) {
            int kind = delta.getKind();
            if (kind == 2 || kind == 1 || kind == 4 && this.isErrorDelta(delta)) {
                while (resource.getType() != 8 && this.changedElements.add(resource)) {
                    resource = resource.getParent();
                }
            }
        }

        private boolean isErrorDelta(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
                int i = 0;
                while (i < markerDeltas.length) {
                    if (markerDeltas[i].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int kind = markerDeltas[i].getKind();
                        if (kind == 1 || kind == 2) {
                            return true;
                        }
                        int severity = markerDeltas[i].getAttribute("severity", -1);
                        int newSeverity = markerDeltas[i].getMarker().getAttribute("severity", -1);
                        if (newSeverity != severity) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

