/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionDataSource;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

public class AtlCompletionHelper {
    private static final String[] PARSING_KEYWORDS = new String[]{"rule", "helper"};
    private static final String[] HIGH_LEVEL_KEYWORDS = new String[]{"rule", "helper", "from", "to", "do", "using", "module"};
    private IDocument document;

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public AtlModelAnalyser computeContext(int offset, String prefix) throws BadLocationException {
        int begin = 0;
        int[] lastParsingKeyWordLocation = this.getLastKeyWordLocation(offset - prefix.length(), PARSING_KEYWORDS);
        begin = lastParsingKeyWordLocation[0];
        String lastParsingKeyWord = null;
        if (begin > 0) {
            lastParsingKeyWord = this.document.get(lastParsingKeyWordLocation[0], lastParsingKeyWordLocation[1]);
            int lineNumber = this.document.getLineOfOffset(begin);
            begin = this.document.getLineOffset(lineNumber);
        }
        int end = offset;
        String text = this.document.get(begin, end - begin);
        if (prefix.equals("")) {
            text = String.valueOf(text) + "a";
        } else if (prefix.startsWith("'")) {
            text = String.valueOf(text) + "'";
        }
        if (lastParsingKeyWord == null) {
            return new AtlModelAnalyser(this, null, begin, this.getLastKeyWord(offset - prefix.length()), offset);
        }
        EObject[] ret = AtlParser.getDefault().parseExpression(text, lastParsingKeyWord);
        AtlModelAnalyser res = new AtlModelAnalyser(this, ret[0], begin, this.getLastKeyWord(offset - prefix.length()), offset);
        return res;
    }

    public int[] getElementOffsets(EObject element, int baseOffset) throws BadLocationException {
        Object loc = AtlCompletionDataSource.eGet(element, "location");
        if (loc != null) {
            String location = loc.toString();
            location = location.replaceAll("'", "");
            int linesToAdd = this.document.getLineOfOffset(baseOffset);
            int columnsToAdd = baseOffset - this.document.getLineOffset(this.document.getLineOfOffset(baseOffset));
            int debLine = new Integer(location.split("-")[0].split(":")[0]) + linesToAdd;
            int debColumn = new Integer(location.split("-")[0].split(":")[1]) + columnsToAdd;
            int endLine = new Integer(location.split("-")[1].split(":")[0]) + linesToAdd;
            int endColumn = new Integer(location.split("-")[1].split(":")[1]) + columnsToAdd;
            int debOffset = this.document.getLineOffset(debLine - 1) + debColumn - 1;
            int endOffset = this.document.getLineOffset(endLine - 1) + endColumn - 1;
            return new int[]{debOffset, endOffset};
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public String extractPrefix(int offset) {
        i = offset;
        if (i <= this.document.getLength()) ** GOTO lbl6
        return "";
        {
            while (!Character.isWhitespace(ch = this.document.getChar(i - 1))) {
                --i;
lbl6:
                // 2 sources

                if (i > 0) continue;
            }
            return this.document.get(i, offset - i);
        }
    }

    public String getCurrentLine(int offset) throws BadLocationException {
        if (offset >= 0) {
            int lineNumber = this.document.getLineOfOffset(offset);
            int lineOffset = this.document.getLineOffset(lineNumber);
            return this.document.get(lineOffset, offset - lineOffset);
        }
        return null;
    }

    public String getLastKeyWord(int offset) throws BadLocationException {
        int[] location = this.getLastKeyWordLocation(offset, HIGH_LEVEL_KEYWORDS);
        if (location[0] > 0) {
            return this.document.get(location[0], location[1]);
        }
        return null;
    }

    private int[] getLastKeyWordLocation(int offset, String[] keywords) throws BadLocationException {
        int bestindex = 0;
        String nearestKeyword = "";
        int i = 0;
        while (i < keywords.length) {
            String keyword = keywords[i];
            int lastindex = this.getLastKeyWordLocation(offset, keyword)[0];
            if (lastindex > 0 && lastindex > bestindex) {
                bestindex = lastindex;
                nearestKeyword = keyword;
            }
            ++i;
        }
        return new int[]{bestindex, nearestKeyword.length()};
    }

    private int[] getLastKeyWordLocation(int offset, String keyword) throws BadLocationException {
        int lastindex = this.document.get().lastIndexOf(keyword, offset - 1);
        String line = this.getCurrentLine(lastindex);
        if (line != null && line.indexOf("--") > -1) {
            return this.getLastKeyWordLocation(this.document.get().lastIndexOf("--", offset - 1), keyword);
        }
        return new int[]{lastindex, keyword.length()};
    }
}

