/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.internal.xpand.build.OawBuilder;
import org.eclipse.gmf.internal.xpand.migration.Activator;
import org.eclipse.jdt.core.IJavaProject;

public class OAWBuilderPropertyTester
extends PropertyTester {
    private static final String HAS_OAW_BUILDER_PROPERTY = "hasOAWBuilder";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (HAS_OAW_BUILDER_PROPERTY.equals(property)) {
            if (receiver instanceof IJavaProject) {
                return this.hasOAWBuilder(((IJavaProject)receiver).getProject());
            }
            if (receiver instanceof IProject) {
                return this.hasOAWBuilder((IProject)receiver);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasOAWBuilder(IProject project) {
        try {
            ICommand[] buildSpecification;
            if (!project.isOpen()) return false;
            ICommand[] iCommandArray = buildSpecification = project.getDescription().getBuildSpec();
            int n = buildSpecification.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand buildCommand = iCommandArray[n2];
                if (OawBuilder.getBUILDER_ID().equals(buildCommand.getBuilderName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.logError((Exception)((Object)e));
        }
        return false;
    }
}

