/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanOperation
extends Expression {
    private static final String IMPLIES = "implies";
    private static final String OR = "||";
    private static final String AND = "&&";
    private String operator;
    private Expression left;
    private Expression right;

    public BooleanOperation(int start, int end, int line, int startOffset, int endOffset, String operator, Expression e, Expression r) {
        super(start, end, line, startOffset, endOffset);
        assert (operator != null);
        this.operator = operator;
        this.left = e;
        this.right = r;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Boolean l = this.evaluateToBoolean(this.left, ctx);
        if (l == null) {
            return null;
        }
        if (this.isAndOperation()) {
            if (!l.booleanValue()) {
                return Boolean.FALSE;
            }
            Boolean r = this.evaluateToBoolean(this.right, ctx);
            if (r == null) {
                return null;
            }
            return l != false && r != false;
        }
        if (this.isOrOperation()) {
            if (l.booleanValue()) {
                return Boolean.TRUE;
            }
            Boolean r = this.evaluateToBoolean(this.right, ctx);
            if (r == null) {
                return null;
            }
            return l != false || r != false;
        }
        if (this.isImpliesOperation()) {
            if (!l.booleanValue()) {
                return Boolean.TRUE;
            }
            return this.evaluateToBoolean(this.right, ctx);
        }
        throw new EvaluationException("Unkown Boolean operator " + this.operator, (SyntaxElement)this);
    }

    private Boolean evaluateToBoolean(Expression expr, ExecutionContext ctx) {
        Object l = expr.evaluate(ctx);
        if (l == null) {
            return null;
        }
        if (!(l instanceof Boolean)) {
            EClassifier t = BuiltinMetaModel.getType(l);
            throw new EvaluationException("Boolean expected but was " + t.getName(), (SyntaxElement)expr);
        }
        return (Boolean)l;
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier l = this.left.analyze(ctx, issues);
        EClassifier r = this.right.analyze(ctx, issues);
        if (l == null || r == null) {
            return null;
        }
        EDataType dt = EcorePackage.eINSTANCE.getEBoolean();
        if (!dt.equals(l)) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Boolean expected! Found : " + l.getName(), this.left));
        }
        if (!dt.equals(r)) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Boolean expected! Found : " + r.getName(), this.right));
        }
        return dt;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public boolean isImpliesOperation() {
        return this.operator.equals(IMPLIES);
    }

    public boolean isOrOperation() {
        return this.operator.equals(OR);
    }

    public boolean isAndOperation() {
        return this.operator.equals(AND);
    }

    public String getOperator() {
        return this.operator;
    }
}

