/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.commands.core.command;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class AbstractTransactionalCommandTest
extends TestCase {
    private IOperationHistory history;

    public static void main(String[] args) {
        TestRunner.run((Test)AbstractTransactionalCommandTest.suite());
    }

    public static Test suite() {
        return new TestSuite(AbstractTransactionalCommandTest.class);
    }

    public AbstractTransactionalCommandTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.history = OperationHistoryFactory.getOperationHistory();
    }

    private List getFiles(String str) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(java.net.URI.create(str));
        return Arrays.asList(files);
    }

    public void test_execute_undo_redo() {
        String name = "test_execute_undo_redo";
        TestCommand c = new TestCommand(name, null);
        ObjectUndoContext ctx = new ObjectUndoContext((Object)this);
        try {
            c.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        c.assertExecuted();
        try {
            AbstractTransactionalCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        c.assertUndone();
        try {
            AbstractTransactionalCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        c.assertRedone();
    }

    public void test_compose() {
        String name = "test_compose";
        UndoContext ctx1 = new UndoContext();
        UndoContext ctx2 = new UndoContext();
        TestCommand c1 = new TestCommand(name, this.getFiles("null:/compose1"));
        c1.addContext((IUndoContext)ctx1);
        TestCommand c2 = new TestCommand(name, this.getFiles("null:/compose2"));
        c2.addContext((IUndoContext)ctx2);
        ICommand composition = c1.compose((IUndoableOperation)c2);
        List affectedFiles = composition.getAffectedFiles();
        AbstractTransactionalCommandTest.assertTrue((boolean)affectedFiles.containsAll(c1.getAffectedFiles()));
        AbstractTransactionalCommandTest.assertTrue((boolean)affectedFiles.containsAll(c2.getAffectedFiles()));
        AbstractTransactionalCommandTest.assertEquals((int)(c1.getAffectedFiles().size() + c2.getAffectedFiles().size()), (int)affectedFiles.size());
        List<IUndoContext> contexts = Arrays.asList(composition.getContexts());
        AbstractTransactionalCommandTest.assertTrue((boolean)contexts.contains(ctx1));
        AbstractTransactionalCommandTest.assertTrue((boolean)contexts.contains(ctx2));
    }

    public void test_reduce() {
        String name = "test_reduce";
        TestCommand c = new TestCommand(name, null);
        ICommand reduction = c.reduce();
        AbstractTransactionalCommandTest.assertSame((Object)((Object)c), (Object)reduction);
    }

    public void test_getAffectedFiles() {
        String fixtureName = "test_getAffectedFiles";
        TestCommand c = new TestCommand(fixtureName, null);
        AbstractTransactionalCommandTest.assertTrue((boolean)c.getAffectedFiles().isEmpty());
        List affectedFiles = this.getFiles("null:/AbstractTransactionalCommandTest");
        c = new TestCommand(fixtureName, affectedFiles);
        AbstractTransactionalCommandTest.assertEquals((int)affectedFiles.size(), (int)c.getAffectedFiles().size());
        AbstractTransactionalCommandTest.assertTrue((boolean)c.getAffectedFiles().containsAll(affectedFiles));
    }

    public void test_statusOnRollback_142025() {
        String name = "test_statusOnRollback_142025";
        TestCommand c = new TestCommand(name, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                CommandResult result = super.doExecuteWithResult(progressMonitor, info);
                EFactory logicFactory = SemanticPackage.eINSTANCE.getEFactoryInstance();
                EObject circuit = logicFactory.create(SemanticPackage.eINSTANCE.getCircuit());
                Resource resource = this.getEditingDomain().getResourceSet().createResource(URI.createURI((String)"null://org.eclipse.gmf.tests.runtime.emf.commands.core"));
                resource.getContents().add((Object)circuit);
                return result;
            }
        };
        ObjectUndoContext ctx = new ObjectUndoContext((Object)this);
        IStatus status = null;
        try {
            c.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        CommandResult result = c.getCommandResult();
        AbstractTransactionalCommandTest.assertSame((Object)status, (Object)result.getStatus());
        AbstractTransactionalCommandTest.assertTrue((boolean)result.getStatus().isOK());
        ResourceSetListenerImpl listener = new ResourceSetListenerImpl(){

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                throw new RollbackException(Status.CANCEL_STATUS);
            }
        };
        TransactionalEditingDomain domain = c.getEditingDomain();
        domain.addResourceSetListener((ResourceSetListener)listener);
        ctx = new ObjectUndoContext((Object)this);
        status = null;
        try {
            c.addContext((IUndoContext)ctx);
            status = this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            AbstractTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        result = c.getCommandResult();
        AbstractTransactionalCommandTest.assertSame((Object)status, (Object)result.getStatus());
        AbstractTransactionalCommandTest.assertEquals((int)8, (int)result.getStatus().getSeverity());
    }

    protected static class TestCommand
    extends AbstractTransactionalCommand {
        private static final String EXECUTED = "executed";
        private boolean executed;
        private boolean undone;
        private boolean redone;

        public TestCommand(String label, List affectedFiles) {
            super(TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(), label, affectedFiles);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = true;
            this.undone = false;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)EXECUTED);
        }

        public void assertExecuted() {
            AbstractTransactionalCommandTest.assertTrue((boolean)this.executed);
            AbstractTransactionalCommandTest.assertFalse((boolean)this.undone);
            AbstractTransactionalCommandTest.assertFalse((boolean)this.redone);
            AbstractTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            AbstractTransactionalCommandTest.assertSame((Object)EXECUTED, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertUndone() {
            AbstractTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            AbstractTransactionalCommandTest.assertNull((Object)this.getCommandResult().getReturnValue());
        }

        public void assertRedone() {
            AbstractTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            AbstractTransactionalCommandTest.assertNull((Object)this.getCommandResult().getReturnValue());
        }
    }
}

