/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfExpression
extends Expression {
    private Expression condition;
    private Expression thenPart;
    private Expression elsePart;

    public IfExpression(int start, int end, int line, Expression condition, Expression thenPart, Expression elsePart) {
        super(start, end, line);
        this.condition = condition;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getElsePart() {
        return this.elsePart;
    }

    public Expression getThenPart() {
        return this.thenPart;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object val = this.getCondition().evaluate(ctx);
        if (!(val instanceof Boolean)) {
            throw new EvaluationException("Boolean expected!", (SyntaxElement)this.getCondition());
        }
        if (((Boolean)val).booleanValue()) {
            return this.getThenPart().evaluate(ctx);
        }
        return this.getElsePart().evaluate(ctx);
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier conditionEClassifier = this.getCondition().analyze(ctx, issues);
        if (conditionEClassifier != null && !conditionEClassifier.equals(EcorePackage.eINSTANCE.getEBoolean())) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "Boolean expected", this.getCondition()));
        }
        EClassifier thenPartEClassifier = this.getThenPart().analyze(ctx, issues);
        EClassifier elsePartEClassifier = this.getElsePart().analyze(ctx, issues);
        if (thenPartEClassifier == null || elsePartEClassifier == null) {
            return null;
        }
        if (BuiltinMetaModel.isAssignableFrom(thenPartEClassifier, elsePartEClassifier)) {
            return elsePartEClassifier;
        }
        if (BuiltinMetaModel.isAssignableFrom(elsePartEClassifier, thenPartEClassifier)) {
            return thenPartEClassifier;
        }
        return EcorePackage.eINSTANCE.getEObject();
    }

    public String toString() {
        return String.valueOf(this.condition.toString()) + " ? " + this.thenPart + ":" + this.elsePart;
    }
}

