/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.migration;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContext;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.LabeledContainer;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.internal.common.ToolingResourceFactory;
import org.eclipse.gmf.internal.common.migrate.MigrationResource;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureInitializer;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.Language;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.ReferenceNewElementSpec;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.mappings.ValueExpression;
import org.eclipse.gmf.tests.Plugin;

public class MigrationPatchesTest
extends TestCase {
    public MigrationPatchesTest(String name) {
        super(name);
    }

    public void testPatch_138440() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("patch_138440.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected IllegalArgumentException from metamodel EFactory", (boolean)(caughtGenException instanceof IllegalArgumentException));
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        URI newGenUri = this.temporarySaveMigratedModel(genmodelFileName, "patch_138440", "gmfgen");
        this.assertNoOrdinaryLoadModelProblems(newGenUri);
        URI gmfmapmodelFileName = MigrationPatchesTest.createURI("patch_138440.gmfmap");
        Exception caughtMapException = this.assertOrdinaryLoadModelProblems(gmfmapmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected IllegalArgumentException from metamodel EFactory", (boolean)(caughtMapException instanceof IllegalArgumentException));
        this.assertOnLoadModelMigrationSuccess(gmfmapmodelFileName);
        URI newMapUri = this.temporarySaveMigratedModel(gmfmapmodelFileName, "patch_138440", "gmfmap");
        this.changeNsUriToOldOne(newMapUri, "gmfmap", "http://www.eclipse.org/gmf/2005/mappings/2.0");
        this.assertOnLoadModelMigrationDidNothing(newMapUri);
    }

    public void testPatch_161380() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("patch_161380.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        URI newGenUri = this.temporarySaveMigratedModel(genmodelFileName, "patch_138440", "gmfgen");
        this.changeNsUriToOldOne(newGenUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newGenUri);
        URI gmfmapmodelFileName = MigrationPatchesTest.createURI("patch_161380.gmfmap");
        Exception caughtMapException = this.assertOrdinaryLoadModelProblems(gmfmapmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtMapException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(gmfmapmodelFileName);
        URI newUri = this.temporarySaveMigratedModel(gmfmapmodelFileName, "patch_161380", "gmfmap");
        this.changeNsUriToOldOne(newUri, "gmfmap", "http://www.eclipse.org/gmf/2005/mappings/2.0");
        this.assertOnLoadModelMigrationDidNothing(newUri);
    }

    static URI createURI(String testModelFileName) {
        try {
            return Plugin.createURI("/models/migration/" + testModelFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            MigrationPatchesTest.fail((String)"Could not create test model URI");
            return null;
        }
    }

    void assertOnLoadModelMigrationSuccess(URI uri) throws Exception {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), uri);
        EList errors = loadHelper.getLoadedResource().getErrors();
        for (Resource.Diagnostic d : errors) {
            if (!(d instanceof WrappedException)) continue;
            ((WrappedException)d).exception().printStackTrace();
        }
        MigrationPatchesTest.assertTrue((String)("Errors found after migration: " + errors), (boolean)errors.isEmpty());
        MigrationPatchesTest.assertTrue((String)"Migration warning load status expected", (boolean)loadHelper.getStatus().matches(2));
        ArrayList warnings = new ArrayList();
        for (Resource nextResource : loadHelper.getLoadedResource().getResourceSet().getResources()) {
            warnings.addAll(nextResource.getWarnings());
        }
        for (Resource.Diagnostic warning : warnings) {
            MigrationPatchesTest.assertTrue((String)"Migration Warning diagnostic expected", (boolean)(warning instanceof MigrationResource.Diagnostic));
        }
        MigrationPatchesTest.assertTrue((boolean)(loadHelper.getLoadedResource() instanceof XMLResource));
        XMLResource xmlResource = (XMLResource)loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((String)"Unknown elements were found after migration", (int)0, (int)xmlResource.getEObjectToExtensionMap().size());
    }

    void assertOnLoadModelMigrationDidNothing(URI uri) throws Exception {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), uri);
        EList errors = loadHelper.getLoadedResource().getErrors();
        MigrationPatchesTest.assertTrue((String)("Errors after re-run migration on new migrated model: " + errors), (boolean)errors.isEmpty());
        EList warnings = loadHelper.getLoadedResource().getWarnings();
        MigrationPatchesTest.assertTrue((String)("Warnings after re-run migration on new migrated model: " + warnings), (boolean)warnings.isEmpty());
        MigrationPatchesTest.assertTrue((boolean)(loadHelper.getLoadedResource() instanceof XMLResource));
        XMLResource xmlResource = (XMLResource)loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((String)"Unknown elements were found after re-migration", (int)0, (int)xmlResource.getEObjectToExtensionMap().size());
    }

    Exception assertOrdinaryLoadModelProblems(URI uri) throws Exception {
        Resource resource = new ToolingResourceFactory().createResource(uri);
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getResources().add((Object)resource);
        RuntimeException caughtException = null;
        try {
            rset.getResource(uri, true);
        }
        catch (RuntimeException e) {
            caughtException = e;
        }
        MigrationPatchesTest.assertTrue((String)"Expected model loading problems", (caughtException != null || !resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty() ? 1 : 0) != 0);
        return caughtException;
    }

    Resource assertNoOrdinaryLoadModelProblems(URI uri) throws Exception {
        Resource resource = new ToolingResourceFactory().createResource(uri);
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.getResources().add((Object)resource);
        RuntimeException caughtException = null;
        try {
            rset.getResource(uri, true);
        }
        catch (RuntimeException e) {
            caughtException = e;
        }
        MigrationPatchesTest.assertFalse((String)"Unexpected model loading problems", (caughtException != null || !resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty() ? 1 : 0) != 0);
        return resource;
    }

    public void testGenDiagram() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("testGenDiagram.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        URI newUri = this.temporarySaveMigratedModel(genmodelFileName, "testGenDiagram", "gmfgen");
        this.changeNsUriToOldOne(newUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newUri);
    }

    public void testFeatureLabelModelFacet() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("testFeatureLabelModelFacet.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        this.checkFeatureLabelModelFacetsMigrated(genmodelFileName);
        URI newUri = this.temporarySaveMigratedModel(genmodelFileName, "testFeatureLabelModelFacet", "gmfgen");
        this.changeNsUriToOldOne(newUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newUri);
        this.checkFeatureLabelModelFacetsMigrated(newUri);
    }

    public void testGenAuditRootDefaultAndNested() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("testGenAuditRootDefaultAndNested.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        URI newUri = this.temporarySaveMigratedModel(genmodelFileName, "testGenAuditRootDefaultAndNested", "gmfgen");
        this.changeNsUriToOldOne(newUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newUri);
    }

    public void testGenAuditRootNoDefaultButNested() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("testGenAuditRootNoDefaultButNested.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
    }

    public void testGenAudits() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("testGenAudits.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        URI newUri = this.temporarySaveMigratedModel(genmodelFileName, "testGenAudits", "gmfgen");
        this.changeNsUriToOldOne(newUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newUri);
    }

    public void testGenEditorAuditRootNoDefaultButNested() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("testGenEditorAuditRootNoDefaultButNested.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        URI newUri = this.temporarySaveMigratedModel(genmodelFileName, "testGenEditorAuditRootNoDefaultButNested", "gmfgen");
        this.changeNsUriToOldOne(newUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newUri);
    }

    public void testGenAuditsCorrectCategories() throws Exception {
        URI genmodelFileName = MigrationPatchesTest.createURI("testGenAuditsCorrectCategories.gmfgen");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(genmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(genmodelFileName);
        this.checkModelAndCorrectCategories(genmodelFileName);
        URI newUri = this.temporarySaveMigratedModel(genmodelFileName, "testGenAuditsCorrectCategories", "gmfgen");
        this.changeNsUriToOldOne(newUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newUri);
        this.checkModelAndCorrectCategories(newUri);
    }

    private URI temporarySaveMigratedModel(URI uri, String tempFilename, String tempFileExtension) throws IOException {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), uri);
        Resource resource = loadHelper.getLoadedResource();
        ResourceSet resourceSet = resource.getResourceSet();
        URI newUri = null;
        for (Resource nextResource : resourceSet.getResources()) {
            File newGenmodelFile = File.createTempFile(tempFilename, tempFileExtension.startsWith(".") ? tempFileExtension : "." + tempFileExtension);
            newGenmodelFile.deleteOnExit();
            nextResource.setURI(URI.createFileURI((String)newGenmodelFile.getAbsolutePath()));
            if (!nextResource.equals(resource)) continue;
            newUri = nextResource.getURI();
        }
        for (Resource nextResource : resourceSet.getResources()) {
            try {
                nextResource.save(null);
            }
            catch (IOException ex) {
                MigrationPatchesTest.fail((String)ex.toString());
            }
        }
        return newUri;
    }

    private void changeNsUriToOldOne(URI newUri, String nsPrefix, String nsUri) throws IOException {
        Path path = new Path(newUri.toFileString());
        File file = path.toFile();
        FileReader reader = new FileReader(file);
        char[] chars = new char[100000];
        int length = reader.read(chars);
        String content = new String(chars, 0, length).replaceFirst("xmlns:" + nsPrefix + "=\"[^\"]+\"", "xmlns:" + nsPrefix + "=\"" + nsUri + "\"");
        FileWriter writer = new FileWriter(file);
        writer.write(content.toCharArray());
        writer.flush();
    }

    private void checkModelAndCorrectCategories(URI uri) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), uri);
        Resource resource = loadHelper.getLoadedResource();
        int allContentsSize = 0;
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            ++allContentsSize;
            if (next instanceof GenEditorGenerator) {
                GenEditorGenerator genEditor = (GenEditorGenerator)next;
                MigrationPatchesTest.assertNotNull((Object)genEditor.getAudits());
                continue;
            }
            if (next instanceof GenAuditRoot) {
                GenAuditRoot root = (GenAuditRoot)next;
                MigrationPatchesTest.assertFalse((boolean)root.getCategories().isEmpty());
                MigrationPatchesTest.assertFalse((boolean)root.getRules().isEmpty());
                MigrationPatchesTest.assertEquals((int)3, (int)root.getCategories().size());
                MigrationPatchesTest.assertEquals((int)3, (int)root.getRules().size());
                continue;
            }
            if (next instanceof GenAuditContainer) {
                GenAuditContainer nextContainer = (GenAuditContainer)next;
                MigrationPatchesTest.assertFalse((boolean)nextContainer.getAudits().isEmpty());
                MigrationPatchesTest.assertEquals((int)nextContainer.getAudits().size(), (int)1);
                continue;
            }
            if (!(next instanceof GenAuditRule)) continue;
            GenAuditRule nextRule = (GenAuditRule)next;
            GenAuditContainer nextCategory = nextRule.getCategory();
            MigrationPatchesTest.assertNotNull((Object)nextCategory);
            MigrationPatchesTest.assertEquals((String)"Audit rule expected to be placed to correct audit category after migration", (String)("rule:" + nextCategory.getId()), (String)nextRule.getId());
        }
        MigrationPatchesTest.assertEquals((int)8, (int)allContentsSize);
    }

    public void testNotChangingOrderOfLabelMappings() throws Exception {
        URI gmfmapmodelFileName = MigrationPatchesTest.createURI("testNotChangingOrderOfLabelMappings.gmfmap");
        Exception caughtMapException = this.assertOrdinaryLoadModelProblems(gmfmapmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtMapException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(gmfmapmodelFileName);
        this.checkOrderOfLabelMappings(gmfmapmodelFileName);
        URI newMapUri = this.temporarySaveMigratedModel(gmfmapmodelFileName, "testNotChangingOrderOfLabelMappings", "gmfmap");
        this.changeNsUriToOldOne(newMapUri, "gmfmap", "http://www.eclipse.org/gmf/2005/mappings/2.0");
        this.assertOnLoadModelMigrationDidNothing(newMapUri);
        this.checkOrderOfLabelMappings(newMapUri);
    }

    public void testRequiredPluginsMoved() throws Exception {
        URI gmfmapmodelFileName = MigrationPatchesTest.createURI("testRequiredPluginsMoved.gmfgen");
        Exception caughtMapException = this.assertOrdinaryLoadModelProblems(gmfmapmodelFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtMapException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(gmfmapmodelFileName);
        this.checkAllRequiredPluginsAreNotLost(gmfmapmodelFileName);
        URI newMapUri = this.temporarySaveMigratedModel(gmfmapmodelFileName, "testRequiredPluginsMoved", "gmfgen");
        this.changeNsUriToOldOne(newMapUri, "gmfgen", "http://www.eclipse.org/gmf/2005/GenModel/2.0");
        this.assertOnLoadModelMigrationDidNothing(newMapUri);
        this.checkAllRequiredPluginsAreNotLost(newMapUri);
    }

    private void checkAllRequiredPluginsAreNotLost(URI modelUri) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), modelUri);
        Resource resource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        Object first = resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof GenEditorGenerator));
        GenEditorGenerator genEditor = (GenEditorGenerator)first;
        MigrationPatchesTest.assertNotNull((Object)genEditor.getExpressionProviders());
        MigrationPatchesTest.assertFalse((boolean)genEditor.getExpressionProviders().getProviders().isEmpty());
        GenPlugin plugin = genEditor.getPlugin();
        MigrationPatchesTest.assertNotNull((Object)plugin);
        EList requiredPlugins = plugin.getRequiredPlugins();
        MigrationPatchesTest.assertEquals((int)3, (int)requiredPlugins.size());
        MigrationPatchesTest.assertEquals((String)"org.eclipse.fake.x1", (String)((String)requiredPlugins.get(0)));
        MigrationPatchesTest.assertEquals((String)"org.eclipse.fake.x2", (String)((String)requiredPlugins.get(1)));
        MigrationPatchesTest.assertEquals((String)"org.eclipse.x3", (String)((String)requiredPlugins.get(2)));
    }

    private void checkOrderOfLabelMappings(URI modelURI) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), modelURI);
        Resource res = loadHelper.getLoadedResource();
        TreeIterator it = res.getAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof MappingEntry)) continue;
            MappingEntry nextEntry = (MappingEntry)next;
            EList labelMappings = nextEntry.getLabelMappings();
            MigrationPatchesTest.assertFalse((boolean)labelMappings.isEmpty());
            MigrationPatchesTest.assertEquals((int)5, (int)labelMappings.size());
            this.checkMapping((LabelMapping)labelMappings.get(0), false);
            this.checkMapping((LabelMapping)labelMappings.get(1), true);
            this.checkMapping((LabelMapping)labelMappings.get(2), false);
            this.checkMapping((LabelMapping)labelMappings.get(3), true);
            this.checkMapping((LabelMapping)labelMappings.get(4), false);
        }
    }

    private void checkMapping(LabelMapping mapping, boolean shouldBeNarrowed) {
        MigrationPatchesTest.assertEquals((boolean)shouldBeNarrowed, (boolean)(mapping instanceof FeatureLabelMapping));
        MigrationPatchesTest.assertNotNull((Object)mapping.getDiagramLabel());
        if (shouldBeNarrowed) {
            MigrationPatchesTest.assertFalse((boolean)((FeatureLabelMapping)mapping).getFeatures().isEmpty());
        }
    }

    private void checkFeatureLabelModelFacetsMigrated(URI uri) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), uri);
        Resource resource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        EObject editorGen = (EObject)resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(editorGen instanceof GenEditorGenerator));
        MigrationPatchesTest.assertEquals((int)1, (int)editorGen.eContents().size());
        EObject diagram = (EObject)editorGen.eContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(diagram instanceof GenDiagram));
        MigrationPatchesTest.assertEquals((int)1, (int)diagram.eContents().size());
        GenTopLevelNode root = (GenTopLevelNode)diagram.eContents().get(0);
        MigrationPatchesTest.assertEquals((int)2, (int)root.eContents().size());
        MigrationPatchesTest.assertEquals((int)2, (int)root.getLabels().size());
        LabelModelFacet first = ((GenNodeLabel)root.getLabels().get(0)).getModelFacet();
        MigrationPatchesTest.assertTrue((boolean)(first instanceof FeatureLabelModelFacet));
        FeatureLabelModelFacet firstFeatureLabelModelFacet = (FeatureLabelModelFacet)first;
        MigrationPatchesTest.assertEquals((int)1, (int)firstFeatureLabelModelFacet.getMetaFeatures().size());
        LabelModelFacet second = ((GenNodeLabel)root.getLabels().get(1)).getModelFacet();
        MigrationPatchesTest.assertTrue((boolean)(second instanceof FeatureLabelModelFacet));
        FeatureLabelModelFacet secondFeatureLabelModelFacet = (FeatureLabelModelFacet)second;
        MigrationPatchesTest.assertEquals((int)2, (int)secondFeatureLabelModelFacet.getMetaFeatures().size());
    }

    public void testGraphReferencingElements() throws Exception {
        URI gmfgraphFileName = MigrationPatchesTest.createURI("basic.gmfgraph");
        this.assertOnLoadModelMigrationSuccess(gmfgraphFileName);
        this.checkAllFigureReferences(gmfgraphFileName);
        URI newUri = this.temporarySaveMigratedModel(gmfgraphFileName, "basic", "gmfgraph");
        this.assertOnLoadModelMigrationDidNothing(newUri);
        this.checkAllFigureReferences(newUri);
    }

    private void checkAllFigureReferences(URI modelUri) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), modelUri);
        Resource resource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        Object first = resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof Canvas));
        Canvas canvas = (Canvas)first;
        MigrationPatchesTest.assertEquals((int)9, (int)canvas.eContents().size());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getFigures().size());
        FigureGallery fg = (FigureGallery)canvas.getFigures().get(0);
        MigrationPatchesTest.assertEquals((String)"GenericDiagramFigures", (String)fg.getName());
        MigrationPatchesTest.assertEquals((int)1, (int)fg.getFigures().size());
        Figure figure0 = (Figure)fg.getFigures().get(0);
        MigrationPatchesTest.assertTrue((boolean)(figure0 instanceof PolylineDecoration));
        PolylineDecoration linked = (PolylineDecoration)figure0;
        MigrationPatchesTest.assertEquals((String)"ArrowDecoration", (String)linked.getName());
        MigrationPatchesTest.assertEquals((int)6, (int)fg.getDescriptors().size());
        FigureDescriptor fg1 = (FigureDescriptor)fg.getDescriptors().get(0);
        MigrationPatchesTest.assertTrue((boolean)fg1.getAccessors().isEmpty());
        FigureDescriptor fg5 = (FigureDescriptor)fg.getDescriptors().get(4);
        MigrationPatchesTest.assertEquals((int)1, (int)fg5.getAccessors().size());
        Figure figure1 = ((FigureDescriptor)fg.getDescriptors().get(0)).getActualFigure();
        MigrationPatchesTest.assertTrue((boolean)(figure1 instanceof Rectangle));
        Rectangle nr = (Rectangle)figure1;
        MigrationPatchesTest.assertEquals((String)"NodeRectangle", (String)nr.getName());
        MigrationPatchesTest.assertNotNull((Object)nr.getLayout());
        MigrationPatchesTest.assertTrue((boolean)(nr.getLayout() instanceof FlowLayout));
        MigrationPatchesTest.assertNotNull((Object)nr.getDescriptor());
        MigrationPatchesTest.assertEquals((Object)nr, (Object)nr.getDescriptor().getActualFigure());
        MigrationPatchesTest.assertEquals((int)0, (int)nr.getDescriptor().getAccessors().size());
        Figure figure2 = ((FigureDescriptor)fg.getDescriptors().get(1)).getActualFigure();
        MigrationPatchesTest.assertTrue((boolean)(figure2 instanceof PolylineConnection));
        PolylineConnection pc = (PolylineConnection)figure2;
        MigrationPatchesTest.assertEquals((String)"ConnectionLine", (String)pc.getName());
        MigrationPatchesTest.assertNotNull((Object)pc.getDescriptor());
        MigrationPatchesTest.assertEquals((Object)pc, (Object)pc.getDescriptor().getActualFigure());
        MigrationPatchesTest.assertEquals((int)0, (int)pc.getDescriptor().getAccessors().size());
        Figure figure3 = ((FigureDescriptor)fg.getDescriptors().get(2)).getActualFigure();
        MigrationPatchesTest.assertTrue((boolean)(figure3 instanceof LabeledContainer));
        LabeledContainer lc = (LabeledContainer)figure3;
        MigrationPatchesTest.assertEquals((String)"ContainerFigure", (String)lc.getName());
        MigrationPatchesTest.assertNotNull((Object)lc.getDescriptor());
        MigrationPatchesTest.assertEquals((Object)lc, (Object)lc.getDescriptor().getActualFigure());
        MigrationPatchesTest.assertEquals((int)0, (int)lc.getDescriptor().getAccessors().size());
        Figure figure4 = ((FigureDescriptor)fg.getDescriptors().get(3)).getActualFigure();
        MigrationPatchesTest.assertTrue((boolean)(figure4 instanceof Label));
        Label lab = (Label)figure4;
        MigrationPatchesTest.assertEquals((String)"LabelFigure", (String)lab.getName());
        MigrationPatchesTest.assertNotNull((Object)lab.getDescriptor());
        MigrationPatchesTest.assertEquals((Object)lab, (Object)lab.getDescriptor().getActualFigure());
        MigrationPatchesTest.assertEquals((int)0, (int)lab.getDescriptor().getAccessors().size());
        Figure figure5 = ((FigureDescriptor)fg.getDescriptors().get(4)).getActualFigure();
        MigrationPatchesTest.assertTrue((boolean)(figure5 instanceof Rectangle));
        Rectangle nnr = (Rectangle)figure5;
        MigrationPatchesTest.assertEquals((String)"NamedNodeRectangle", (String)nnr.getName());
        MigrationPatchesTest.assertNotNull((Object)nnr.getLayout());
        MigrationPatchesTest.assertTrue((boolean)(nnr.getLayout() instanceof FlowLayout));
        MigrationPatchesTest.assertNotNull((Object)nnr.getChildren());
        MigrationPatchesTest.assertFalse((boolean)nnr.getChildren().isEmpty());
        MigrationPatchesTest.assertEquals((int)1, (int)nnr.getChildren().size());
        MigrationPatchesTest.assertNotNull((Object)nnr.getDescriptor());
        MigrationPatchesTest.assertEquals((Object)nnr, (Object)nnr.getDescriptor().getActualFigure());
        Figure figure1in5 = (Figure)nnr.getChildren().get(0);
        MigrationPatchesTest.assertTrue((boolean)(figure1in5 instanceof Label));
        Label nnrLabel = (Label)figure1in5;
        MigrationPatchesTest.assertEquals((String)"NamedNode_NameLabelFigure", (String)nnrLabel.getName());
        MigrationPatchesTest.assertNotNull((Object)nnrLabel.getDescriptor());
        MigrationPatchesTest.assertEquals((Object)nnrLabel.getDescriptor(), (Object)nnr.getDescriptor());
        MigrationPatchesTest.assertEquals((int)1, (int)nnr.getDescriptor().getAccessors().size());
        MigrationPatchesTest.assertEquals((Object)nnrLabel, (Object)((ChildAccess)nnr.getDescriptor().getAccessors().get(0)).getFigure());
        Figure figure6 = ((FigureDescriptor)fg.getDescriptors().get(5)).getActualFigure();
        MigrationPatchesTest.assertTrue((boolean)(figure6 instanceof PolylineConnection));
        PolylineConnection fcf = (PolylineConnection)figure6;
        MigrationPatchesTest.assertEquals((String)"FigureConnectionFigure", (String)fcf.getName());
        MigrationPatchesTest.assertEquals((Object)LineKind.LINE_DASHDOT_LITERAL, (Object)fcf.getLineKind());
        MigrationPatchesTest.assertNotNull((Object)fcf.getTargetDecoration());
        MigrationPatchesTest.assertEquals((Object)linked, (Object)fcf.getTargetDecoration());
        MigrationPatchesTest.assertNotNull((Object)fcf.getDescriptor());
        MigrationPatchesTest.assertEquals((Object)fcf, (Object)fcf.getDescriptor().getActualFigure());
        MigrationPatchesTest.assertNotNull((Object)canvas.getNodes());
        MigrationPatchesTest.assertFalse((boolean)canvas.getNodes().isEmpty());
        MigrationPatchesTest.assertEquals((int)2, (int)canvas.getNodes().size());
        Node node1 = (Node)canvas.getNodes().get(0);
        MigrationPatchesTest.assertEquals((String)"Node", (String)node1.getName());
        Node node2 = (Node)canvas.getNodes().get(1);
        MigrationPatchesTest.assertEquals((String)"NamedNode", (String)node2.getName());
        MigrationPatchesTest.assertEquals((int)2, (int)canvas.getConnections().size());
        Connection connection1 = (Connection)canvas.getConnections().get(0);
        MigrationPatchesTest.assertEquals((String)"Link", (String)connection1.getName());
        Connection connection2 = (Connection)canvas.getConnections().get(1);
        MigrationPatchesTest.assertEquals((String)"LinkWithDec", (String)connection2.getName());
        MigrationPatchesTest.assertNotNull((Object)canvas.getCompartments());
        MigrationPatchesTest.assertFalse((boolean)canvas.getCompartments().isEmpty());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getCompartments().size());
        Compartment compartment = (Compartment)canvas.getCompartments().get(0);
        MigrationPatchesTest.assertEquals((String)"Compartment", (String)compartment.getName());
        MigrationPatchesTest.assertNotNull((Object)canvas.getLabels());
        MigrationPatchesTest.assertFalse((boolean)canvas.getLabels().isEmpty());
        MigrationPatchesTest.assertEquals((int)3, (int)canvas.getLabels().size());
        DiagramLabel l1 = (DiagramLabel)canvas.getLabels().get(0);
        MigrationPatchesTest.assertEquals((String)"NamedNode_Name", (String)l1.getName());
        DiagramLabel l2 = (DiagramLabel)canvas.getLabels().get(1);
        MigrationPatchesTest.assertEquals((String)"Label", (String)l2.getName());
        DiagramLabel l3 = (DiagramLabel)canvas.getLabels().get(2);
        MigrationPatchesTest.assertEquals((String)"LabelWOIcon", (String)l3.getName());
    }

    public void testCustomFigures() throws Exception {
        MigrationPatchesTest.assertTrue((boolean)((EClass)GMFGraphPackage.eINSTANCE.getFigureAccessor_TypedFigure().getEType()).isAbstract());
        URI gmfgraphFileName = MigrationPatchesTest.createURI("customFigures.gmfgraph");
        this.assertOnLoadModelMigrationSuccess(gmfgraphFileName);
        this.checkCustomFiguresContent(gmfgraphFileName);
        URI newUri = this.temporarySaveMigratedModel(gmfgraphFileName, "customFigures", "gmfgraph");
        this.assertOnLoadModelMigrationDidNothing(newUri);
        this.checkCustomFiguresContent(newUri);
    }

    private void checkCustomFiguresContent(URI modelUri) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), modelUri);
        Resource resource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        Object first = resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof Canvas));
        Canvas canvas = (Canvas)first;
        MigrationPatchesTest.assertEquals((int)7, (int)canvas.eContents().size());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getFigures().size());
        FigureGallery fg = (FigureGallery)canvas.getFigures().get(0);
        MigrationPatchesTest.assertEquals((int)3, (int)fg.getFigures().size());
        Figure figure1 = (Figure)fg.getFigures().get(0);
        MigrationPatchesTest.assertTrue((boolean)(figure1 instanceof CustomFigure));
        MigrationPatchesTest.assertEquals((String)"org.eclipse.draw2d.ScalableFigure", (String)((CustomFigure)figure1).getQualifiedClassName());
        MigrationPatchesTest.assertEquals((int)4, (int)fg.getDescriptors().size());
        Figure node1figure = ((FigureDescriptor)fg.getDescriptors().get(0)).getActualFigure();
        MigrationPatchesTest.assertNotNull((Object)node1figure);
        MigrationPatchesTest.assertTrue((boolean)(node1figure instanceof CustomFigure));
        MigrationPatchesTest.assertEquals((int)1, (int)((CustomFigure)node1figure).getCustomChildren().size());
        RealFigure compartment2figure = ((FigureAccessor)((CustomFigure)node1figure).getCustomChildren().get(0)).getTypedFigure();
        MigrationPatchesTest.assertNotNull((Object)compartment2figure);
        MigrationPatchesTest.assertTrue((boolean)(compartment2figure instanceof CustomFigure));
        MigrationPatchesTest.assertEquals((String)"org.eclipse.draw2d.IFigure", (String)((CustomFigure)compartment2figure).getQualifiedClassName());
        Figure node2figure = ((FigureDescriptor)fg.getDescriptors().get(1)).getActualFigure();
        MigrationPatchesTest.assertNotNull((Object)node2figure);
        MigrationPatchesTest.assertTrue((boolean)(node2figure instanceof CustomFigure));
        MigrationPatchesTest.assertEquals((int)1, (int)((CustomFigure)node2figure).getCustomChildren().size());
        RealFigure compartment1figure = ((FigureAccessor)((CustomFigure)node2figure).getCustomChildren().get(0)).getTypedFigure();
        MigrationPatchesTest.assertNotNull((Object)compartment1figure);
        Figure node3figure = ((FigureDescriptor)fg.getDescriptors().get(2)).getActualFigure();
        MigrationPatchesTest.assertNotNull((Object)node3figure);
        MigrationPatchesTest.assertTrue((boolean)(node3figure instanceof CustomFigure));
        MigrationPatchesTest.assertEquals((int)1, (int)((CustomFigure)node3figure).getCustomChildren().size());
        RealFigure compartment4figure = ((FigureAccessor)((CustomFigure)node3figure).getCustomChildren().get(0)).getTypedFigure();
        MigrationPatchesTest.assertNotNull((Object)compartment4figure);
        MigrationPatchesTest.assertTrue((boolean)(compartment4figure instanceof CustomFigure));
        MigrationPatchesTest.assertEquals((String)"org.eclipse.draw2d.ScalableFigure", (String)((CustomFigure)compartment4figure).getQualifiedClassName());
        MigrationPatchesTest.assertNotNull((Object)node3figure);
        Figure compartment3figure = ((FigureDescriptor)fg.getDescriptors().get(3)).getActualFigure();
        MigrationPatchesTest.assertNotNull((Object)compartment3figure);
        MigrationPatchesTest.assertNotNull((Object)canvas.getNodes());
        MigrationPatchesTest.assertEquals((int)2, (int)canvas.getNodes().size());
        Node node1 = (Node)canvas.getNodes().get(0);
        MigrationPatchesTest.assertEquals((String)"LocalPreconditionNode", (String)node1.getName());
        MigrationPatchesTest.assertNotNull((Object)node1.getFigure());
        MigrationPatchesTest.assertEquals((Object)node1figure, (Object)node1.getFigure().getActualFigure());
        Node node2 = (Node)canvas.getNodes().get(1);
        MigrationPatchesTest.assertEquals((String)"LocalPostconditionNode", (String)node2.getName());
        MigrationPatchesTest.assertNotNull((Object)node2.getFigure());
        MigrationPatchesTest.assertEquals((Object)node2figure, (Object)node2.getFigure().getActualFigure());
        MigrationPatchesTest.assertNotNull((Object)canvas.getCompartments());
        MigrationPatchesTest.assertEquals((int)4, (int)canvas.getCompartments().size());
        Compartment compartment1 = (Compartment)canvas.getCompartments().get(0);
        MigrationPatchesTest.assertEquals((String)"postcondition", (String)compartment1.getName());
        MigrationPatchesTest.assertNotNull((Object)compartment1.getFigure());
        MigrationPatchesTest.assertNotNull((Object)compartment1.getAccessor());
        MigrationPatchesTest.assertEquals((Object)compartment1figure, (Object)compartment1.getAccessor().getFigure());
        Compartment compartment2 = (Compartment)canvas.getCompartments().get(1);
        MigrationPatchesTest.assertEquals((String)"precondition", (String)compartment2.getName());
        MigrationPatchesTest.assertNotNull((Object)compartment2.getFigure());
        MigrationPatchesTest.assertNotNull((Object)compartment2.getAccessor());
        MigrationPatchesTest.assertEquals((Object)compartment2figure, (Object)compartment2.getAccessor().getFigure());
        Compartment compartment3 = (Compartment)canvas.getCompartments().get(2);
        MigrationPatchesTest.assertEquals((String)"anotherPostcondition", (String)compartment3.getName());
        MigrationPatchesTest.assertNotNull((Object)compartment3.getFigure());
        MigrationPatchesTest.assertNull((Object)compartment3.getAccessor());
        Compartment compartment4 = (Compartment)canvas.getCompartments().get(3);
        MigrationPatchesTest.assertEquals((String)"TargetCustomDecorCompartment", (String)compartment4.getName());
        MigrationPatchesTest.assertNotNull((Object)compartment4.getFigure());
        MigrationPatchesTest.assertNotNull((Object)compartment4.getAccessor());
        MigrationPatchesTest.assertEquals((Object)compartment4figure, (Object)compartment4.getAccessor().getFigure());
    }

    public void testMultifiles() throws Exception {
        URI gmfgraphFileName = MigrationPatchesTest.createURI("multifile_main.gmfgraph");
        this.assertOnLoadModelMigrationSuccess(gmfgraphFileName);
        URI newUri = this.temporarySaveMigratedModel(gmfgraphFileName, "multifile_main", "gmfgraph");
        this.assertOnLoadModelMigrationDidNothing(newUri);
    }

    public void testMultifilesLoadOrder_FiguresFirst() throws Exception {
        URI figureGalleryFileName = MigrationPatchesTest.createURI("test_main.gmfgraph");
        this.assertOnLoadModelMigrationSuccess(figureGalleryFileName);
        this.checkMultifilesStructure(figureGalleryFileName, false);
        URI newFigureGalleryUri = this.temporarySaveMigratedModel(figureGalleryFileName, "test_main", "gmfgraph");
        this.assertOnLoadModelMigrationDidNothing(newFigureGalleryUri);
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), newFigureGalleryUri);
        Resource mainResource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)1, (int)mainResource.getResourceSet().getResources().size());
        this.checkMultifilesGalleryStructure(mainResource);
    }

    public void testMultifilesLoadOrder_NodesFirst() throws Exception {
        URI diagramElementsFileName = MigrationPatchesTest.createURI("test_linked.gmfgraph");
        this.assertOnLoadModelMigrationSuccess(diagramElementsFileName);
        this.checkMultifilesStructure(diagramElementsFileName, true);
        URI newDiagramElementsUri = this.temporarySaveMigratedModel(diagramElementsFileName, "test_linked", "gmfgraph");
        this.assertOnLoadModelMigrationDidNothing(newDiagramElementsUri);
    }

    private void checkMultifilesStructure(URI modelUri, boolean revertOrder) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), modelUri);
        Resource mainResource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)2, (int)mainResource.getResourceSet().getResources().size());
        Resource linkedResource = (Resource)mainResource.getResourceSet().getResources().get(1);
        if (revertOrder) {
            this.checkMultifilesNodesStructure(mainResource);
            this.checkMultifilesGalleryStructure(linkedResource);
        } else {
            this.checkMultifilesNodesStructure(linkedResource);
            this.checkMultifilesGalleryStructure(mainResource);
        }
    }

    private void checkMultifilesGalleryStructure(Resource resource) {
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        Object first = resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof Canvas));
        Canvas canvas = (Canvas)first;
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.eContents().size());
        MigrationPatchesTest.assertNotNull((Object)canvas.getFigures());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getFigures().size());
        FigureGallery fg = (FigureGallery)canvas.getFigures().get(0);
        MigrationPatchesTest.assertNotNull((Object)fg.getFigures());
        MigrationPatchesTest.assertEquals((int)1, (int)fg.getFigures().size());
        MigrationPatchesTest.assertNotNull((Object)fg.getDescriptors());
        MigrationPatchesTest.assertEquals((int)3, (int)fg.getDescriptors().size());
        FigureDescriptor descriptor1 = (FigureDescriptor)fg.getDescriptors().get(0);
        MigrationPatchesTest.assertEquals((int)0, (int)descriptor1.getAccessors().size());
        FigureDescriptor descriptor2 = (FigureDescriptor)fg.getDescriptors().get(1);
        MigrationPatchesTest.assertEquals((int)1, (int)descriptor2.getAccessors().size());
        FigureDescriptor descriptor3 = (FigureDescriptor)fg.getDescriptors().get(2);
        MigrationPatchesTest.assertEquals((int)2, (int)descriptor3.getAccessors().size());
    }

    private void checkMultifilesNodesStructure(Resource resource) {
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        Object first = resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof Canvas));
        Canvas canvas = (Canvas)first;
        MigrationPatchesTest.assertEquals((int)6, (int)canvas.eContents().size());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getFigures().size());
        FigureGallery fg = (FigureGallery)canvas.getFigures().get(0);
        MigrationPatchesTest.assertEquals((int)1, (int)fg.getFigures().size());
        MigrationPatchesTest.assertEquals((int)1, (int)fg.getDescriptors().size());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getNodes().size());
        MigrationPatchesTest.assertNotNull((Object)((Node)canvas.getNodes().get(0)).getFigure());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getConnections().size());
        MigrationPatchesTest.assertNotNull((Object)((Connection)canvas.getConnections().get(0)).getFigure());
        MigrationPatchesTest.assertEquals((int)2, (int)canvas.getCompartments().size());
        MigrationPatchesTest.assertNotNull((Object)((Compartment)canvas.getCompartments().get(0)).getFigure());
        MigrationPatchesTest.assertNotNull((Object)((Compartment)canvas.getCompartments().get(1)).getFigure());
        MigrationPatchesTest.assertEquals((int)1, (int)canvas.getLabels().size());
        MigrationPatchesTest.assertNotNull((Object)((DiagramLabel)canvas.getLabels().get(0)).getFigure());
    }

    public void testAuditContexts() throws Exception {
        URI gmfgenFileName = MigrationPatchesTest.createURI("test226149.gmfgen");
        Resource resource = this.assertNoOrdinaryLoadModelProblems(gmfgenFileName);
        MigrationPatchesTest.assertEquals((String)"http://www.eclipse.org/gmf/2006/GenModel", (String)((EObject)resource.getContents().get(0)).eClass().getEPackage().getNsURI());
        this.assertOnLoadModelMigrationSuccess(gmfgenFileName);
        this.checkAuditContexts(gmfgenFileName);
        URI newUri = this.temporarySaveMigratedModel(gmfgenFileName, "test226149", "gmfgen");
        this.assertOnLoadModelMigrationDidNothing(newUri);
        this.checkAuditContexts(newUri);
    }

    private void checkAuditContexts(URI modelUri) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), modelUri);
        Resource resource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        Object first = resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof GenEditorGenerator));
        GenEditorGenerator editor = (GenEditorGenerator)first;
        MigrationPatchesTest.assertEquals((int)1, (int)editor.eContents().size());
        first = editor.eContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof GenAuditRoot));
        GenAuditRoot root = (GenAuditRoot)first;
        MigrationPatchesTest.assertEquals((int)6, (int)root.eContents().size());
        MigrationPatchesTest.assertNotNull((Object)root.getClientContexts());
        MigrationPatchesTest.assertFalse((boolean)root.getClientContexts().isEmpty());
        MigrationPatchesTest.assertEquals((int)2, (int)root.getClientContexts().size());
        GenAuditContext saveMe1 = (GenAuditContext)root.getClientContexts().get(0);
        MigrationPatchesTest.assertEquals((String)"SaveMe1", (String)saveMe1.getId());
        MigrationPatchesTest.assertFalse((boolean)saveMe1.getRuleTargets().isEmpty());
        MigrationPatchesTest.assertEquals((int)2, (int)saveMe1.getRuleTargets().size());
        GenAuditContext saveMe2 = (GenAuditContext)root.getClientContexts().get(1);
        MigrationPatchesTest.assertEquals((String)"SaveMe2", (String)saveMe2.getId());
        MigrationPatchesTest.assertFalse((boolean)saveMe2.getRuleTargets().isEmpty());
        MigrationPatchesTest.assertEquals((int)1, (int)saveMe2.getRuleTargets().size());
    }

    public void testFeatureValueSpecRefactor227505() throws Exception {
        URI gmfmapFileName = MigrationPatchesTest.createURI("test227505.gmfmap");
        Exception caughtGenException = this.assertOrdinaryLoadModelProblems(gmfmapFileName);
        MigrationPatchesTest.assertTrue((String)"expected diagnostic exception", (caughtGenException != null ? 1 : 0) != 0);
        this.assertOnLoadModelMigrationSuccess(gmfmapFileName);
        this.checkValueExpressions(gmfmapFileName);
        URI newUri = this.temporarySaveMigratedModel(gmfmapFileName, "test227505", "gmfmap");
        this.assertOnLoadModelMigrationDidNothing(newUri);
        this.checkValueExpressions(newUri);
    }

    private void checkValueExpressions(URI modelUri) {
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)new ResourceSetImpl(), modelUri);
        Resource resource = loadHelper.getLoadedResource();
        MigrationPatchesTest.assertEquals((int)1, (int)resource.getContents().size());
        Object first = resource.getContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof Mapping));
        Mapping mapping = (Mapping)first;
        MigrationPatchesTest.assertEquals((int)2, (int)mapping.eContents().size());
        first = mapping.eContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof TopNodeReference));
        Object second = mapping.eContents().get(1);
        MigrationPatchesTest.assertTrue((boolean)(second instanceof CanvasMapping));
        TopNodeReference topNode = (TopNodeReference)first;
        MigrationPatchesTest.assertEquals((int)1, (int)topNode.eContents().size());
        first = topNode.eContents().get(0);
        MigrationPatchesTest.assertTrue((boolean)(first instanceof NodeMapping));
        NodeMapping node = (NodeMapping)first;
        ElementInitializer initer = node.getDomainInitializer();
        MigrationPatchesTest.assertNotNull((Object)initer);
        MigrationPatchesTest.assertTrue((boolean)(initer instanceof FeatureSeqInitializer));
        FeatureSeqInitializer featureRef = (FeatureSeqInitializer)initer;
        MigrationPatchesTest.assertNotNull((Object)featureRef.getInitializers());
        MigrationPatchesTest.assertFalse((boolean)featureRef.getInitializers().isEmpty());
        MigrationPatchesTest.assertEquals((int)3, (int)featureRef.getInitializers().size());
        FeatureInitializer init1 = (FeatureInitializer)featureRef.getInitializers().get(0);
        MigrationPatchesTest.assertTrue((boolean)(init1 instanceof FeatureValueSpec));
        FeatureValueSpec feature1 = (FeatureValueSpec)init1;
        MigrationPatchesTest.assertEquals((String)EcoreUtil.getURI((EObject)EcorePackage.eINSTANCE.getEModelElement_EAnnotations()).fragment(), (String)EcoreUtil.getURI((EObject)feature1.getFeature()).fragment());
        ValueExpression value1 = feature1.getValue();
        MigrationPatchesTest.assertNotNull((Object)value1);
        MigrationPatchesTest.assertEquals((Object)Language.JAVA_LITERAL, (Object)value1.getLanguage());
        MigrationPatchesTest.assertEquals((String)"some.Checker", (String)value1.getBody());
        FeatureInitializer init2 = (FeatureInitializer)featureRef.getInitializers().get(1);
        MigrationPatchesTest.assertTrue((boolean)(init2 instanceof FeatureValueSpec));
        FeatureValueSpec feature2 = (FeatureValueSpec)init2;
        MigrationPatchesTest.assertEquals((String)EcoreUtil.getURI((EObject)EcorePackage.eINSTANCE.getENamedElement_Name()).fragment(), (String)EcoreUtil.getURI((EObject)feature2.getFeature()).fragment());
        ValueExpression value2 = feature2.getValue();
        MigrationPatchesTest.assertNotNull((Object)value2);
        MigrationPatchesTest.assertEquals((Object)Language.OCL_LITERAL, (Object)value2.getLanguage());
        MigrationPatchesTest.assertEquals((String)"self.name", (String)value2.getBody());
        FeatureInitializer init3 = (FeatureInitializer)featureRef.getInitializers().get(2);
        MigrationPatchesTest.assertTrue((boolean)(init3 instanceof ReferenceNewElementSpec));
        ReferenceNewElementSpec ref3 = (ReferenceNewElementSpec)init3;
        MigrationPatchesTest.assertEquals((String)EcoreUtil.getURI((EObject)EcorePackage.eINSTANCE.getETypeParameter_EBounds()).fragment(), (String)EcoreUtil.getURI((EObject)ref3.getFeature()).fragment());
        MigrationPatchesTest.assertNotNull((Object)ref3.getNewElementInitializers());
        MigrationPatchesTest.assertFalse((boolean)ref3.getNewElementInitializers().isEmpty());
        MigrationPatchesTest.assertEquals((int)1, (int)ref3.getNewElementInitializers().size());
        FeatureSeqInitializer featureRef3 = (FeatureSeqInitializer)ref3.getNewElementInitializers().get(0);
        MigrationPatchesTest.assertNotNull((Object)featureRef3);
        MigrationPatchesTest.assertNotNull((Object)featureRef3.getInitializers());
        MigrationPatchesTest.assertFalse((boolean)featureRef3.getInitializers().isEmpty());
        MigrationPatchesTest.assertEquals((int)1, (int)featureRef3.getInitializers().size());
        FeatureInitializer init31 = (FeatureInitializer)featureRef3.getInitializers().get(0);
        MigrationPatchesTest.assertTrue((boolean)(init31 instanceof FeatureValueSpec));
        FeatureValueSpec feature31 = (FeatureValueSpec)init31;
        MigrationPatchesTest.assertEquals((String)EcoreUtil.getURI((EObject)EcorePackage.eINSTANCE.getEGenericType_ELowerBound()).fragment(), (String)EcoreUtil.getURI((EObject)feature31.getFeature()).fragment());
        ValueExpression value31 = feature31.getValue();
        MigrationPatchesTest.assertNotNull((Object)value31);
        MigrationPatchesTest.assertEquals((Object)Language.JAVA_LITERAL, (Object)value31.getLanguage());
        MigrationPatchesTest.assertEquals((String)"some.Checker2", (String)value31.getBody());
    }
}

