/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.RootTreeEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gmf.internal.runtime.lite.Activator;
import org.eclipse.gmf.runtime.lite.edit.parts.tree.DiagramTreeEditPartFactory;
import org.eclipse.gmf.runtime.lite.parts.IDiagramOutlineHost;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DiagramContentOutlinePage
extends Page
implements IContentOutlinePage {
    public static final int ID_OVERVIEW = 0;
    public static final int ID_OUTLINE = 1;
    private final int myDefaultMode;
    private ContentOutlinePage myOutlinePage;
    private Canvas myOverview;
    private PageBook myPageBook;
    private IAction myShowOutlineAction;
    private IAction myShowOverviewAction;
    private Thumbnail myThumbnail;
    private TreeViewer myTreeViewer;
    private DisposeListener myDisposeListener;
    private final IDiagramOutlineHost myHost;

    public DiagramContentOutlinePage(IDiagramOutlineHost host, int defaultMode) {
        this.myHost = host;
        this.myDefaultMode = defaultMode;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        ActionRegistry registry = this.myHost.getActionRegistry();
        IActionBars bars = pageSite.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
        bars.getToolBarManager().markDirty();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.myOutlinePage != null) {
            this.myOutlinePage.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.myOutlinePage != null) {
            this.myOutlinePage.removeSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.myOutlinePage != null) {
            return this.myOutlinePage.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.myOutlinePage != null) {
            this.myOutlinePage.setSelection(selection);
        }
    }

    public void createControl(Composite parent) {
        this.myPageBook = new PageBook(parent, 0);
        this.myTreeViewer = new TreeViewer();
        this.myTreeViewer.setRootEditPart((RootEditPart)new RootTreeEditPart());
        this.myTreeViewer.setEditDomain(this.myHost.getEditDomain());
        this.myTreeViewer.setEditPartFactory((EditPartFactory)new DiagramTreeEditPartFactory(this.myHost.getGraphicalViewer()));
        this.configureTreeViewer(this.myTreeViewer);
        this.myOutlinePage = new ContentOutlinePage((EditPartViewer)this.myTreeViewer);
        this.myOutlinePage.createControl((Composite)this.myPageBook);
        this.myTreeViewer.setContents(this.myHost.getGraphicalViewer().getContents().getModel());
        this.hookOutlineViewer(this.myTreeViewer);
        this.configureOutlinePage();
        this.showPage(this.myDefaultMode);
    }

    protected void hookOutlineViewer(TreeViewer viewer) {
        this.myHost.getSelectionSynchronizer().addViewer((EditPartViewer)viewer);
    }

    protected void unhookOutlineViewer(TreeViewer viewer) {
        this.myHost.getSelectionSynchronizer().removeViewer((EditPartViewer)viewer);
    }

    protected void configureOutlinePage() {
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.myShowOutlineAction = new Action(){

            public void run() {
                DiagramContentOutlinePage.this.showPage(1);
            }
        };
        this.myShowOutlineAction.setImageDescriptor(Activator.getImageDescriptor("icons/outline.gif"));
        this.myShowOutlineAction.setToolTipText("Show Outline");
        tbm.add(this.myShowOutlineAction);
        this.myShowOverviewAction = new Action(){

            public void run() {
                DiagramContentOutlinePage.this.showPage(0);
            }
        };
        this.myShowOverviewAction.setImageDescriptor(Activator.getImageDescriptor("icons/overview.gif"));
        this.myShowOverviewAction.setToolTipText("Show Overview");
        tbm.add(this.myShowOverviewAction);
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        KeyHandler keyHandler = new KeyHandler();
        keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.myHost.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.myHost.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        treeViewer.setKeyHandler(keyHandler);
    }

    protected void showPage(int pageId) {
        switch (pageId) {
            case 1: {
                this.myShowOutlineAction.setChecked(true);
                this.myShowOverviewAction.setChecked(false);
                this.myPageBook.showPage(this.myOutlinePage.getControl());
                if (this.myThumbnail == null) break;
                this.myThumbnail.setVisible(false);
                break;
            }
            case 0: {
                this.myShowOutlineAction.setChecked(false);
                this.myShowOverviewAction.setChecked(true);
                if (this.myOverview == null || this.myOverview.isDisposed()) {
                    this.initializeOverview();
                }
                this.myPageBook.showPage((Control)this.myOverview);
                if (this.myThumbnail == null) break;
                this.myThumbnail.setVisible(true);
            }
        }
    }

    protected void initializeOverview() {
        this.myOverview = new Canvas((Composite)this.myPageBook, 0);
        LightweightSystem lws = new LightweightSystem(this.myOverview);
        FreeformGraphicalRootEditPart root = (FreeformGraphicalRootEditPart)this.myHost.getGraphicalViewer().getRootEditPart();
        this.myThumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
        this.myThumbnail.setSource(root.getLayer((Object)"Scalable Layers"));
        lws.setContents((IFigure)this.myThumbnail);
        this.myDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DiagramContentOutlinePage.this.myThumbnail != null) {
                    DiagramContentOutlinePage.this.myThumbnail.deactivate();
                    DiagramContentOutlinePage.this.myThumbnail = null;
                }
            }
        };
        this.myHost.getGraphicalControl().addDisposeListener(this.myDisposeListener);
    }

    public Control getControl() {
        return this.myPageBook;
    }

    public void setFocus() {
        if (this.myOutlinePage != null) {
            this.myOutlinePage.setFocus();
        }
    }

    public void dispose() {
        if (this.myOutlinePage != null) {
            this.myOutlinePage.dispose();
        }
        this.unhookOutlineViewer(this.myTreeViewer);
        if (this.myThumbnail != null) {
            this.myThumbnail.deactivate();
            this.myThumbnail = null;
        }
        if (this.myDisposeListener != null) {
            this.myHost.getGraphicalControl().removeDisposeListener(this.myDisposeListener);
        }
        this.myOverview = null;
        super.dispose();
    }
}

