/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ZoomableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandSelectionTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class ZoomTool
extends RubberbandSelectionTool {
    private static final int ZOOM_IN_MODE = 1;
    private static final int ZOOM_OUT_MODE = 2;
    private static final int ZOOM_PAN_MODE = 3;
    static final Cursor zoom_out_cursor = new Cursor(null, DiagramUIPluginImages.DESC_ZOOM_OUT.getImageData(), 0, 0);
    static final Cursor zoom_in_cursor = new Cursor(null, DiagramUIPluginImages.DESC_ZOOM_IN.getImageData(), 0, 0);
    static final Cursor zoom_pan_cursor = Cursors.HAND;
    private boolean zoomIn = true;
    private int zoommode = 1;

    public ZoomTool(boolean zoomIn) {
        this.zoomIn = zoomIn;
        this.zoommode = this.getInitialZoomMode();
        this.setUnloadWhenFinished(false);
    }

    protected Cursor getDefaultCursor() {
        if (this.getCurrentViewer() instanceof GraphicalViewer) {
            if (this.getZoomMode() == 1) {
                return zoom_in_cursor;
            }
            if (this.getZoomMode() == 2) {
                return zoom_out_cursor;
            }
            if (this.getZoomMode() == 3) {
                return zoom_pan_cursor;
            }
        }
        return Cursors.NO;
    }

    @Override
    protected String getCommandName() {
        return "selection";
    }

    @Override
    protected String getDebugName() {
        return "Zoom Tool";
    }

    private int getZoomMode() {
        return this.zoommode;
    }

    protected boolean handleViewerEntered() {
        boolean handled = super.handleViewerEntered();
        if (this.getCurrentViewer() != null) {
            this.getCurrentViewer().getControl().forceFocus();
            handled = true;
        }
        return handled;
    }

    @Override
    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyPressed(e)) {
            return true;
        }
        if (e.keyCode == 131072) {
            this.setZoomMode(this.zoomIn ? 2 : 1);
        }
        if (e.keyCode == 65536 && this.zoomIn) {
            this.setZoomMode(3);
        }
        return false;
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (super.handleKeyUp(e)) {
            return true;
        }
        if (e.keyCode == 131072 || e.keyCode == 65536) {
            this.setZoomMode(this.getInitialZoomMode());
        }
        return false;
    }

    @Override
    protected void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        ZoomableEditPart zoomableEditPart = null;
        if (viewer.getRootEditPart() instanceof ZoomableEditPart) {
            zoomableEditPart = (ZoomableEditPart)viewer.getRootEditPart();
        }
        Rectangle zoomRect = this.getMarqueeSelectionRectangle();
        if (zoomRect.width < 2 || zoomRect.height < 2) {
            if (this.getZoomMode() == 2) {
                zoomableEditPart.zoomOut(this.getLocation());
            } else if (this.getZoomMode() == 1) {
                zoomableEditPart.zoomIn(this.getLocation());
            }
        } else {
            zoomableEditPart.zoomTo(zoomRect);
        }
    }

    @Override
    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
    }

    private void setZoomMode(int zoommode) {
        this.zoommode = zoommode;
        this.setCursor(this.getDefaultCursor());
    }

    private int getInitialZoomMode() {
        return this.zoomIn ? 1 : 2;
    }
}

