/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.internal.l10n.CommonCoreMessages;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.IProviderPolicy;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;

public abstract class Service
extends AbstractProvider
implements IProvider,
IProviderChangeListener {
    protected static final String INVALID_ELEMENT_MESSAGE_PATTERN = "Invalid XML element ({0}).";
    private static final String A_NAME = "name";
    private static final String E_PRIORITY = "Priority";
    private static final int priorityCount;
    private static final List ignoredProviders;
    private final Map[] cache;
    private final ArrayList[] providers;
    private final boolean optimistic;

    static {
        List priorities = ProviderPriority.HIGHEST.getValues();
        int maxOrdinal = 0;
        Iterator i = priorities.iterator();
        while (i.hasNext()) {
            int ordinal = ((ProviderPriority)i.next()).getOrdinal();
            if (maxOrdinal >= ordinal) continue;
            maxOrdinal = ordinal;
        }
        priorityCount = maxOrdinal + 1;
        ignoredProviders = new ArrayList();
    }

    protected Service() {
        this(false);
    }

    protected Service(boolean optimized) {
        this(optimized, true);
    }

    protected Service(boolean optimized, boolean optimistic) {
        int ordinal;
        if (optimized) {
            this.cache = new Map[priorityCount];
            ordinal = priorityCount;
            while (--ordinal >= 0) {
                this.cache[ordinal] = this.createPriorityCache();
            }
        } else {
            this.cache = null;
        }
        this.optimistic = optimistic;
        this.providers = new ArrayList[priorityCount];
        ordinal = priorityCount;
        while (--ordinal >= 0) {
            this.providers[ordinal] = new ArrayList(0);
        }
    }

    protected Map createPriorityCache() {
        return new WeakHashMap();
    }

    protected Object getCachingKey(IOperation operation) {
        return operation;
    }

    protected final boolean isOptimized() {
        return this.cache != null;
    }

    protected final boolean isOptimistic() {
        return this.optimistic;
    }

    protected final void clearCache() {
        if (this.cache != null) {
            int ordinal = priorityCount;
            while (--ordinal >= 0) {
                this.cache[ordinal].clear();
            }
        }
    }

    final List getProviders(ProviderPriority priority) {
        return this.providers[priority.getOrdinal()];
    }

    protected final List getProviders(ExecutionStrategy strategy, ProviderPriority priority, IOperation operation) {
        List providerList;
        assert (priority != null) : "getProviders received null priority as argument";
        assert (operation != null) : "getproviders received null operation as argument";
        if (this.cache == null) {
            providerList = strategy.getUncachedProviders(this, priority, operation);
        } else {
            Object cachingKey = this.getCachingKey(operation);
            Map map = this.cache[priority.getOrdinal()];
            providerList = (List)map.get(cachingKey);
            if (providerList != null) {
                if (this.optimistic) {
                    return providerList;
                }
                int n = providerList.size();
                if (n != 0) {
                    IProvider provider;
                    int i = 0;
                    while (Service.safeProvides(provider = (IProvider)providerList.get(i), operation)) {
                        if (++i != n) continue;
                        return providerList;
                    }
                }
            }
            providerList = strategy.getUncachedProviders(this, priority, operation);
            map.put(cachingKey, providerList);
        }
        return providerList;
    }

    protected final List getAllProviders() {
        int n;
        int i = n = priorityCount;
        int total = 0;
        while (--i >= 0) {
            total += this.providers[i].size();
        }
        ArrayList allProviders = new ArrayList(total);
        i = 0;
        while (i < n) {
            allProviders.addAll(this.providers[i]);
            ++i;
        }
        return allProviders;
    }

    protected final void addProvider(ProviderPriority priority, ProviderDescriptor provider) {
        assert (priority != null) : "null ProviderPriority";
        assert (provider != null) : "null ProviderDescriptor";
        int ordinal = priority.getOrdinal();
        if (this.cache != null) {
            this.cache[ordinal].clear();
        }
        this.providers[ordinal].add(provider);
        provider.addProviderChangeListener(this);
    }

    protected final void removeProvider(ProviderDescriptor provider) {
        assert (provider != null) : "null provider";
        int i = 0;
        int n = priorityCount;
        while (i < n) {
            if (this.providers[i].remove(provider)) {
                provider.removeProviderChangeListener(this);
                this.clearCache();
                break;
            }
            ++i;
        }
    }

    protected final List execute(ExecutionStrategy strategy, IOperation operation) {
        assert (strategy != null) : "null strategy";
        assert (operation != null) : "null operation";
        List results = strategy.execute(this, operation);
        if (Trace.shouldTrace(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.SERVICES_EXECUTE)) {
            Trace.trace(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.SERVICES_EXECUTE, "Operation '" + operation + "' executed using strategy '" + strategy + "'.");
        }
        return results;
    }

    protected final Object executeUnique(ExecutionStrategy strategy, IOperation operation) {
        List results = this.execute(strategy, operation);
        return results.size() == 1 ? results.get(0) : null;
    }

    @Override
    public final boolean provides(IOperation operation) {
        assert (operation != null) : "null operation passed to provides(IOperation)";
        int priority = 0;
        int n = priorityCount;
        while (priority < n) {
            ArrayList providerList = this.providers[priority];
            int providerCount = providerList.size();
            int provider = 0;
            while (provider < providerCount) {
                if (Service.safeProvides((IProvider)providerList.get(provider), operation)) {
                    return true;
                }
                ++provider;
            }
            ++priority;
        }
        return false;
    }

    protected final boolean provides(ExecutionStrategy strategy, IOperation operation) {
        assert (strategy != null) : "null strategy";
        assert (operation != null) : "null operation";
        int i = 0;
        while (i < ExecutionStrategy.PRIORITIES.length) {
            ProviderPriority priority = ExecutionStrategy.PRIORITIES[i];
            List providerList = this.getProviders(strategy, priority, operation);
            int providerCount = providerList.size();
            int provider = 0;
            while (provider < providerCount) {
                if (Service.safeProvides((IProvider)providerList.get(provider), operation)) {
                    return true;
                }
                ++provider;
            }
            ++i;
        }
        return false;
    }

    @Override
    public final void providerChanged(ProviderChangeEvent event) {
        assert (event != null) : "null event";
        event.setSource(this);
        this.fireProviderChange(event);
    }

    public final void configureProviders(String namespace, String extensionPointName) {
        this.configureProviders(Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPointName).getConfigurationElements());
    }

    public final void configureProviders(IConfigurationElement[] elements) {
        assert (elements != null) : "null elements";
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            try {
                this.addProvider(ProviderPriority.parse(this.getPriority(element)), this.newProviderDescriptor(element));
            }
            finally {
                if (Trace.shouldTrace(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.SERVICES_CONFIG)) {
                    IExtension extension = element.getDeclaringExtension();
                    String identifier = extension.getUniqueIdentifier();
                    if (identifier == null) {
                        identifier = String.valueOf(extension.getNamespaceIdentifier());
                    }
                    extension.getExtensionPointUniqueIdentifier();
                    Trace.trace(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.SERVICES_CONFIG, "Provider of '" + extension.getExtensionPointUniqueIdentifier() + "' configured from extension '" + identifier + "'.");
                }
            }
            ++i;
        }
        i = priorityCount;
        while (--i >= 0) {
            this.providers[i].trimToSize();
        }
    }

    public String getPriority(IConfigurationElement element) {
        return element.getChildren(E_PRIORITY)[0].getAttribute(A_NAME);
    }

    protected ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    static boolean safeProvides(IProvider provider, IOperation operation) {
        assert (provider != null);
        try {
            return provider.provides(operation);
        }
        catch (Throwable e) {
            String providerClassName = provider.getClass().getName();
            if (!ignoredProviders.contains(providerClassName)) {
                ignoredProviders.add(providerClassName);
                Log.log(CommonCorePlugin.getDefault(), 4, 5, "Ignoring provider " + provider + " since it threw an exception or error in the provides() method", e);
            }
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            if (e instanceof VirtualMachineError) {
                throw (VirtualMachineError)e;
            }
            return false;
        }
    }

    static List getIgnoredProviders() {
        return ignoredProviders;
    }

    public static class ProviderDescriptor
    extends AbstractProvider
    implements IProvider,
    IProviderChangeListener {
        protected boolean policyInitialized = false;
        private String providerClassName;
        protected static final String A_CLASS = "class";
        protected static final String A_PLUGIN = "plugin";
        protected static final String E_POLICY = "Policy";
        private final IConfigurationElement element;
        protected IProvider provider;
        protected IProviderPolicy policy;
        private boolean providerClassInstantiationFailed = false;

        protected ProviderDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        protected final IConfigurationElement getElement() {
            return this.element;
        }

        public IProvider getProvider() {
            if (this.provider == null && !this.providerClassInstantiationFailed) {
                CommonCorePlugin corePlugin = CommonCorePlugin.getDefault();
                try {
                    Log.info(corePlugin, 0, "Activating provider '" + this.element.getAttribute(A_CLASS) + "'...");
                    this.provider = (IProvider)this.element.createExecutableExtension(A_CLASS);
                    this.provider.addProviderChangeListener(this);
                    Trace.trace(corePlugin, CommonCoreDebugOptions.SERVICES_ACTIVATE, "Provider '" + this.provider + "' activated.");
                }
                catch (CoreException ce) {
                    if (this.provider == null) {
                        this.providerClassInstantiationFailed = true;
                    }
                    Trace.catching(corePlugin, CommonCoreDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), "getProvider", ce);
                    IStatus status = ce.getStatus();
                    Log.log(corePlugin, status.getSeverity(), 5, CommonCoreMessages.bind((String)CommonCoreMessages.serviceProviderNotActivated, (Object)this.element.getAttribute(A_CLASS)), status.getException());
                }
            }
            return this.provider;
        }

        protected IProviderPolicy getPolicy() {
            if (!this.policyInitialized) {
                this.policyInitialized = true;
                IConfigurationElement[] elements = this.element.getChildren(E_POLICY);
                if (elements.length != 0) {
                    CommonCorePlugin corePlugin = CommonCorePlugin.getDefault();
                    try {
                        Log.info(corePlugin, 0, "Activating provider policy '" + elements[0].getAttribute(A_CLASS) + "'...");
                        this.policy = (IProviderPolicy)this.element.createExecutableExtension(E_POLICY);
                        Trace.trace(corePlugin, CommonCoreDebugOptions.SERVICES_ACTIVATE, "Provider policy '" + this.policy + "' activated.");
                    }
                    catch (CoreException ce) {
                        Trace.catching(corePlugin, CommonCoreDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), "getPolicy", ce);
                        IStatus status = ce.getStatus();
                        Log.log(corePlugin, status.getSeverity(), 5, status.getMessage(), status.getException());
                    }
                }
            }
            return this.policy;
        }

        @Override
        public boolean provides(IOperation operation) {
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                try {
                    return this.policy.provides(operation);
                }
                catch (Throwable e) {
                    Log.log(CommonCorePlugin.getDefault(), 4, 5, "Ignoring provider since policy " + this.policy + " threw an exception or error in the provides() method", e);
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    if (e instanceof VirtualMachineError) {
                        throw (VirtualMachineError)e;
                    }
                    return false;
                }
            }
            IProvider theProvider = this.getProvider();
            return theProvider != null ? Service.safeProvides(theProvider, operation) : false;
        }

        @Override
        public void providerChanged(ProviderChangeEvent event) {
            this.fireProviderChange(event);
        }

        public String toString() {
            if (this.providerClassName == null) {
                if (this.getElement() != null && this.getElement().isValid()) {
                    this.providerClassName = this.getElement().getAttribute(A_CLASS);
                }
                if (this.providerClassName == null) {
                    this.providerClassName = super.toString();
                }
            }
            return this.providerClassName;
        }
    }
}

