/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.render.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IExpandableFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramImageUtils {
    public static final Rectangle calculateImageRectangle(List<IGraphicalEditPart> editparts, double frameSize, Dimension defaultSize) {
        double minX = editparts.isEmpty() ? 0.0 : Double.MAX_VALUE;
        double maxX = editparts.isEmpty() ? 0.0 : Double.MIN_VALUE;
        double minY = editparts.isEmpty() ? 0.0 : Double.MAX_VALUE;
        double maxY = editparts.isEmpty() ? 0.0 : Double.MIN_VALUE;
        IFigure printableLayer = null;
        if (!editparts.isEmpty()) {
            printableLayer = LayerManager.Helper.find((EditPart)((EditPart)editparts.get(0))).getLayer((Object)"Printable Layers");
        }
        for (IGraphicalEditPart editPart : editparts) {
            IFigure figure = editPart.getFigure();
            Rectangle bounds = null;
            bounds = figure instanceof IExpandableFigure ? ((IExpandableFigure)figure).getExtendedBounds().getCopy() : figure.getBounds().getCopy();
            DiagramImageUtils.translateTo((Translatable)bounds, figure, printableLayer);
            minX = Math.min(minX, bounds.preciseX());
            maxX = Math.max(maxX, bounds.preciseX() + bounds.preciseWidth());
            minY = Math.min(minY, bounds.preciseY());
            maxY = Math.max(maxY, bounds.preciseY() + bounds.preciseHeight());
        }
        PrecisionRectangle rect = new PrecisionRectangle();
        rect.preciseWidth = maxX - minX;
        rect.preciseHeight = maxY - minY;
        if (defaultSize != null) {
            if (rect.preciseHeight <= 0.0) {
                rect.preciseHeight = defaultSize.preciseWidth();
            }
            if (rect.preciseHeight <= 0.0) {
                rect.preciseHeight = defaultSize.preciseHeight();
            }
        }
        rect.preciseX = minX - frameSize;
        rect.preciseY = minY - frameSize;
        rect.preciseWidth += 2.0 * frameSize;
        rect.preciseHeight += 2.0 * frameSize;
        rect.updateInts();
        return rect;
    }

    public static final Translatable translateTo(Translatable t, IFigure translateFrom, IFigure translateTo) {
        IFigure walker = translateFrom;
        while (walker != null && walker != translateTo) {
            walker.translateToParent(t);
            walker = walker.getParent();
        }
        return t;
    }

    public static void zOrderSort(List<? extends GraphicalEditPart> editparts, IFigure zOrderRoot) {
        if (editparts == null || editparts.size() < 2) {
            return;
        }
        final IdentityHashMap indexMap = new IdentityHashMap(editparts.size());
        for (GraphicalEditPart graphicalEditPart : editparts) {
            ArrayList<Integer> index = new ArrayList<Integer>();
            IFigure fig = graphicalEditPart.getFigure();
            while (fig != zOrderRoot && fig.getParent() != null) {
                index.add(fig.getParent().getChildren().indexOf(fig));
                fig = fig.getParent();
            }
            indexMap.put(graphicalEditPart, index);
        }
        Collections.sort(editparts, new Comparator<GraphicalEditPart>(){

            @Override
            public int compare(GraphicalEditPart ep1, GraphicalEditPart ep2) {
                List index1 = (List)indexMap.get(ep1);
                List index2 = (List)indexMap.get(ep2);
                int i = 0;
                while (i < index1.size() && i < index2.size()) {
                    int num2;
                    int num1 = (Integer)index1.get(index1.size() - 1 - i);
                    if (num1 < (num2 = ((Integer)index2.get(index2.size() - 1 - i)).intValue())) {
                        return -1;
                    }
                    if (num1 > num2) {
                        return 1;
                    }
                    ++i;
                }
                if (index1.size() < index2.size()) {
                    return 1;
                }
                if (index1.size() > index2.size()) {
                    return -1;
                }
                return 0;
            }
        });
    }
}

