/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.tests.CleanupTest;
import org.eclipse.gmf.tests.NeedsSetup;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.TestConfiguration;
import org.eclipse.gmf.tests.gef.CompartmentPropertiesTest;
import org.eclipse.gmf.tests.gef.DiagramEditorTest;
import org.eclipse.gmf.tests.gef.DiagramNodeTest;
import org.eclipse.gmf.tests.gen.AuditHandcodedTest;
import org.eclipse.gmf.tests.gen.CodegenReconcileTest;
import org.eclipse.gmf.tests.gen.FigureCodegenTest;
import org.eclipse.gmf.tests.gen.FigureLayoutTest;
import org.eclipse.gmf.tests.gen.GenFeatureSeqInitializerTest;
import org.eclipse.gmf.tests.gen.HandcodedContributionItemTest;
import org.eclipse.gmf.tests.gen.HandcodedGMFMapItemProvidersTest;
import org.eclipse.gmf.tests.gen.HandcodedGraphDefTest;
import org.eclipse.gmf.tests.gen.HandcodedImplTest;
import org.eclipse.gmf.tests.gen.HandcodedPaletteTest;
import org.eclipse.gmf.tests.gen.LabelSupportTest;
import org.eclipse.gmf.tests.gen.MapModeStrategyTest;
import org.eclipse.gmf.tests.gen.ModelLoadHelperTest;
import org.eclipse.gmf.tests.gen.OrganizeImportsPostprocessorTest;
import org.eclipse.gmf.tests.gen.RTFigureTest;
import org.eclipse.gmf.tests.gen.RuntimeCompilationTest;
import org.eclipse.gmf.tests.gen.ShapePropertiesTest;
import org.eclipse.gmf.tests.gen.StandaloneMapModeTest;
import org.eclipse.gmf.tests.gen.StandalonePluginConverterTest;
import org.eclipse.gmf.tests.gen.ToolDefHandocodedImplTest;
import org.eclipse.gmf.tests.gen.ViewmapProducersTest;
import org.eclipse.gmf.tests.migration.AllMigrationTests;
import org.eclipse.gmf.tests.rt.AuditRulesTest;
import org.eclipse.gmf.tests.rt.ElementInitializerTest;
import org.eclipse.gmf.tests.rt.LinkCreationConstraintsTest;
import org.eclipse.gmf.tests.rt.LinkCreationTest;
import org.eclipse.gmf.tests.rt.MetricRulesTest;
import org.eclipse.gmf.tests.setup.LinksSessionSetup;
import org.eclipse.gmf.tests.setup.RuntimeWorkspaceSetup;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.gmf.tests.setup.TestSetupTest;
import org.eclipse.gmf.tests.setup.figures.FigureCodegenSetup;
import org.eclipse.gmf.tests.setup.figures.FigureLayoutSetup;
import org.eclipse.gmf.tests.setup.figures.LabelSupportSetup;
import org.eclipse.gmf.tests.setup.figures.ShapePropertiesSetup;
import org.eclipse.gmf.tests.tr.AuditRootTest;
import org.eclipse.gmf.tests.tr.EcoreGenModelMatcherTest;
import org.eclipse.gmf.tests.tr.GenModelGraphAnalyzerTest;
import org.eclipse.gmf.tests.tr.GenModelTransformerBasicRTTest;
import org.eclipse.gmf.tests.tr.GenModelTransformerSimpleTest;
import org.eclipse.gmf.tests.tr.HistoryTest;
import org.eclipse.gmf.tests.tr.LabelMappingTransformTest;
import org.eclipse.gmf.tests.tr.ManifestMergeTest;
import org.eclipse.gmf.tests.tr.NamingStrategyTest;
import org.eclipse.gmf.tests.tr.PaletteTransformationTest;
import org.eclipse.gmf.tests.tr.PluginXMLTextMergerTest;
import org.eclipse.gmf.tests.tr.TestDefaultMergeService;
import org.eclipse.gmf.tests.tr.TransformToGenModelOperationTest;
import org.eclipse.gmf.tests.tr.XmlTextMergerTest;
import org.eclipse.gmf.tests.validate.AllValidateTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllTests {
    public static Test suite() throws Exception {
        EMFTypePlugin.startDynamicAwareMode();
        TestSuite suite = new TestSuite("Tests for org.eclipse.gmf, tooling side");
        AllTests.switchAutobuildOff();
        final SessionSetup sessionSetup = SessionSetup.newInstance();
        final LinksSessionSetup sessionSetup2 = (LinksSessionSetup)LinksSessionSetup.newInstance();
        SessionSetup.disallowSingleTestCaseUse();
        RuntimeWorkspaceSetup.INSTANCE = new RuntimeWorkspaceSetup().initFull();
        try {
            sessionSetup.getGenProject();
            sessionSetup2.getGenProject();
        }
        catch (Exception e) {
            suite.addTest((Test)new TestCase("Session setup initialization problem"){

                protected void runTest() throws Throwable {
                    e.printStackTrace();
                    1.fail((String)e.getMessage());
                }
            });
            return suite;
        }
        suite.addTestSuite(TestSetupTest.class);
        suite.addTest(AllTests.feed(HandcodedImplTest.class, sessionSetup));
        suite.addTestSuite(HandcodedGraphDefTest.class);
        suite.addTestSuite(HandcodedPaletteTest.class);
        suite.addTestSuite(HandcodedContributionItemTest.class);
        suite.addTestSuite(HandcodedGMFMapItemProvidersTest.class);
        suite.addTest(AllTests.feed(GenModelTransformerSimpleTest.class, sessionSetup));
        suite.addTest(AllTests.feed(TransformToGenModelOperationTest.class, sessionSetup));
        suite.addTest(AllTests.feed(LabelMappingTransformTest.class, sessionSetup));
        suite.addTest(AllTests.feed(PaletteTransformationTest.class, sessionSetup));
        suite.addTestSuite(AuditRootTest.class);
        suite.addTestSuite(HistoryTest.class);
        suite.addTestSuite(XmlTextMergerTest.class);
        suite.addTestSuite(TestDefaultMergeService.class);
        suite.addTestSuite(PluginXMLTextMergerTest.class);
        suite.addTestSuite(ManifestMergeTest.class);
        suite.addTestSuite(OrganizeImportsPostprocessorTest.class);
        suite.addTestSuite(EcoreGenModelMatcherTest.class);
        suite.addTestSuite(ModelLoadHelperTest.class);
        suite.addTest(AllMigrationTests.suite());
        suite.addTest(AllValidateTests.suite());
        suite.addTest(AllTests.feed(FigureCodegenTest.class, new FigureCodegenSetup()));
        suite.addTest(AllTests.feed(LabelSupportTest.class, new LabelSupportSetup()));
        suite.addTest(AllTests.feed(ShapePropertiesTest.class, new ShapePropertiesSetup()));
        suite.addTest(AllTests.feed(FigureLayoutTest.class, new FigureLayoutSetup()));
        suite.addTestSuite(StandaloneMapModeTest.class);
        suite.addTestSuite(StandalonePluginConverterTest.class);
        suite.addTestSuite(RTFigureTest.class);
        suite.addTestSuite(MapModeStrategyTest.class);
        suite.addTestSuite(ViewmapProducersTest.class);
        suite.addTestSuite(ToolDefHandocodedImplTest.class);
        suite.addTest(AllTests.feed(AuditHandcodedTest.class, sessionSetup));
        suite.addTest(AllTests.feed(AuditRulesTest.class, sessionSetup2));
        suite.addTest(AllTests.feed(ElementInitializerTest.class, sessionSetup2));
        suite.addTest(AllTests.feed(CodegenReconcileTest.class, sessionSetup));
        suite.addTestSuite(RuntimeCompilationTest.class);
        suite.addTest(AllTests.feed(DiagramNodeTest.class, sessionSetup));
        suite.addTest(AllTests.feed(CompartmentPropertiesTest.class, sessionSetup));
        suite.addTest(AllTests.feed(NamingStrategyTest.class, sessionSetup));
        suite.addTest(AllTests.feed(GenModelTransformerBasicRTTest.class, sessionSetup));
        suite.addTest(AllTests.feed(DiagramEditorTest.class, sessionSetup));
        suite.addTest(AllTests.feed(LinkCreationTest.class, sessionSetup));
        suite.addTest(AllTests.feed(LinkCreationConstraintsTest.class, sessionSetup2));
        suite.addTest(AllTests.feed(MetricRulesTest.class, sessionSetup2));
        suite.addTestSuite(GenFeatureSeqInitializerTest.class);
        suite.addTestSuite(GenModelGraphAnalyzerTest.class);
        suite.addTest((Test)new CleanupTest("testCleanup"){

            protected void performCleanup() throws Exception {
                sessionSetup.cleanup();
                sessionSetup2.cleanup();
            }
        });
        return suite;
    }

    protected static Test feed(Class<?> theClass, TestConfiguration config) {
        TestSuite suite = new TestSuite(theClass);
        if (!NeedsSetup.class.isAssignableFrom(theClass)) {
            return suite;
        }
        try {
            Method m = null;
            Class<?> configClass = config.getClass();
            while (m == null && configClass != null) {
                try {
                    m = theClass.getMethod("configure", configClass);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    configClass = configClass.getSuperclass();
                }
            }
            if (m == null) {
                String methodInvocation = "configure(" + config.getClass().getName() + " arg);";
                return new ConfigurationFailedCase(String.valueOf(theClass.getName()) + " has no method compatible with " + methodInvocation);
            }
            Object[] args = new Object[]{config};
            Enumeration en = suite.tests();
            while (en.hasMoreElements()) {
                Object nextTest = en.nextElement();
                m.invoke(nextTest, args);
            }
        }
        catch (SecurityException ex) {
            return new ConfigurationFailedCase(String.valueOf(theClass.getName()) + ": " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            return new ConfigurationFailedCase(String.valueOf(theClass.getName()) + ": " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            return new ConfigurationFailedCase(String.valueOf(theClass.getName()) + ": " + ex.getMessage());
        }
        return suite;
    }

    protected static void switchAutobuildOff() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(false);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            Plugin.logError("Unable to switch off autobuild due to exception: " + e.getMessage());
        }
    }

    private static class ConfigurationFailedCase
    extends TestCase {
        private final String cause;

        ConfigurationFailedCase(String aCause) {
            super(ConfigurationFailedCase.class.getName());
            this.cause = aCause;
        }

        protected void runTest() throws Throwable {
            ConfigurationFailedCase.fail((String)this.cause);
        }
    }
}

