/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.validate.AbstractValidator;
import org.eclipse.gmf.internal.validate.ConstraintDef;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.DefUtils;
import org.eclipse.gmf.internal.validate.ExternModelImport;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.IDefElementProvider;
import org.eclipse.gmf.internal.validate.LabelProvider;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.internal.validate.ValueSpecDef;
import org.eclipse.gmf.internal.validate.expressions.EnvironmentProvider;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpressionProvider;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedDefinitionValidator
extends AbstractValidator
implements EValidator {
    public ValueSpecDef getDefinition(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass eClass = eObject instanceof EClass ? (EClass)eObject : eObject.eClass();
        return this.getDefinition(eClass, eObject, diagnostics, null, context);
    }

    @Override
    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    @Override
    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    @Override
    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eObject.eClass().getEPackage() == EcorePackage.eINSTANCE) {
            if (eObject instanceof EModelElement) {
                return this.validateMetaModel((EModelElement)eObject, diagnostics, context);
            }
        } else {
            return this.validateModel(eObject, diagnostics, context);
        }
        return true;
    }

    protected boolean validateModel(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String body;
        ValueSpecDef def = this.getDefinition(eObject, diagnostics, context);
        if (def == null) {
            return true;
        }
        if (!def.isOK()) {
            return false;
        }
        String lang = def.createLanguage(eObject);
        if (!("ocl".equals(lang) || "regexp".equals(lang) || "nregexp".equals(lang))) {
            return true;
        }
        EObject[] contexEClassEvalCtx = new EObject[1];
        ContextData contextData = this.getContextBinding(eObject, contexEClassEvalCtx, context);
        if (contextData == null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE, NLS.bind((String)Messages.def_NoContextAvailable, (Object)AnnotatedDefinitionValidator.getLabelProvider(context).getObjectLabel(eObject)), new Object[]{eObject}));
            return false;
        }
        EClassifier contextClass = contextData.contextClass.getContextClassifier(contexEClassEvalCtx[0]);
        if (contextClass == null) {
            String noCtxMessage = contextData.contextClass.getStatus().isOK() ? NLS.bind((String)Messages.def_NoContextAvailable, (Object)AnnotatedDefinitionValidator.getLabelProvider(context).getObjectLabel(eObject)) : contextData.contextClass.getStatus().getMessage();
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.NO_VALUESPEC_CONTEXT_AVAILABLE, noCtxMessage, new Object[]{eObject}));
        }
        if ((body = def.createBody(eObject)) != null && contextClass != null) {
            IStatus typeConformanceStatus;
            IModelExpression expression;
            IDefElementProvider.TypeProvider typeProvider;
            IParseEnvironment env = null;
            if (contextData.environment != null) {
                env = EnvironmentProvider.createParseEnv();
                env.setImportRegistry(ExternModelImport.getPackageRegistry(context));
                for (String varName : contextData.environment.keySet()) {
                    typeProvider = contextData.environment.get(varName);
                    EClassifier type = typeProvider.getType(contexEClassEvalCtx[0]);
                    if (type == null) continue;
                    env.setVariable(varName, type);
                }
            }
            if (!(expression = AnnotatedDefinitionValidator.getExpression(lang, body, contextClass, env, context)).getStatus().isOK()) {
                String message = MessageFormat.format(Messages.invalidExpressionBody, expression.getBody(), expression.getStatus().getMessage());
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.INVALID_CONSTRAINT_EXPRESSION, message, new Object[]{eObject}));
                return false;
            }
            EObject typeResolutionContext = eObject;
            typeProvider = def.getTypeRestriction();
            if (typeProvider == null && eObject.eContainingFeature() != null) {
                EStructuralFeature containingFeature = eObject.eContainingFeature();
                typeProvider = AnnotatedDefinitionValidator.getTypeInfo((EModelElement)containingFeature, eObject.eContainer().eClass(), diagnostics, context);
                typeResolutionContext = eObject.eContainer();
            }
            if (typeProvider != null && typeProvider.getStatus().isOK() && expression.getResultType() != null && !(typeConformanceStatus = AnnotatedDefinitionValidator.getTypeConformancyStatus(typeResolutionContext, typeProvider, expression)).isOK()) {
                diagnostics.add(DefUtils.statusToDiagnostic(typeConformanceStatus, "org.eclipse.gmf.validation", eObject));
                return false;
            }
        }
        return true;
    }

    public ContextData getContextBinding(EObject eObject, EObject[] contextHolder, Map<Object, Object> context) {
        EStructuralFeature feature = eObject.eContainingFeature();
        if (feature != null) {
            EObject container = eObject.eContainer();
            ContextData contextData = AnnotatedDefinitionValidator.getCachedCtxBinding((EModelElement)feature, context);
            if (contextData != null) {
                contextHolder[0] = container;
                return contextData;
            }
            IDefElementProvider.ContextProvider contextProvider = AnnotatedDefinitionValidator.getContextClass(feature, context);
            if (contextProvider != null) {
                ContextData newContextData = new ContextData(contextProvider, AnnotatedDefinitionValidator.getEnvProvider(feature, context));
                AnnotatedDefinitionValidator.registerCtxBinding(feature, newContextData, context);
                contextHolder[0] = container;
                if (Trace.shouldTrace(DebugOptions.META_DEFINITIONS)) {
                    String msgPtn = "[context-def] {0} binding: {1}::{2}";
                    Trace.trace(MessageFormat.format(msgPtn, newContextData.contextClass.toString(), LabelProvider.INSTANCE.getObjectLabel((EObject)container.eClass()), LabelProvider.INSTANCE.getObjectLabel((EObject)feature)));
                }
                return newContextData;
            }
            if (eObject.eContainer() != null) {
                return this.getContextBinding(eObject.eContainer(), contextHolder, context);
            }
        }
        contextHolder[0] = null;
        return null;
    }

    protected boolean validateMetaModel(EModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EAnnotation annotation;
        EAnnotation eAnnotation = annotation = modelElement instanceof EAnnotation ? (EAnnotation)modelElement : null;
        if (annotation != null) {
            if (!"http://www.eclipse.org/gmf/2005/constraints/meta".equals(annotation.getSource())) {
                return true;
            }
            modelElement = annotation.getEModelElement();
            if (modelElement == null) {
                return true;
            }
        }
        if (modelElement instanceof EStructuralFeature && annotation != null && "context".equals(annotation.getDetails().get((Object)"def"))) {
            EStructuralFeature sfeature = (EStructuralFeature)modelElement;
            IDefElementProvider.ContextProvider contextProvider = AnnotatedDefinitionValidator.getContextClass(sfeature, context);
            if (contextProvider != null) {
                AnnotatedDefinitionValidator.getEnvProvider(sfeature, context);
                if (!contextProvider.getStatus().isOK()) {
                    DefUtils.mergeAndFlatten(contextProvider.getStatus(), "org.eclipse.gmf.validation", annotation, diagnostics);
                    return false;
                }
            }
        } else if (modelElement instanceof EClass) {
            this.getDefinition((EClass)modelElement, (EObject)modelElement, diagnostics, null, context);
        }
        return true;
    }

    public static IDefElementProvider.ContextProvider getContextClass(EStructuralFeature bindFeature, final Map<Object, Object> validationContext) {
        IModelExpressionProvider oclExprProvider = new IModelExpressionProvider(){

            public IModelExpression createExpression(String body, EClassifier contextClassifier) {
                return AnnotatedDefinitionValidator.getExpression("ocl", body, contextClassifier, validationContext);
            }

            public IModelExpression createExpression(String body, EClassifier context, IParseEnvironment extEnv) {
                return this.createExpression(body, context);
            }
        };
        EClass resolutionContext = bindFeature.getEContainingClass();
        return DefUtils.getContextClass(resolutionContext, oclExprProvider, bindFeature, ExternModelImport.getPackageRegistry(validationContext));
    }

    private IDefElementProvider.ContextProvider createContextProvider(String ctxExpression, EClass contextClass, Map<Object, Object> context) {
        return new DefUtils.ExpressionContextProvider(AnnotatedDefinitionValidator.getExpression("ocl", ctxExpression, (EClassifier)contextClass, context));
    }

    public ValueSpecDef getDefinition(EClass metaClass, EObject modelElement, DiagnosticChain diagnostics, DefData data, Map<Object, Object> context) {
        ValueSpecDef definition = AnnotatedDefinitionValidator.findDefinition(metaClass, context);
        if (definition != null) {
            return definition;
        }
        if (data == null) {
            for (EAnnotation nextAnnotation : metaClass.getEAnnotations()) {
                String val;
                if (!"http://www.eclipse.org/gmf/2005/constraints/meta".equals(nextAnnotation.getSource()) || (val = (String)nextAnnotation.getDetails().get((Object)"def")) == null || !val.equals("ValueSpec") && !val.equals("Constraint")) continue;
                data = new DefData();
                data.metaKey = val;
                data.defClass = metaClass;
                break;
            }
        }
        EList superTypes = metaClass.getESuperTypes();
        if (data == null && superTypes.isEmpty()) {
            return null;
        }
        if (data != null) {
            for (EStructuralFeature nextAttr : metaClass.getEStructuralFeatures()) {
                for (EAnnotation annotation : nextAttr.getEAnnotations()) {
                    String ctxExpression;
                    if (!"http://www.eclipse.org/gmf/2005/constraints/meta".equals(annotation.getSource())) continue;
                    String metaValue = (String)annotation.getDetails().get((Object)"def");
                    if (data.body == null && "body".equals(metaValue)) {
                        data.body = new DefUtils.FeatureValProvider(nextAttr);
                        AnnotatedDefinitionValidator.checkAndReportProblems(data.body, (EObject)annotation, diagnostics);
                    }
                    if (data.lang == null && "lang".equals(metaValue)) {
                        data.lang = new DefUtils.FeatureValProvider(nextAttr);
                        AnnotatedDefinitionValidator.checkAndReportProblems(data.lang, (EObject)annotation, diagnostics);
                    }
                    if (data.context == null && "context".equals(metaValue) && (ctxExpression = (String)annotation.getDetails().get((Object)"ocl")) != null) {
                        data.context = this.createContextProvider(ctxExpression, metaClass, context);
                        AnnotatedDefinitionValidator.checkAndReportProblems(data.context, (EObject)annotation, diagnostics);
                    }
                    if (data.type != null || !"type".equals(metaValue)) continue;
                    String typeExpr = (String)annotation.getDetails().get((Object)"ocl");
                    data.type = typeExpr != null ? new DefUtils.ExpresssionTypeProvider(AnnotatedDefinitionValidator.getExpression("ocl", typeExpr, (EClassifier)metaClass, context)) : new DefUtils.TypedElementProvider(nextAttr);
                    AnnotatedDefinitionValidator.checkAndReportProblems(data.type, (EObject)annotation, diagnostics);
                }
            }
            if (data.type == null) {
                data.type = AnnotatedDefinitionValidator.getTypeInfo((EModelElement)metaClass, metaClass, diagnostics, context);
            }
            if (data.body != null) {
                definition = this.createDefinition(data);
                assert (data.defClass != null);
                AnnotatedDefinitionValidator.registerDefinition(data.defClass, definition, context);
                return definition;
            }
        }
        for (EClass superClass : superTypes) {
            ValueSpecDef inheritedDef = this.getDefinition(superClass, modelElement, diagnostics, data, context);
            if (inheritedDef == null) continue;
            if (data == null) {
                data = new DefData();
            }
            AnnotatedDefinitionValidator.inheritDefinition(data, metaClass, inheritedDef);
            AnnotatedDefinitionValidator.registerDefinition(data.defClass, this.createDefinition(data), context);
            return inheritedDef;
        }
        if (data != null && data.body == null) {
            data.body = AnnotatedDefinitionValidator.createMissingBodyProvider(LabelProvider.INSTANCE.getObjectLabel(modelElement));
            AnnotatedDefinitionValidator.checkAndReportProblems(data.body, modelElement, diagnostics);
            return this.createDefinition(data);
        }
        return null;
    }

    private static IDefElementProvider.TypeProvider getTypeInfo(EModelElement typeAnnotationSource, EClass resolutionContext, DiagnosticChain diagnostics, Map<Object, Object> validationContext) {
        String typeExprBody;
        EAnnotation typeAnnotation;
        DefUtils.AbstractProvider typeProvider = null;
        List<EAnnotation> annotations = DefUtils.getAnnotationsWithKeyAndValue(typeAnnotationSource, "http://www.eclipse.org/gmf/2005/constraints/meta", "def", "type");
        EAnnotation eAnnotation = typeAnnotation = annotations.isEmpty() ? null : annotations.get(0);
        if (typeAnnotation != null && "type".equals(typeAnnotation.getDetails().get((Object)"def")) && (typeExprBody = (String)typeAnnotation.getDetails().get((Object)"ocl")) != null) {
            IModelExpression typeExpr = AnnotatedDefinitionValidator.getExpression("ocl", typeExprBody, (EClassifier)resolutionContext, validationContext);
            boolean usesTypeName = typeExpr.getStatus().isOK() && String.class.equals((Object)typeExpr.getResultType().getInstanceClass());
            typeProvider = usesTypeName ? new DefUtils.ContextTypeAdapter(new DefUtils.LookupByNameContextProvider(typeExpr, ExternModelImport.getPackageRegistry(validationContext))) : new DefUtils.ExpresssionTypeProvider(typeExpr);
            AnnotatedDefinitionValidator.checkAndReportProblems(typeProvider, (EObject)typeAnnotation, diagnostics);
        }
        return typeProvider;
    }

    private static void inheritDefinition(DefData data, EClass valueSpecEClass, ValueSpecDef superDef) {
        data.defClass = valueSpecEClass;
        if (data.body == null) {
            data.body = superDef.getBody();
        }
        if (data.lang == null) {
            data.lang = superDef.getLang();
        }
        if (data.type == null) {
            data.type = superDef.getTypeRestriction();
        }
    }

    private ValueSpecDef createDefinition(DefData data) {
        ValueSpecDef valueSpecDef;
        assert (data != null);
        assert (data.body != null);
        ValueSpecDef valueSpecDef2 = valueSpecDef = "Constraint".equals(data.metaKey) ? new ConstraintDef(data.body, data.lang) : new ValueSpecDef(data.body, data.lang, data.type);
        if (Trace.shouldTrace(DebugOptions.META_DEFINITIONS)) {
            String msgPtn = "[{0}] {1} type: {2}";
            Trace.trace(MessageFormat.format(msgPtn, data.metaKey, data.defClass.getName(), data.type));
        }
        return valueSpecDef;
    }

    private static boolean checkAndReportProblems(IDefElementProvider defElementProvider, EObject destination, DiagnosticChain diagnostics) {
        if (!defElementProvider.getStatus().isOK()) {
            diagnostics.add(DefUtils.statusToDiagnostic(defElementProvider.getStatus(), "org.eclipse.gmf.validation", destination));
            return false;
        }
        return true;
    }

    private static ValueSpecDef findDefinition(EClass eClass, Map<Object, Object> context) {
        if (context != null) {
            Map defMap = (Map)context.get(ValueSpecDef.class);
            return defMap != null ? (ValueSpecDef)defMap.get(eClass) : null;
        }
        return null;
    }

    private static ContextData getCachedCtxBinding(EModelElement modelElement, Map<Object, Object> context) {
        Map bindMap;
        if (context != null && (bindMap = (Map)context.get(IDefElementProvider.ContextProvider.class)) != null) {
            return (ContextData)bindMap.get(modelElement);
        }
        if (Trace.shouldTrace(DebugOptions.DEBUG)) {
            Trace.trace("Performance warning: Validation should run in a context for caching");
        }
        return null;
    }

    private static Map<String, IDefElementProvider.TypeProvider> getEnvProvider(EStructuralFeature contextBindFeature, Map<Object, Object> context) {
        List<EAnnotation> varDefs = DefUtils.getAnnotationsWithKeyAndValue((EModelElement)contextBindFeature, "http://www.eclipse.org/gmf/2005/constraints/meta", "def", "variable");
        if (varDefs.isEmpty()) {
            return null;
        }
        HashMap<String, DefUtils.ExpresssionTypeProvider> env = null;
        for (EAnnotation nextVarAnnotation : varDefs) {
            String name;
            String body;
            DefUtils.ExpresssionTypeProvider type = null;
            String typePrefix = "type.";
            Map.Entry<String, String> typeExpression = DefUtils.getKeyPrefixAnnotation(nextVarAnnotation, typePrefix);
            if (typeExpression != null && (body = typeExpression.getValue()) != null) {
                IModelExpression expression = AnnotatedDefinitionValidator.getExpression("ocl", body, (EClassifier)contextBindFeature.getEContainingClass(), context);
                type = new DefUtils.ExpresssionTypeProvider(expression);
            }
            if ((name = (String)nextVarAnnotation.getDetails().get((Object)"name")) == null) continue;
            if (env == null) {
                env = new HashMap<String, DefUtils.ExpresssionTypeProvider>();
            }
            env.put(name, type);
        }
        return env;
    }

    private static void registerCtxBinding(EStructuralFeature contextDefOwner, ContextData contextData, Map<Object, Object> context) {
        if (context != null) {
            HashMap<EStructuralFeature, ContextData> bindMap = (HashMap<EStructuralFeature, ContextData>)context.get(IDefElementProvider.ContextProvider.class);
            if (bindMap == null) {
                bindMap = new HashMap<EStructuralFeature, ContextData>();
                context.put(IDefElementProvider.ContextProvider.class, bindMap);
            }
            bindMap.put(contextDefOwner, contextData);
        }
    }

    private static void registerDefinition(EClass eClass, ValueSpecDef definition, Map<Object, Object> context) {
        assert (definition != null);
        assert (eClass != null);
        if (context != null) {
            HashMap<EClass, ValueSpecDef> defMap = (HashMap<EClass, ValueSpecDef>)context.get(ValueSpecDef.class);
            if (defMap == null) {
                defMap = new HashMap<EClass, ValueSpecDef>();
                context.put(ValueSpecDef.class, defMap);
            }
            defMap.put(eClass, definition);
        }
    }

    private static IDefElementProvider.StringValProvider createMissingBodyProvider(final String elementLabel) {
        return new IDefElementProvider.StringValProvider(){

            public IStatus getStatus() {
                String message = MessageFormat.format(Messages.def_MissingBodyAnnotation, elementLabel);
                return GMFValidationPlugin.createStatus(4, StatusCodes.MISSING_VALUESPEC_BODY_ANNOTATION, message, null);
            }

            public String getValue(EObject contextInstance) {
                return null;
            }
        };
    }

    private static IStatus getTypeConformancyStatus(EObject typeProviderContext, IDefElementProvider.TypeProvider leftType, IModelExpression expression) {
        assert (leftType != null && leftType.getStatus().isOK());
        if (leftType.hasTypedElement()) {
            ETypedElement typedElement = leftType.getTypedElement(typeProviderContext);
            if (typedElement == null) {
                return GMFValidationPlugin.createStatus(2, StatusCodes.VALUESPEC_TYPE_NOT_AVAILABLE, Messages.def_NoTypeAvailable, null);
            }
            if (!expression.isAssignableToElement(typedElement)) {
                return DefUtils.getIncompatibleTypesStatus(typedElement.getEType(), expression.getResultType());
            }
        } else {
            EClassifier type = leftType.getType(typeProviderContext);
            if (type == null) {
                return GMFValidationPlugin.createStatus(2, StatusCodes.VALUESPEC_TYPE_NOT_AVAILABLE, Messages.def_NoTypeAvailable, null);
            }
            if (!expression.isAssignableTo(type)) {
                return DefUtils.getIncompatibleTypesStatus(type, expression.getResultType());
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextData {
        final IDefElementProvider.ContextProvider contextClass;
        final Map<String, IDefElementProvider.TypeProvider> environment;

        public ContextData(IDefElementProvider.ContextProvider contextProvider, Map<String, IDefElementProvider.TypeProvider> environment) {
            this.contextClass = contextProvider;
            this.environment = environment;
        }
    }

    private static class DefData {
        String metaKey;
        EClass defClass;
        IDefElementProvider.StringValProvider body;
        IDefElementProvider.StringValProvider lang;
        IDefElementProvider.TypeProvider type;
        IDefElementProvider.ContextProvider context;
    }
}

