/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramDebugOptions;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramPlugin;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.PersistElementCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewUtil {
    public static final int APPEND = -1;

    public static List makeViewsAdaptable(Collection views) {
        ArrayList<EObjectAdapter> list = new ArrayList<EObjectAdapter>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            list.add(new EObjectAdapter((EObject)((View)it.next())));
        }
        return list;
    }

    public static void persistElement(View view) {
        View viewToPersist;
        assert (view != null) : "null view in ViewUtil.persistElement";
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)view);
        if (!view.isMutable() && (viewToPersist = ViewUtil.getTopViewToPersist(view)) != null) {
            PersistElementCommand pvc = new PersistElementCommand(editingDomain, viewToPersist);
            try {
                pvc.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Trace.catching((Plugin)DiagramPlugin.getInstance(), (String)DiagramDebugOptions.EXCEPTIONS_CATCHING, ViewUtil.class, (String)"persistElement", (Throwable)e);
                Log.error((Plugin)DiagramPlugin.getInstance(), (int)9, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            CommandResult result = pvc.getCommandResult();
            view = (View)result.getReturnValue();
        }
    }

    public static View getTopViewToPersist(View view) {
        EObject container = view.eContainer();
        if (container == null) {
            return null;
        }
        if (view instanceof Edge) {
            Diagram dContainer = (Diagram)container;
            if (dContainer.eIsSet((EStructuralFeature)NotationPackage.Literals.DIAGRAM__TRANSIENT_EDGES)) {
                return view;
            }
            return ViewUtil.getTopViewToPersist((View)dContainer);
        }
        if (container instanceof View) {
            View vContainer = (View)container;
            if (vContainer.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__TRANSIENT_CHILDREN)) {
                return view;
            }
            return ViewUtil.getTopViewToPersist(vContainer);
        }
        return null;
    }

    public static void destroy(View view) {
        if (view == null) {
            return;
        }
        for (View child : new ArrayList(view.getChildren())) {
            ViewUtil.destroy(child);
        }
        DestroyElementCommand.destroy((EObject)view);
    }

    public static View getContainerView(View eObject) {
        EObject container = eObject.eContainer();
        if (container instanceof View) {
            return (View)container;
        }
        return null;
    }

    public static void insertChildView(View containerView, View childView, int index, boolean persisted) {
        if (persisted) {
            ViewUtil.insertPersistedElement(containerView, childView, index);
        } else {
            ViewUtil.insertTransientElement(containerView, childView);
        }
    }

    private static void insertTransientElement(View container, View child) {
        if (child instanceof Edge) {
            Diagram diagram = (Diagram)container;
            diagram.insertEdge((Edge)child, false);
        } else {
            container.insertChild(child, false);
        }
    }

    private static void insertPersistedElement(View container, View child, int index) {
        if (child instanceof Edge) {
            Diagram diagram = (Diagram)container;
            if (index == -1) {
                diagram.insertEdge((Edge)child);
            } else {
                diagram.insertEdgeAt((Edge)child, index);
            }
        } else if (index == -1) {
            container.insertChild(child);
        } else {
            container.insertChildAt(child, index);
        }
    }

    public static boolean isTransient(EObject view) {
        EStructuralFeature sFeature = view.eContainingFeature();
        if (sFeature == null) {
            return false;
        }
        if (sFeature.isTransient()) {
            return true;
        }
        EObject container = view.eContainer();
        if (container != null) {
            return ViewUtil.isTransient(container);
        }
        return false;
    }

    public static View getChildBySemanticHint(View view, String semanticHint) {
        for (View child : view.getChildren()) {
            if (!semanticHint.equals(child.getType())) continue;
            return child;
        }
        return null;
    }

    public static boolean isPropertySupported(View view, Object id) {
        EStructuralFeature feature;
        if (id instanceof String && (feature = (EStructuralFeature)PackageUtil.getElement((String)((String)id))) != null) {
            return ViewUtil.isPropertySupported(view, feature, feature.getEContainingClass());
        }
        return false;
    }

    public static boolean isFeatureSupported(View view, EStructuralFeature feature) {
        if (feature != null) {
            return ViewUtil.isPropertySupported(view, feature, feature.getEContainingClass());
        }
        return false;
    }

    public static boolean isPropertySupported(View view, EStructuralFeature feature, EClass featureClass) {
        LayoutConstraint constraint;
        if (view.getStyle(featureClass) != null) {
            return true;
        }
        if (view instanceof Node && (constraint = ((Node)view).getLayoutConstraint()) != null && featureClass.isInstance((Object)constraint)) {
            return true;
        }
        return featureClass.isInstance((Object)view);
    }

    public static final Object getStructuralFeatureValue(View view, EStructuralFeature feature) {
        if (feature != null) {
            return ViewUtil.getPropertyValue(view, feature, feature.getEContainingClass());
        }
        return null;
    }

    public static Object getPropertyValue(View view, EStructuralFeature feature, EClass featureClass) {
        LayoutConstraint constraint;
        Style style = view.getStyle(featureClass);
        if (style != null) {
            return style.eGet(feature);
        }
        if (view instanceof Node && (constraint = ((Node)view).getLayoutConstraint()) != null && featureClass.isInstance((Object)constraint)) {
            return constraint.eGet(feature);
        }
        if (featureClass.isInstance((Object)view)) {
            return view.eGet(feature);
        }
        return feature.getDefaultValue();
    }

    public static void setStructuralFeatureValue(View view, EStructuralFeature feature, Object value) {
        if (feature != null) {
            ViewUtil.setPropertyValue(view, feature, feature.getEContainingClass(), value);
            return;
        }
    }

    public static void setPropertyValue(View view, EStructuralFeature feature, EClass featureClass, Object value) {
        Node node;
        LayoutConstraint constraint;
        if (view == null) {
            return;
        }
        Style style = view.getStyle(featureClass);
        if (style != null) {
            style.eSet(feature, value);
            return;
        }
        if (view instanceof Node && (constraint = (node = (Node)view).getLayoutConstraint()) != null & featureClass.isInstance((Object)constraint)) {
            constraint.eSet(feature, value);
            return;
        }
        if (featureClass.isInstance((Object)view)) {
            view.eSet(feature, value);
            return;
        }
    }

    public static EObject resolveSemanticElement(View view) {
        TransactionalEditingDomain domain;
        EObject element = view.getElement();
        if (element != null && element.eIsProxy() && (domain = TransactionUtil.getEditingDomain((EObject)view)) != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)domain, (EObject)element);
        }
        return element;
    }

    public static EObject resolve(EObject object) {
        TransactionalEditingDomain domain;
        if (object != null && object.eIsProxy() && (domain = TransactionUtil.getEditingDomain((EObject)object)) != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)domain, (EObject)object);
        }
        return object;
    }

    public static String getSemanticElementClassId(View view) {
        EObject element = view.getElement();
        return element == null ? null : PackageUtil.getID((ENamedElement)EMFCoreUtil.getProxyClass((EObject)element));
    }

    public static List getSourceConnections(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__SOURCE_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        return view.getSourceEdges();
    }

    public static List getTargetConnections(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__TARGET_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        return view.getTargetEdges();
    }

    public static List getSourceConnectionsConnectingVisibleViews(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__SOURCE_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Edge> sourceConnections = new ArrayList<Edge>();
        for (Edge edge : view.getSourceEdges()) {
            View target = edge.getTarget();
            if (!edge.isVisible() || !ViewUtil.isVisible(target)) continue;
            sourceConnections.add(edge);
        }
        return sourceConnections;
    }

    private static boolean isVisible(View target) {
        if (target.isVisible()) {
            EObject parent = target.eContainer();
            if (parent instanceof View) {
                return ViewUtil.isVisible((View)parent);
            }
            return true;
        }
        return false;
    }

    public static List getTargetConnectionsConnectingVisibleViews(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__TARGET_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Edge> targteConnections = new ArrayList<Edge>();
        for (Edge edge : view.getTargetEdges()) {
            View source = edge.getSource();
            if (!edge.isVisible() || !ViewUtil.isVisible(source)) continue;
            targteConnections.add(edge);
        }
        return targteConnections;
    }

    public static String getSemanticEClassName(View view) {
        EObject eObject = view.getElement();
        if (eObject != null) {
            return PackageUtil.getID((ENamedElement)EMFCoreUtil.getProxyClass((EObject)eObject));
        }
        return "";
    }

    public static String getIdStr(View view) {
        String id = ((XMLResource)view.eResource()).getID((EObject)view);
        if (id != null) {
            return id;
        }
        return "";
    }

    public static void repositionChildAt(View container, View child, int newIndex) {
        ViewUtil.persistElement(child);
        if (child.eContainer() != container) {
            throw new IllegalArgumentException("child is not an existing child of the view");
        }
        if (newIndex == -1) {
            throw new IllegalArgumentException("append position is not allowed for reposition");
        }
        container.removeChild(child);
        container.insertChildAt(child, newIndex);
    }

    public static View getChildByIdStr(View view, String idStr) {
        for (View child : view.getChildren()) {
            if (!idStr.equals(((XMLResource)child.eResource()).getID((EObject)child))) continue;
            return child;
        }
        return null;
    }

    public static void setPropertyValue(View view, Object id, Object value) {
        EStructuralFeature feature;
        if (id instanceof String && (feature = (EStructuralFeature)PackageUtil.getElement((String)((String)id))) != null) {
            ViewUtil.setPropertyValue(view, feature, feature.getEContainingClass(), value);
            return;
        }
    }

    public static final Object getPropertyValue(View view, Object id) {
        EStructuralFeature feature;
        if (id instanceof String && (feature = (EStructuralFeature)PackageUtil.getElement((String)((String)id))) != null) {
            return ViewUtil.getPropertyValue(view, feature, feature.getEContainingClass());
        }
        return null;
    }

    public static View getViewContainer(EObject obj) {
        while (obj != null) {
            if (obj.eContainer() instanceof View) {
                return (View)obj.eContainer();
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static void getAllRelatedEdgesForView(View view, Set<Edge> allEdges) {
        allEdges.addAll(ViewUtil.getSourceConnections(view));
        allEdges.addAll(ViewUtil.getTargetConnections(view));
        for (Object obj : view.getChildren()) {
            if (!(obj instanceof View)) continue;
            ViewUtil.getAllRelatedEdgesForView((View)obj, allEdges);
        }
    }

    public static void getAllRelatedEdgesFromViews(List views, HashSet<Edge> allEdges) {
        for (Object obj : views) {
            if (!(obj instanceof View)) continue;
            ViewUtil.getAllRelatedEdgesForView((View)obj, allEdges);
        }
    }

    public static Set<Edge> getAllInnerEdges(View view) {
        HashSet<View> allViews = new HashSet<View>();
        HashSet<Edge> edges = new HashSet<Edge>();
        HashSet<Edge> edgesConnectingViews = new HashSet<Edge>();
        ViewUtil.getAllNestedViews(view, allViews);
        for (View v : allViews) {
            ViewUtil.getAllEdgesFromView(v, edges);
        }
        Stack<Edge> connectionsPath = new Stack<Edge>();
        while (!edges.isEmpty()) {
            Edge edge = (Edge)edges.iterator().next();
            edges.remove(edge);
            connectionsPath.add(edge);
            View target = edge.getTarget();
            while (edges.contains(target)) {
                Edge targetEdge = (Edge)target;
                edges.remove(targetEdge);
                connectionsPath.add(targetEdge);
                target = targetEdge.getTarget();
            }
            if (allViews.contains(target) || edgesConnectingViews.contains(target)) {
                edgesConnectingViews.addAll(connectionsPath);
            }
            connectionsPath.clear();
        }
        return edgesConnectingViews;
    }

    private static void getAllNestedViews(View view, Set<View> allViews) {
        for (View childView : view.getChildren()) {
            ViewUtil.getAllNestedViews(childView, allViews);
            allViews.add(childView);
        }
    }

    private static void getAllEdgesFromView(View view, Set<Edge> edges) {
        for (Edge e : view.getSourceEdges()) {
            ViewUtil.getAllEdgesFromView((View)e, edges);
            edges.add(e);
        }
    }
}

