/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.XpandAnalyzable;
import org.eclipse.gmf.internal.xpand.ast.XpandEvaluatable;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDefinition
extends SyntaxElement
implements XpandAnalyzable,
XpandEvaluatable {
    private final Identifier type;
    private final DeclaredParameter[] params;
    private final Statement[] body;
    private Template owner = null;

    public void setOwner(Template owner) {
        this.owner = owner;
    }

    public AbstractDefinition(int start, int end, int line, Identifier type, DeclaredParameter[] params, Statement[] body) {
        super(start, end, line);
        this.type = type;
        this.params = params;
        this.body = body;
    }

    public Identifier getType() {
        return this.type;
    }

    public Statement[] getBody() {
        return this.body;
    }

    public DeclaredParameter[] getParams() {
        return this.params;
    }

    public XpandResource getOwner() {
        return this.owner;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier thisType = ctx.getTypeForName(this.getType().getValue());
        if (thisType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Couldn't find " + this.getType().getValue(), this.getType()));
        }
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("this", thisType));
        int i = 0;
        while (i < this.getParams().length) {
            DeclaredParameter param = this.getParams()[i];
            EClassifier paramType = ctx.getTypeForName(param.getType().getValue());
            if (paramType == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Couldn't find " + param.getType().getValue(), param.getType()));
                paramType = EcorePackage.eINSTANCE.getEObject();
            }
            String name = param.getName().getValue();
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(name, paramType));
            ++i;
        }
        i = 0;
        while (i < this.getBody().length) {
            this.getBody()[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluate(XpandExecutionContext ctx) {
        ctx = (XpandExecutionContext)ctx.cloneWithResource(this.getOwner());
        int i = 0;
        while (i < this.getBody().length) {
            this.getBody()[i].evaluate(ctx);
            ++i;
        }
    }

    public String getTargetType() {
        return this.getType().getValue();
    }
}

