/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.parser;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lpg.lpgjavaruntime.LexParser;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.LpgLexStream;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.RuleAction;
import lpg.lpgjavaruntime.TokenStream;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.xtend.parser.XtendKWLexer;
import org.eclipse.gmf.internal.xpand.xtend.parser.XtendLexerprs;
import org.eclipse.gmf.internal.xpand.xtend.parser.XtendLexersym;
import org.eclipse.gmf.internal.xpand.xtend.parser.XtendParsersym;

public class XtendLexer
extends LpgLexStream
implements XtendParsersym,
XtendLexersym,
RuleAction {
    private static ParseTable prs = new XtendLexerprs();
    private PrsStream prsStream;
    private final LexParser lexParser = new LexParser((TokenStream)this, prs, (RuleAction)this);
    private final List<ParserException.ErrorLocationInfo> errors = new LinkedList<ParserException.ErrorLocationInfo>();
    private XtendKWLexer kwLexer;
    private static final int ECLIPSE_TAB_VALUE = 4;
    public static final int[] tokenKind = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100, 89, 98, 100, 90, 99, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 65, 75, 73, 95, 96, 91, 67, 74, 87, 88, 72, 85, 83, 86, 69, 71, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 68, 76, 84, 27, 70, 82, 92, 21, 22, 23, 24, 25, 26, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 80, 77, 81, 97, 44, 93, 13, 11, 14, 15, 16, 12, 28, 29, 30, 31, 32, 33, 34, 17, 35, 36, 37, 18, 38, 19, 20, 39, 40, 41, 42, 43, 78, 66, 79, 94, 103, 101};

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getFirstToken();
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    public XtendLexer(String filename, int tab) throws IOException {
        super(filename, tab);
    }

    public XtendLexer(char[] input_chars, String filename, int tab) {
        super(input_chars, filename, tab);
    }

    public XtendLexer(char[] input_chars, String filename) {
        this(input_chars, filename, 1);
    }

    public XtendLexer() {
    }

    public String[] orderedExportedSymbols() {
        return XtendParsersym.orderedTerminalSymbols;
    }

    public LexStream getLexStream() {
        return this;
    }

    public void lexer(PrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    public void lexer(Monitor monitor, PrsStream prsStream) {
        if (this.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.prsStream = prsStream;
        this.resetErrors();
        prsStream.makeToken(0, 0, 0);
        this.lexParser.parseCharacters(monitor);
        int i = this.getStreamIndex();
        prsStream.makeToken(i, i, 34);
        prsStream.setStreamLength(prsStream.getSize());
    }

    public ParserException.ErrorLocationInfo[] getErrors() {
        return this.errors.toArray(new ParserException.ErrorLocationInfo[this.errors.size()]);
    }

    private void resetErrors() {
        this.errors.clear();
    }

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        int leftTokenLine = this.getLine(leftToken);
        int leftTokenColumn = this.getColumn(leftToken);
        int rightTokenLine = this.getEndLine(rightToken);
        int rightTokenColumn = this.getEndColumn(rightToken);
        String msg = String.valueOf(tokenText) + errorMsgText[errorCode];
        this.errors.add(new ParserException.ErrorLocationInfo(msg, leftTokenLine, leftTokenColumn, rightTokenLine, rightTokenColumn));
        super.reportError(errorCode, locationInfo, leftToken, rightToken, tokenText);
    }

    public void reportError(int errorCode, String locationInfo, String tokenText) {
        try {
            Matcher m = Pattern.compile("[^:]+:(\\d+):(\\d+):(\\d+):(\\d+):.*").matcher(locationInfo);
            boolean t = m.matches();
            assert (t);
            int leftTokenLine = this.getLine(Integer.parseInt(m.group(1)));
            int leftTokenColumn = this.getColumn(Integer.parseInt(m.group(2)));
            int rightTokenLine = this.getEndLine(Integer.parseInt(m.group(3)));
            int rightTokenColumn = this.getEndColumn(Integer.parseInt(m.group(4)));
            String msg = String.valueOf(tokenText) + errorMsgText[errorCode];
            this.errors.add(new ParserException.ErrorLocationInfo(msg, leftTokenLine, leftTokenColumn, rightTokenLine, rightTokenColumn));
        }
        catch (Exception exception) {
            this.errors.add(new ParserException.ErrorLocationInfo(String.valueOf(tokenText) + errorMsgText[errorCode]));
        }
        super.reportError(errorCode, locationInfo, tokenText);
    }

    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    public XtendLexer(String filename) throws IOException {
        this(filename, 4);
        this.kwLexer = new XtendKWLexer(this.getInputChars(), 1);
    }

    public void initialize(char[] content, String filename) {
        super.initialize(content, filename);
        if (this.kwLexer == null) {
            this.kwLexer = new XtendKWLexer(this.getInputChars(), 1);
        } else {
            this.kwLexer.setInputChars(this.getInputChars());
        }
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.makeToken(startOffset, endOffset, kind);
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        super.getPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.makeToken(startOffset, endOffset, kwKind);
    }

    public final int getKind(int i) {
        int c;
        int n = c = i >= this.getStreamLength() ? 65535 : (int)this.getCharValue(i);
        return c < 128 ? tokenKind[c] : (c == 65535 ? 101 : 103);
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.checkForKeyWord();
                break;
            }
            case 2: {
                this.makeToken(7);
                break;
            }
            case 3: {
                this.makeToken(7);
                break;
            }
            case 4: {
                this.makeToken(17);
                break;
            }
            case 5: {
                this.makeToken(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1), 17);
                this.makeToken(this.getRhsFirstTokenIndex(2), this.getRhsLastTokenIndex(2), 30);
                this.makeToken(this.getRhsFirstTokenIndex(3), this.getRhsLastTokenIndex(3), 1);
                break;
            }
            case 6: {
                this.makeToken(18);
                break;
            }
            case 7: {
                this.makeToken(49);
                break;
            }
            case 8: {
                this.makeToken(23);
                break;
            }
            case 9: {
                this.makeToken(50);
                break;
            }
            case 10: {
                this.makeToken(51);
                break;
            }
            case 11: {
                this.makeToken(40);
                break;
            }
            case 12: {
                this.makeToken(41);
                break;
            }
            case 13: {
                this.makeToken(6);
                break;
            }
            case 14: {
                this.makeToken(2);
                break;
            }
            case 15: {
                this.makeToken(15);
                break;
            }
            case 16: {
                this.makeToken(47);
                break;
            }
            case 17: {
                this.makeToken(48);
                break;
            }
            case 18: {
                this.makeToken(43);
                break;
            }
            case 19: {
                this.makeToken(45);
                break;
            }
            case 20: {
                this.makeToken(46);
                break;
            }
            case 21: {
                this.makeToken(44);
                break;
            }
            case 22: {
                this.makeToken(32);
                break;
            }
            case 23: {
                this.makeToken(33);
                break;
            }
            case 24: {
                this.makeToken(16);
                break;
            }
            case 25: {
                this.makeToken(29);
                break;
            }
            case 26: {
                this.makeToken(39);
                break;
            }
            case 27: {
                this.makeToken(52);
                break;
            }
            case 28: {
                this.makeToken(31);
                break;
            }
            case 29: {
                this.makeToken(26);
                break;
            }
            case 30: {
                this.makeToken(28);
                break;
            }
            case 31: {
                this.makeToken(30);
                break;
            }
            case 32: {
                this.makeToken(42);
                break;
            }
            case 33: {
                this.makeToken(38);
                break;
            }
            case 34: {
                this.skipToken();
                break;
            }
            case 35: {
                this.skipToken();
                break;
            }
            case 36: {
                this.skipToken();
                break;
            }
            case 225: {
                this.makeToken(25);
                break;
            }
        }
    }
}

