/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.EditPart;

public class ElementToEditPartsMap {
    private Map map = new HashMap();

    public List findEditPartsForElement(String elementIdStr, Class editPartClass) {
        List allEPs = (List)this.map.get(elementIdStr);
        if (allEPs == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList specificEPs = new ArrayList();
        for (Object ep : allEPs) {
            if (!editPartClass.isInstance(ep)) continue;
            specificEPs.add(ep);
        }
        return specificEPs;
    }

    public void registerEditPartForElement(String elementIdStr, EditPart ep) {
        if (elementIdStr == null || ep == null) {
            return;
        }
        List epList = (List)this.map.get(elementIdStr);
        if (epList != null) {
            if (!epList.contains(ep)) {
                epList.add(ep);
            }
        } else {
            ArrayList<EditPart> newList = new ArrayList<EditPart>(1);
            newList.add(ep);
            this.map.put(elementIdStr, newList);
        }
    }

    public void unregisterEditPartForElement(String elementIdStr, EditPart ep) {
        if (elementIdStr == null || ep == null) {
            return;
        }
        List epList = (List)this.map.get(elementIdStr);
        if (epList != null && epList.contains(ep)) {
            epList.remove(ep);
            if (epList.isEmpty()) {
                this.map.remove(elementIdStr);
            }
        }
    }
}

