/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

public class RefreshEditPartCommand
extends AbstractCommand {
    private View notation;
    private EditPartViewer viewer;
    private boolean revalidate;

    public RefreshEditPartCommand(IGraphicalEditPart editPart, boolean revalidate) {
        super(null, null);
        this.revalidate = revalidate;
        this.notation = (View)editPart.getModel();
        this.viewer = editPart.getRoot().getViewer();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Map epRegistry = this.viewer.getEditPartRegistry();
        IGraphicalEditPart editPart = (IGraphicalEditPart)epRegistry.get(this.notation);
        if (editPart != null) {
            editPart.refresh();
            if (this.revalidate) {
                editPart.getFigure().invalidate();
                editPart.getFigure().validate();
            }
        } else {
            String eMsg = NLS.bind((String)DiagramUIMessages.RefreshEditPartCompartment_execute_failed_ERROR_, (Object)this.notation);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)eMsg);
        }
        this.notation = null;
        this.viewer = null;
        return CommandResult.newOKCommandResult();
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return CommandResult.newOKCommandResult();
    }
}

