/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.adapter.AbstractAdapter;
import org.eclipse.net4j.examples.mvc.adapter.AbstractRecordModelAdapter;
import org.eclipse.net4j.examples.mvc.aspect.IMetaDataAspect;
import org.eclipse.net4j.examples.mvc.aspect.IRecordModelAspect;
import org.eclipse.net4j.examples.mvc.util.IPair;
import org.eclipse.net4j.examples.mvc.util.NoTargetException;
import org.eclipse.net4j.examples.mvc.util.Pair;
import org.eclipse.net4j.examples.mvc.util.ReflectiveInvocationException;
import org.eclipse.net4j.examples.mvc.util.UnknownFieldException;
import org.eclipse.net4j.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveRecordModelAdapter
extends AbstractRecordModelAdapter<Object> {
    private static final Logger logger = Logger.getLogger(ReflectiveRecordModelAdapter.class);
    private static final Object[] NO_ARGS = new Object[0];
    private Map<String, Pair<Method, Method>> fields;
    private String[] cachedFieldNames;

    public ReflectiveRecordModelAdapter(Factory factory) {
        super(factory);
    }

    @Override
    public String[] getFieldNames() throws NoTargetException {
        if (this.fields == null) {
            throw new NoTargetException();
        }
        if (this.cachedFieldNames == null) {
            this.cachedFieldNames = this.fields.keySet().toArray(new String[this.fields.size()]);
        }
        return this.cachedFieldNames;
    }

    @Override
    public Class getFieldType(String fieldName) {
        return this.getPair(fieldName).getFirst().getReturnType();
    }

    @Override
    public Object[] getMetaDataKeys() {
        Annotation[] data = this.getTarget().getClass().getAnnotations();
        Object[] result = new Object[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = data[i].annotationType();
            ++i;
        }
        return result;
    }

    @Override
    public Object getMetaData(Object key) {
        return this.getTarget().getClass().getAnnotation((Class)key);
    }

    @Override
    public Object getValue(String fieldName) {
        Object result;
        Method getter = this.getPair(fieldName).getFirst();
        try {
            result = getter.invoke(this.getTarget(), NO_ARGS);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception exception) {
            throw new ReflectiveInvocationException(getter);
        }
        if (result instanceof List) {
            result = new ListWrapper(fieldName, (List)result);
        } else if (result instanceof Collection) {
            result = new CollectionWrapper(fieldName, (Collection)result);
        } else if (result instanceof Map) {
            result = new MapWrapper(fieldName, (Map)result);
        }
        return result;
    }

    @Override
    public void setValue(String fieldName, Object value) {
        Object oldValue = this.getValue(fieldName);
        Object newValue = this.onVerify(fieldName, value);
        if (newValue == oldValue) {
            return;
        }
        Method setter = this.getPair(fieldName).getSecond();
        try {
            setter.invoke(this.getTarget(), value);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception exception) {
            throw new ReflectiveInvocationException(setter);
        }
        this.onSet(fieldName, newValue, oldValue);
    }

    @Override
    protected void onRetarget() {
        this.cachedFieldNames = null;
        if (this.getTarget() == null) {
            this.fields = null;
        } else {
            this.initMetaData();
        }
    }

    private IPair<Method, Method> getPair(String fieldName) {
        if (this.fields == null) {
            throw new NoTargetException();
        }
        Pair<Method, Method> pair = this.fields.get(fieldName);
        if (pair == null) {
            throw new UnknownFieldException(fieldName);
        }
        return pair;
    }

    private void initMetaData() {
        Object target = this.getTarget();
        if (target == null) {
            throw new NoTargetException();
        }
        this.fields = new HashMap<String, Pair<Method, Method>>();
        Method[] methodArray = target.getClass().getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Method method = methodArray[n];
            if (method.isAccessible()) {
                if (method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0) {
                    if (method.getName().startsWith("is")) {
                        this.initMethod("is", method, true);
                    } else if (method.getName().startsWith("get")) {
                        this.initMethod("get", method, true);
                    }
                } else if (method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1 && method.getName().startsWith("set")) {
                    this.initMethod("set", method, false);
                }
            }
            ++n;
        }
        for (Map.Entry<String, Pair<Method, Method>> entry : this.fields.entrySet()) {
            Class<?> setterType;
            Class<?> getterType;
            if (entry.getValue().getFirst() == null) {
                String name = entry.getKey();
                this.fields.remove(name);
                logger.warn((Object)("Dropped field " + name + " due to missing getter"));
                continue;
            }
            if (entry.getValue().getSecond() == null || (getterType = entry.getValue().getFirst().getReturnType()) == (setterType = entry.getValue().getSecond().getParameterTypes()[0])) continue;
            String name = entry.getKey();
            this.fields.remove(name);
            logger.warn((Object)("Dropped field " + name + " due to ambiguous getter/setter types"));
        }
    }

    private void initMethod(String prefix, Method method, boolean isGetter) {
        String name = StringHelper.firstToLower((String)method.getName().substring(prefix.length()));
        Pair<Method, Method> data = this.fields.get(name);
        if (data == null) {
            data = new Pair();
            this.fields.put(name, data);
        }
        if (isGetter) {
            data.setFirst(method);
        } else {
            data.setSecond(method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractAdapter.AbstractFactory<Object> {
        private static final Class[] ASPECTS = new Class[]{IMetaDataAspect.class, IRecordModelAspect.class};
        private static final Class[] ADAPTABLE_CLASSES = new Class[]{Object.class};

        @Override
        public IAdapter<Object> createAdapter() {
            return new ReflectiveRecordModelAdapter(this);
        }

        @Override
        public Class[] getAspects() {
            return ASPECTS;
        }

        @Override
        public Class[] getAdaptableClasses() {
            return ADAPTABLE_CLASSES;
        }
    }

    public class Wrapper {
        private String fieldName;

        public Wrapper(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    public class CollectionWrapper
    extends Wrapper
    implements Collection {
        private Collection data;

        public CollectionWrapper(String fieldName, Collection data) {
            super(fieldName);
            this.data = data;
        }

        public Collection getCollection() {
            return this.data;
        }

        public boolean add(Object item) {
            boolean changed = this.data.add(item);
            if (changed) {
                ReflectiveRecordModelAdapter.this.onAdd(this.getFieldName(), item);
            }
            return changed;
        }

        public boolean addAll(Collection c) {
            boolean changed = false;
            for (Object item : c) {
                changed |= this.add(item);
            }
            return changed;
        }

        public void clear() {
            Object[] tmp = this.data.toArray(new Object[this.data.size()]);
            this.data.clear();
            int i = 0;
            while (i < tmp.length) {
                ReflectiveRecordModelAdapter.this.onRemove(this.getFieldName(), tmp[i]);
                ++i;
            }
        }

        public boolean contains(Object item) {
            return this.data.contains(item);
        }

        public boolean containsAll(Collection c) {
            return this.data.containsAll(c);
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public Iterator iterator() {
            return this.data.iterator();
        }

        public boolean remove(Object item) {
            boolean changed = this.data.remove(item);
            if (changed) {
                ReflectiveRecordModelAdapter.this.onRemove(this.getFieldName(), item);
            }
            return changed;
        }

        public boolean removeAll(Collection c) {
            boolean changed = false;
            for (Object item : c) {
                changed |= this.remove(item);
            }
            return changed;
        }

        public boolean retainAll(Collection c) {
            boolean changed = false;
            for (Object item : this.data) {
                if (c.contains(item)) continue;
                this.remove(item);
                changed = true;
            }
            return changed;
        }

        public int size() {
            return this.data.size();
        }

        public Object[] toArray() {
            return this.data.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.data.toArray(a);
        }
    }

    public class ListWrapper
    extends CollectionWrapper
    implements List {
        public ListWrapper(String fieldName, List data) {
            super(fieldName, data);
        }

        public List getList() {
            return (List)this.getCollection();
        }

        public void add(int index, Object element) {
            this.getList().add(index, element);
        }

        public boolean addAll(int index, Collection c) {
            return this.getList().addAll(index, c);
        }

        public Object get(int index) {
            return this.getList().get(index);
        }

        public int indexOf(Object item) {
            return this.getList().indexOf(item);
        }

        public int lastIndexOf(Object item) {
            return this.getList().lastIndexOf(item);
        }

        public ListIterator listIterator() {
            return this.getList().listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.getList().listIterator(index);
        }

        public Object remove(int index) {
            return this.getList().remove(index);
        }

        public Object set(int index, Object element) {
            return this.getList().set(index, element);
        }

        public List subList(int fromIndex, int toIndex) {
            return this.getList().subList(fromIndex, toIndex);
        }
    }

    public class MapWrapper
    extends Wrapper
    implements Map {
        private Map data;

        public MapWrapper(String fieldName, Map data) {
            super(fieldName);
            this.data = data;
        }

        public Map getMap() {
            return this.data;
        }

        public void clear() {
            ArrayList tmp = new ArrayList();
            Iterator iterator = this.data.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                tmp.add(entry);
            }
            this.data.clear();
            for (Map.Entry entry : tmp) {
                ReflectiveRecordModelAdapter.this.onRemove(this.getFieldName(), entry.getKey(), entry.getValue());
            }
        }

        public boolean containsKey(Object key) {
            return this.data.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.data.containsValue(value);
        }

        public Set entrySet() {
            return this.data.entrySet();
        }

        public Object get(Object key) {
            return this.data.get(key);
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public Set keySet() {
            return this.data.keySet();
        }

        public Object put(Object key, Object value) {
            Object oldValue = this.data.put(key, value);
            if (oldValue != null) {
                ReflectiveRecordModelAdapter.this.onRemove(this.getFieldName(), key, oldValue);
            }
            if (value != null) {
                ReflectiveRecordModelAdapter.this.onAdd(this.getFieldName(), key, value);
            }
            return oldValue;
        }

        public void putAll(Map t) {
            this.data.putAll(t);
            Iterator iterator = t.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                ReflectiveRecordModelAdapter.this.onAdd(this.getFieldName(), entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object key) {
            Object oldValue = this.data.remove(key);
            if (oldValue != null) {
                ReflectiveRecordModelAdapter.this.onRemove(this.getFieldName(), key, oldValue);
            }
            return oldValue;
        }

        public int size() {
            return this.data.size();
        }

        public Collection values() {
            return this.data.values();
        }
    }
}

