/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.views;

import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.internal.ui.views.ItemJavaElementDescriptor;
import org.eclipse.emf.mint.internal.ui.views.UpdateViewerJob;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ItemJavaElementContentProvider
implements IStructuredContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private final AdapterFactory adapterFactory;
    private final UpdateViewerJob updateViewerJob;

    public ItemJavaElementContentProvider(AdapterFactory adapterFactory, UpdateViewerJob updateViewerJob) {
        this.adapterFactory = adapterFactory;
        this.updateViewerJob = updateViewerJob;
    }

    public Object[] getElements(Object inputElement) {
        Object adapter = this.adapterFactory.adapt(inputElement, IItemJavaElementSource.class);
        if (adapter instanceof IItemJavaElementSource) {
            List descriptors = ((IItemJavaElementSource)adapter).getJavaElementDescriptors(inputElement);
            Object[] elements = new Object[descriptors.size()];
            int i = 0;
            for (IItemJavaElementDescriptor desc : descriptors) {
                elements[i++] = new ItemJavaElementDescriptor(desc, inputElement);
            }
            return elements;
        }
        return NO_ELEMENTS;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != null) {
            Job.getJobManager().cancel((Object)this.updateViewerJob);
            this.updateViewerJob.cancel();
        }
    }

    public void dispose() {
    }
}

