/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelInputSnapshot;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.internal.AbstractTeamHandler;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.compare.util.EclipseModelUtils;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public final class ModelComparator {
    private static final Set<TeamHandlerDescriptor> CACHED_HANDLERS = new HashSet<TeamHandlerDescriptor>();
    private static final Map<CompareConfiguration, ModelComparator> INSTANCES = new HashMap<CompareConfiguration, ModelComparator>();
    private static final String TEAM_HANDLERS_EXTENSION_POINT = "org.eclipse.emf.compare.ui.internal.team.handler";
    protected ModelInputSnapshot comparisonResult;
    private ITypedElement ancestorElement;
    private Resource ancestorResource;
    private AbstractTeamHandler comparisonHandler;
    private ITypedElement leftElement;
    private boolean leftIsRemote;
    private Resource leftResource;
    private ITypedElement rightElement;
    private boolean rightIsRemote;
    private Resource rightResource;

    static {
        ModelComparator.parseExtensionMetaData();
    }

    private ModelComparator() {
    }

    public static ModelComparator getComparator(CompareConfiguration configuration) {
        if (!INSTANCES.containsKey(configuration)) {
            INSTANCES.put(configuration, new ModelComparator());
        }
        return INSTANCES.get(configuration);
    }

    public static void removeComparator(CompareConfiguration configuration) {
        INSTANCES.remove(configuration);
    }

    private static void parseExtensionMetaData() {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(TEAM_HANDLERS_EXTENSION_POINT).getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                TeamHandlerDescriptor descriptor = new TeamHandlerDescriptor(configElement);
                CACHED_HANDLERS.add(descriptor);
                ++n4;
            }
            ++n2;
        }
    }

    public ModelInputSnapshot compare(CompareConfiguration configuration) {
        if (this.comparisonResult == null) {
            this.comparisonResult = DiffFactory.eINSTANCE.createModelInputSnapshot();
            Date start = Calendar.getInstance().getTime();
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException {
                        EMFCompareMap options = new EMFCompareMap();
                        options.put("match.progress.monitor", monitor);
                        MatchModel match = ModelComparator.this.getAncestorResource() == null ? MatchService.doResourceMatch((Resource)ModelComparator.this.getLeftResource(), (Resource)ModelComparator.this.getRightResource(), (Map)options) : MatchService.doResourceMatch((Resource)ModelComparator.this.getLeftResource(), (Resource)ModelComparator.this.getRightResource(), (Resource)ModelComparator.this.getAncestorResource(), (Map)options);
                        DiffModel diff = DiffService.doDiff((MatchModel)match, (ModelComparator.this.getAncestorResource() != null ? 1 : 0) != 0);
                        ModelComparator.this.comparisonResult.setDate(Calendar.getInstance().getTime());
                        ModelComparator.this.comparisonResult.setDiff(diff);
                        ModelComparator.this.comparisonResult.setMatch(match);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                this.comparisonResult.setDate(Calendar.getInstance().getTime());
                this.comparisonResult.setDiff(DiffFactory.eINSTANCE.createDiffModel());
                this.comparisonResult.setMatch(MatchFactory.eINSTANCE.createMatchModel());
            }
            catch (InvocationTargetException e) {
                EMFComparePlugin.log((Exception)e, (boolean)true);
            }
            Date end = Calendar.getInstance().getTime();
            configuration.setProperty("comparison.time", (Object)(end.getTime() - start.getTime()));
            configuration.setLeftEditable(!this.isLeftRemote());
            configuration.setRightEditable(!this.isRightRemote());
            if (this.isLeftRemote()) {
                configuration.setLeftLabel(EMFCompareUIMessages.getString("comparison.label.remoteResource"));
                configuration.setRightLabel(EMFCompareUIMessages.getString("comparison.label.localResource"));
            }
        }
        return this.comparisonResult;
    }

    public Resource getAncestorResource() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.getAncestorResource();
        }
        return this.ancestorResource;
    }

    public ModelInputSnapshot getComparisonResult() {
        return this.comparisonResult;
    }

    public Resource getLeftResource() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.getLeftResource();
        }
        return this.leftResource;
    }

    public Resource getRightResource() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.getRightResource();
        }
        return this.rightResource;
    }

    public boolean isLeftRemote() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.isLeftRemote();
        }
        return this.leftIsRemote;
    }

    public boolean isRightRemote() {
        if (this.comparisonHandler != null) {
            return this.comparisonHandler.isRightRemote();
        }
        return this.rightIsRemote;
    }

    public boolean loadResources(ICompareInput input) {
        boolean result = false;
        if (this.ancestorElement != input.getAncestor() || this.leftElement != input.getLeft() || this.rightElement != input.getRight()) {
            this.clear();
            this.leftElement = input.getLeft();
            this.rightElement = input.getRight();
            this.ancestorElement = input.getAncestor();
            try {
                result = this.handleLocalResources(this.leftElement, this.rightElement, this.ancestorElement);
                if (!result) {
                    Iterator<TeamHandlerDescriptor> handlerDescriptorIterator = CACHED_HANDLERS.iterator();
                    while (handlerDescriptorIterator.hasNext()) {
                        AbstractTeamHandler handler = handlerDescriptorIterator.next().getHandlerInstance();
                        if (!(result |= handler.loadResources(input))) continue;
                        this.comparisonHandler = handler;
                        break;
                    }
                }
                if (!result) {
                    result |= this.handleGenericResources(this.leftElement, this.rightElement, this.ancestorElement);
                }
                result = true;
            }
            catch (IOException e) {
                EMFComparePlugin.log((Exception)e, (boolean)true);
            }
            catch (CoreException e) {
                EMFComparePlugin.log((IStatus)e.getStatus());
            }
        } else {
            result = true;
        }
        return result;
    }

    private void clear() {
        this.clearResourceSet(this.leftResource, this.rightResource, this.ancestorResource);
        this.leftResource = null;
        this.rightResource = null;
        this.ancestorResource = null;
        this.comparisonResult = null;
        this.comparisonHandler = null;
    }

    private void clearResourceSet(Resource ... resource) {
        int i = 0;
        while (i < resource.length) {
            if (resource[i] != null) {
                ResourceSet resourceSet = resource[i].getResourceSet();
                Iterator resourcesIterator = resourceSet.getResources().iterator();
                while (resourcesIterator.hasNext()) {
                    ((Resource)resourcesIterator.next()).unload();
                }
                resourceSet.getResources().clear();
            }
            ++i;
        }
    }

    private boolean handleGenericResources(ITypedElement left, ITypedElement right, ITypedElement ancestor) throws IOException, CoreException {
        if (left instanceof ResourceNode && right instanceof IStreamContentAccessor) {
            if (((ResourceNode)left).getResource().isAccessible()) {
                this.rightResource = EclipseModelUtils.load((IPath)((ResourceNode)left).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            } else {
                this.rightResource = ModelUtils.createResource((URI)URI.createPlatformResourceURI((String)((ResourceNode)left).getResource().getFullPath().toOSString(), (boolean)true));
                this.rightIsRemote = true;
            }
            try {
                this.leftResource = ModelUtils.load((InputStream)((IStreamContentAccessor)right).getContents(), (String)right.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            }
            catch (IOException iOException) {
                this.leftResource = ModelUtils.createResource((URI)URI.createURI((String)right.getName()));
                this.rightIsRemote = true;
            }
            this.leftIsRemote = true;
            if (ancestor != null) {
                try {
                    this.ancestorResource = ModelUtils.load((InputStream)((IStreamContentAccessor)ancestor).getContents(), (String)ancestor.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
                }
                catch (IOException iOException) {
                    this.ancestorResource = ModelUtils.createResource((URI)URI.createURI((String)ancestor.getName()));
                }
            }
            return true;
        }
        boolean result = false;
        if (left instanceof IStreamContentAccessor && right instanceof IStreamContentAccessor) {
            this.rightResource = ModelUtils.load((InputStream)((IStreamContentAccessor)left).getContents(), (String)left.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            this.leftResource = ModelUtils.load((InputStream)((IStreamContentAccessor)right).getContents(), (String)right.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            this.rightIsRemote = true;
            this.leftIsRemote = true;
            if (ancestor != null) {
                this.ancestorResource = ModelUtils.load((InputStream)((IStreamContentAccessor)ancestor).getContents(), (String)ancestor.getName(), (ResourceSet)new ResourceSetImpl()).eResource();
            }
            result = true;
        }
        return result;
    }

    private boolean handleLocalResources(ITypedElement left, ITypedElement right, ITypedElement ancestor) throws IOException {
        if (left instanceof ResourceNode && right instanceof ResourceNode) {
            this.leftResource = EclipseModelUtils.load((IPath)((ResourceNode)left).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            this.rightResource = EclipseModelUtils.load((IPath)((ResourceNode)right).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            if (ancestor != null) {
                this.ancestorResource = EclipseModelUtils.load((IPath)((ResourceNode)ancestor).getResource().getFullPath(), (ResourceSet)new ResourceSetImpl()).eResource();
            }
            return true;
        }
        return false;
    }

    private static final class TeamHandlerDescriptor {
        private static final String ATTRIBUTE_HANDLER_CLASS = "class";
        private final IConfigurationElement element;
        private AbstractTeamHandler handler;

        public TeamHandlerDescriptor(IConfigurationElement configuration) {
            this.element = configuration;
        }

        public AbstractTeamHandler getHandlerInstance() {
            if (this.handler == null) {
                try {
                    this.handler = (AbstractTeamHandler)this.element.createExecutableExtension(ATTRIBUTE_HANDLER_CLASS);
                }
                catch (CoreException e) {
                    EMFComparePlugin.log((Exception)((Object)e), (boolean)true);
                }
            }
            return this.handler;
        }
    }
}

