/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementDescriptor2;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.internal.ui.actions.CleanGeneratedRefactoringDescriptor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.DeleteDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanGeneratedRefactoring
extends Refactoring {
    private final Object[] elements;
    private Refactoring delegate;

    public CleanGeneratedRefactoring(Object[] elements) {
        this.elements = elements;
    }

    public String getName() {
        return "Clean Generated Artifacts";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.delegate == null) {
            this.delegate = this.createDelegate(status, monitor);
        }
        status.merge(this.delegate.checkInitialConditions(monitor));
        return status;
    }

    private Refactoring createDelegate(RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Properties args = new Properties();
        LinkedHashSet<IJavaElement> elements = new LinkedHashSet<IJavaElement>();
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        UniqueEList.FastCompare objects = new UniqueEList.FastCompare();
        Object[] objectArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Object root = AdapterFactoryEditingDomain.unwrap((Object)element);
            if (root instanceof EObject) {
                objects.add((Object)((EObject)root));
                TreeIterator i = ((EObject)root).eAllContents();
                while (i.hasNext()) {
                    objects.add((Object)((EObject)i.next()));
                }
            }
            ++n2;
        }
        monitor.beginTask("Collecting generated artifacts", objects.size());
        try {
            for (Object element : objects) {
                Object adapter = adapterFactory.adapt(element, IItemJavaElementSource.class);
                if (adapter instanceof IItemJavaElementSource) {
                    IItemJavaElementSource src = (IItemJavaElementSource)adapter;
                    List descs = src.getJavaElementDescriptors(element);
                    block13: for (IItemJavaElementDescriptor desc : descs) {
                        if (!(desc instanceof IItemJavaElementDescriptor2) || !((IItemJavaElementDescriptor2)desc).isElementOwner(element)) continue;
                        IJavaElement je = null;
                        IResource resource = null;
                        switch (desc.getKind(element)) {
                            case JAVA_ELEMENT: {
                                je = desc.getJavaElement(element);
                                monitor.worked(1);
                                break;
                            }
                            case JAVA_TYPE_REFERENCE: {
                                IJavaTypeReference ref = desc.getJavaTypeReference(element);
                                try {
                                    je = ref.getContext().findType(ref.getTypeName(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    break;
                                }
                                catch (JavaModelException javaModelException) {
                                    continue block13;
                                }
                            }
                            case NON_JAVA_RESOURCE: {
                                Object obj = desc.getNonJavaElement(element);
                                if (obj instanceof IResource) {
                                    resource = (IResource)obj;
                                } else if (obj instanceof IAdaptable) {
                                    resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class);
                                }
                                monitor.worked(1);
                                break;
                            }
                            default: {
                                monitor.worked(1);
                            }
                        }
                        if (je != null && je.exists() && !je.isReadOnly() && !this.isIncluded(elements, je)) {
                            elements.add(je);
                        }
                        if (resource == null || !resource.exists()) continue;
                        resources.add(resource);
                    }
                    continue;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
            adapterFactory.dispose();
        }
        int i = 0;
        for (IResource resource : resources) {
            args.setProperty("element" + ++i, resource.getFullPath().toPortableString());
            args.setProperty("name" + i, resource.getName());
        }
        for (IJavaElement je : elements) {
            args.setProperty("element" + ++i, je.getHandleIdentifier());
            args.setProperty("name" + i, je.getElementName());
        }
        args.setProperty("elements", String.valueOf(elements.size()));
        args.setProperty("resources", String.valueOf(resources.size()));
        args.setProperty("accessors", Boolean.toString(false));
        args.setProperty("subPackages", Boolean.toString(false));
        DeleteDescriptor desc = new DeleteDescriptor(null, "Delete Generated Artifacts", null, (Map)args, 6);
        return desc.createRefactoring(status);
    }

    private boolean isIncluded(Collection<IJavaElement> elements, IJavaElement je) {
        for (IJavaElement element : elements) {
            IJavaElement parent = je;
            do {
                if (!parent.equals(element)) continue;
                return true;
            } while ((parent = parent.getParent()) != null);
        }
        return false;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return this.delegate.checkFinalConditions(monitor);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        CleanGeneratedChange change = new CleanGeneratedChange();
        change.add(this.delegate.createChange(monitor));
        return change;
    }

    private class CleanGeneratedChange
    extends CompositeChange {
        private ChangeDescriptor descriptor;

        public CleanGeneratedChange() {
            super("Clean Generated Artifacts");
            this.markAsSynthetic();
        }

        public ChangeDescriptor getDescriptor() {
            if (this.descriptor == null) {
                this.descriptor = new RefactoringChangeDescriptor((RefactoringDescriptor)new CleanGeneratedRefactoringDescriptor(CleanGeneratedRefactoring.this.elements));
            }
            return this.descriptor;
        }
    }
}

