/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.actions;

import configuration.Configuration;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleEditPart;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.VariabilityModelHelper;
import org.eclipse.emf.henshin.variability.configuration.ui.providers.ConfigurationProvider;
import org.eclipse.emf.henshin.variability.ui.views.VariabilityView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class FindPresenceConditionsAction
implements IActionDelegate {
    public static final String ID = "org.eclipse.emf.henshin.variability.ui.FindPresenceConditionsActionID";
    private RuleEditPart selectedRuleEditPart;

    public void run(IAction action) {
        if (this.selectedRuleEditPart != null) {
            VariabilityView variabilityView = this.openAndGetVariabilityPointsView();
            variabilityView.showBusy(true);
            Rule rule = VariabilityModelHelper.getRuleForEditPart(this.selectedRuleEditPart);
            ConfigurationProvider configProvider = ConfigurationProvider.getInstance();
            Configuration config = configProvider.getConfiguration(rule);
            variabilityView.setSelectedRuleEditPart(this.selectedRuleEditPart);
            variabilityView.setContent(config);
            variabilityView.showBusy(false);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.selectedRuleEditPart = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof RuleEditPart) {
            this.selectedRuleEditPart = (RuleEditPart)structuredSelection.getFirstElement();
        }
    }

    private VariabilityView openAndGetVariabilityPointsView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.emf.henshin.variability.ui.views.VariabilityView");
            return (VariabilityView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.emf.henshin.variability.ui.views.VariabilityView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }
}

