/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.net4j.util.io.ExtendedIOUtil;

public interface ExtendedDataInput
extends DataInput {
    public byte[] readByteArray() throws IOException;

    public Object readObject() throws IOException;

    public Object readObject(ClassLoader var1) throws IOException;

    public Object readObject(ExtendedIOUtil.ClassResolver var1) throws IOException;

    public String readString() throws IOException;

    public static class Delegating
    implements ExtendedDataInput {
        private ExtendedDataInput delegate;

        public Delegating(ExtendedDataInput delegate) {
            this.delegate = delegate;
        }

        public ExtendedDataInput getDelegate() {
            return this.delegate;
        }

        public boolean readBoolean() throws IOException {
            return this.delegate.readBoolean();
        }

        public byte readByte() throws IOException {
            return this.delegate.readByte();
        }

        public byte[] readByteArray() throws IOException {
            return this.delegate.readByteArray();
        }

        public char readChar() throws IOException {
            return this.delegate.readChar();
        }

        public double readDouble() throws IOException {
            return this.delegate.readDouble();
        }

        public float readFloat() throws IOException {
            return this.delegate.readFloat();
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            this.delegate.readFully(b, off, len);
        }

        public void readFully(byte[] b) throws IOException {
            this.delegate.readFully(b);
        }

        public int readInt() throws IOException {
            return this.delegate.readInt();
        }

        public String readLine() throws IOException {
            return this.delegate.readLine();
        }

        public long readLong() throws IOException {
            return this.delegate.readLong();
        }

        public Object readObject() throws IOException {
            return this.delegate.readObject();
        }

        public Object readObject(ClassLoader classLoader) throws IOException {
            return this.delegate.readObject(classLoader);
        }

        public Object readObject(ExtendedIOUtil.ClassResolver classResolver) throws IOException {
            return this.delegate.readObject(classResolver);
        }

        public short readShort() throws IOException {
            return this.delegate.readShort();
        }

        public String readString() throws IOException {
            return this.delegate.readString();
        }

        public int readUnsignedByte() throws IOException {
            return this.delegate.readUnsignedByte();
        }

        public int readUnsignedShort() throws IOException {
            return this.delegate.readUnsignedShort();
        }

        public String readUTF() throws IOException {
            return this.delegate.readUTF();
        }

        public int skipBytes(int n) throws IOException {
            return this.delegate.skipBytes(n);
        }
    }

    @Deprecated
    public static class Stream
    extends InputStream {
        private ExtendedDataInput delegate;

        public Stream(ExtendedDataInput delegate) {
            this.delegate = delegate;
        }

        public ExtendedDataInput getDelegate() {
            return this.delegate;
        }

        public int read() throws IOException {
            try {
                return this.delegate.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                return -1;
            }
        }
    }
}

