/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashBag<T>
implements Set<T> {
    private Map<T, Counter> map;

    public HashBag() {
        this.map = new HashMap<T, Counter>();
    }

    public HashBag(int initialCapacity, float loadFactor) {
        this.map = new HashMap<T, Counter>(initialCapacity, loadFactor);
    }

    public HashBag(int initialCapacity) {
        this.map = new HashMap<T, Counter>(initialCapacity);
    }

    public HashBag(Map<? extends T, ? extends Counter> m) {
        this.map = new HashMap<T, Counter>(m);
    }

    @Override
    public boolean add(T o) {
        Counter counter = this.map.get(o);
        if (counter == null) {
            counter = new Counter();
            this.map.put(o, counter);
            return true;
        }
        counter.incValue();
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        Counter counter = this.map.get(o);
        if (counter == null) {
            return false;
        }
        if (counter.decValue() == 0) {
            this.map.remove(o);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object object : c) {
            if (!this.remove(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    private static final class Counter {
        private int value = 1;

        public int getValue() {
            return this.value;
        }

        public int incValue() {
            return ++this.value;
        }

        public int decValue() {
            return --this.value;
        }
    }
}

