/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.ConnectorState;
import org.eclipse.net4j.internal.tcp.ControlChannel;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.internal.tcp.messages.Messages;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.tcp.ITCPActiveSelectorListener;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.ITCPNegotiationContext;
import org.eclipse.net4j.tcp.ITCPSelector;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.NegotiationContext;
import org.eclipse.net4j.util.security.NegotiationException;
import org.eclipse.spi.net4j.Connector;
import org.eclipse.spi.net4j.InternalChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCPConnector
extends Connector
implements ITCPConnector,
ITCPActiveSelectorListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TCPConnector.class);
    private SocketChannel socketChannel;
    private ITCPSelector selector;
    @ReflectUtil.ExcludeFromDump
    private SelectionKey selectionKey;
    private BlockingQueue<InternalChannel> writeQueue = new LinkedBlockingQueue<InternalChannel>();
    private IBuffer inputBuffer;
    private ControlChannel controlChannel;
    private String host;
    private int port;

    @Override
    public String getHost() {
        return this.host;
    }

    void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public ITCPSelector getSelector() {
        return this.selector;
    }

    public void setSelector(ITCPSelector selector) {
        this.selector = selector;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public String getURL() {
        return "tcp://" + this.host + ":" + this.port;
    }

    @Override
    public void handleRegistration(ITCPSelector selector, SocketChannel socketChannel) {
        try {
            int interest = this.isClient() ? 8 : 1;
            this.selectionKey = socketChannel.register(selector.getSocketSelector(), interest, this);
            if (this.isServer()) {
                this.leaveConnecting();
            }
        }
        catch (Exception exception) {
            this.deferredActivate(false);
        }
    }

    @Override
    public void handleConnect(ITCPSelector selector, SocketChannel channel) {
        try {
            if (channel.finishConnect()) {
                selector.orderConnectInterest(this.selectionKey, true, false);
                selector.orderReadInterest(this.selectionKey, true, true);
                this.leaveConnecting();
            }
        }
        catch (Exception exception) {
            this.deferredActivate(false);
        }
    }

    @Override
    public void handleRead(ITCPSelector selector, SocketChannel socketChannel) {
        block10: {
            try {
                ByteBuffer byteBuffer;
                if (this.inputBuffer == null) {
                    this.inputBuffer = this.getConfig().getBufferProvider().provideBuffer();
                }
                if ((byteBuffer = this.inputBuffer.startGetting(socketChannel)) != null) {
                    ControlChannel channel;
                    short channelID = this.inputBuffer.getChannelID();
                    ControlChannel controlChannel = channel = channelID == 0 ? this.controlChannel : this.getChannel(channelID);
                    if (channel != null) {
                        channel.handleBufferFromMultiplexer(this.inputBuffer);
                    } else {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("Discarding buffer from unknown channel");
                        }
                        this.inputBuffer.release();
                    }
                    this.inputBuffer = null;
                }
            }
            catch (NegotiationException ex) {
                OM.LOG.error((Throwable)ex);
                this.setNegotiationException(ex);
                this.deactivate();
            }
            catch (ClosedChannelException closedChannelException) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Socket channel closed: " + socketChannel);
                }
                this.deactivate();
            }
            catch (Exception ex) {
                if (!this.isActive()) break block10;
                OM.LOG.error((Throwable)ex);
                this.deactivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexChannel(InternalChannel channel) {
        BlockingQueue<InternalChannel> blockingQueue = this.writeQueue;
        synchronized (blockingQueue) {
            boolean firstChannel = this.writeQueue.isEmpty();
            try {
                this.writeQueue.put(channel);
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
            if (firstChannel) {
                this.checkSelectionKey();
                this.selector.orderWriteInterest(this.selectionKey, this.isClient(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleWrite(ITCPSelector selector, SocketChannel socketChannel) {
        block10: {
            try {
                BlockingQueue<InternalChannel> blockingQueue = this.writeQueue;
                synchronized (blockingQueue) {
                    IBuffer buffer;
                    Queue bufferQueue;
                    InternalChannel channel = (InternalChannel)this.writeQueue.peek();
                    if (channel != null && (bufferQueue = channel.getSendQueue()) != null && (buffer = (IBuffer)bufferQueue.peek()) != null && buffer.write(socketChannel)) {
                        this.writeQueue.poll();
                        bufferQueue.poll();
                        buffer.release();
                    }
                    if (this.writeQueue.isEmpty()) {
                        this.checkSelectionKey();
                        selector.orderWriteInterest(this.selectionKey, this.isClient(), false);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClosedChannelException closedChannelException) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Socket channel closed: " + socketChannel);
                }
                this.deactivate();
            }
            catch (Exception ex) {
                if (!this.isActive()) break block10;
                OM.LOG.error((Throwable)ex);
                this.deactivate();
            }
        }
    }

    protected void registerChannelWithPeer(short channelID, long timeout, IProtocol<?> protocol) throws ChannelException {
        try {
            if (!this.controlChannel.registerChannel(channelID, timeout, protocol)) {
                throw new ChannelException("Failed to register channel with peer");
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectorException((Throwable)ex);
        }
    }

    protected void deregisterChannelFromPeer(InternalChannel channel) throws ChannelException {
        if (channel != null && channel.getClass() != ControlChannel.class && this.controlChannel != null && this.isConnected()) {
            this.controlChannel.deregisterChannel(channel.getID());
        }
    }

    protected INegotiationContext createNegotiationContext() {
        return new TCPNegotiationContext();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.socketChannel == null) {
            throw new IllegalStateException("socketChannel == null");
        }
        if (this.selector == null) {
            throw new IllegalStateException("selector == null");
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.controlChannel = new ControlChannel(this);
        this.controlChannel.activate();
        this.selector.orderRegistration(this.socketChannel, this.isClient(), this);
    }

    protected void doDeactivate() throws Exception {
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
            this.selectionKey = null;
        }
        LifecycleUtil.deactivate((Object)((Object)this.controlChannel));
        this.controlChannel = null;
        IOUtil.closeSilent((Closeable)this.socketChannel);
        this.socketChannel = null;
        super.doDeactivate();
    }

    private void checkSelectionKey() {
        if (this.selectionKey == null) {
            throw new IllegalStateException("No selection key for connector " + this);
        }
    }

    private final class TCPNegotiationContext
    extends NegotiationContext
    implements ITCPNegotiationContext {
        private IBuffer buffer;
        private boolean failed;

        public TCPConnector getConnector() {
            return TCPConnector.this;
        }

        public void setUserID(String userID) {
            TCPConnector.this.setUserID(userID);
        }

        public ByteBuffer getBuffer() {
            this.buffer = TCPConnector.this.getConfig().getBufferProvider().provideBuffer();
            ByteBuffer byteBuffer = this.buffer.startPutting((short)0);
            byteBuffer.put((byte)1);
            return byteBuffer;
        }

        public void transmitBuffer(ByteBuffer byteBuffer) {
            if (this.buffer.getByteBuffer() != byteBuffer) {
                throw new IllegalArgumentException("The passed buffer is not the last that was produced");
            }
            TCPConnector.this.controlChannel.sendBuffer(this.buffer);
            if (this.failed) {
                TCPConnector.this.deactivate();
            }
        }

        public void setFinished(boolean success) {
            if (success) {
                TCPConnector.this.setState(ConnectorState.CONNECTED);
            } else {
                OM.LOG.error(String.valueOf(Messages.getString("TCPConnector.6")) + TCPConnector.this);
                this.failed = true;
            }
            super.setFinished(success);
        }

        protected void finalize() throws Throwable {
            if (this.buffer != null) {
                this.buffer.release();
                this.buffer = null;
            }
        }
    }
}

