/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.teneo.eclipselink.IndirectEContainer;
import org.eclipse.emf.teneo.eclipselink.resource.EclipseLinkResource;
import org.eclipse.emf.teneo.eclipselink.resource.EclipseLinkResourceUtil;
import org.eclipse.persistence.jpa.osgi.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkResourceImpl
extends ResourceImpl
implements EclipseLinkResource {
    private static Map<String, EntityManagerFactoryInstance> persistenceUnitNameToEntityManagerFactoryInstanceMap = new HashMap<String, EntityManagerFactoryInstance>();
    private String persistenceUnitName;
    private String contentsQuery;
    private EntityManager entityManager;
    private boolean readingContentsFromDatabase;
    private List<EObject> eObjectsToBeRemovedFromDatabase = new ArrayList<EObject>();

    public EclipseLinkResourceImpl(URI uri) {
        super(uri);
        if (!EclipseLinkResourceUtil.isEclipseLinkURI(uri)) {
            String msg = "Argument for parameter 'uri' must contain a 'eclipselink:' scheme.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        if (uri.segmentCount() != 1) {
            String msg = "Argument for parameter 'uri' must contain one segment representing the name of a database session.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        if (!uri.hasQuery()) {
            String msg = "Argument for parameter 'uri' must contain a query string representing an alias of a query for the contents of this resource.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        this.persistenceUnitName = uri.segments()[0];
        this.contentsQuery = uri.query();
        this.initDefaultOptions();
    }

    public EclipseLinkResourceImpl(String persistenceUnitName, String contentsQueryAlias) {
        this.uri = EclipseLinkResourceUtil.createEclipseLinkURI(persistenceUnitName, contentsQueryAlias);
        this.persistenceUnitName = persistenceUnitName;
        this.contentsQuery = contentsQueryAlias;
        this.initDefaultOptions();
    }

    public Map<Object, Object> getDefaultSaveOptions() {
        return this.defaultSaveOptions;
    }

    public Map<Object, Object> getDefaultLoadOptions() {
        return this.defaultLoadOptions;
    }

    public void setURI(URI uri) {
    }

    public EList<EObject> getContents() {
        if (this.contents == null) {
            this.contents = new DatabaseContentsEList();
        }
        return this.contents;
    }

    public String getURIFragment(EObject eObject) {
        String result;
        String id = EcoreUtil.getID((EObject)eObject);
        if (id != null) {
            EAttribute eIDAttribute = eObject.eClass().getEIDAttribute();
            result = String.valueOf(eObject.eClass().getName()) + "|" + eIDAttribute.getName() + "='" + id + "'";
        } else {
            result = super.getURIFragment(eObject);
        }
        return result;
    }

    protected EObject getEObjectByID(String fragment) {
        try {
            EObject result = null;
            String[] idComponents = fragment.split("\\||='|'");
            boolean valid = true;
            if (idComponents.length < 3) {
                valid = false;
            } else {
                int i = 0;
                while (i < 3) {
                    if (idComponents[i] == null || idComponents[i].trim().length() == 0) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!valid) {
                String msg = "Invalid object id (expected format: ownerTypeName|idAttributeName='id').";
                throw new WrappedException((Exception)new IllegalArgumentException(msg));
            }
            String queryString = "select o from " + idComponents[0] + " o where o." + idComponents[1] + " = '" + idComponents[2] + "'";
            List eObjects = this.entityManager.createQuery(queryString).getResultList();
            if (eObjects.size() > 0) {
                result = (EObject)eObjects.get(0);
            }
            return result;
        }
        catch (RuntimeException exception) {
            throw new WrappedException((Exception)exception);
        }
    }

    public void attached(EObject eObject) {
        if (this.eObjectsToBeRemovedFromDatabase.contains(eObject)) {
            this.eObjectsToBeRemovedFromDatabase.remove(eObject);
            return;
        }
        if (!this.readingContentsFromDatabase) {
            EclipseLinkContentTreeIterator allContents = new EclipseLinkContentTreeIterator(Collections.singletonList(eObject), true);
            while (allContents.hasNext()) {
                EObject eContainedObject = (EObject)allContents.next();
                this.entityManager.persist((Object)eContainedObject);
            }
        }
    }

    public void detached(EObject eObject) {
        this.eObjectsToBeRemovedFromDatabase.add(eObject);
    }

    public final void save(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            String msg = "Cannot save a resource which is not loaded.";
            throw new WrappedException((Exception)new IllegalStateException(msg));
        }
        this.save(null, options);
    }

    public final void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            try {
                this.load(null, options);
            }
            catch (WrappedException exception) {
                this.setLoaded(false);
                throw exception;
            }
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (options == null) {
            String msg = "Argument for parameter 'options' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        try {
            if (this.eObjectsToBeRemovedFromDatabase.size() > 0) {
                for (EObject eObject : this.eObjectsToBeRemovedFromDatabase) {
                    EclipseLinkContentTreeIterator allContents = new EclipseLinkContentTreeIterator(Collections.singletonList(eObject), true);
                    while (allContents.hasNext()) {
                        EObject eContainedObject = (EObject)allContents.next();
                        this.entityManager.remove((Object)eContainedObject);
                    }
                }
                this.eObjectsToBeRemovedFromDatabase.clear();
            }
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
        }
        catch (RuntimeException exception) {
            throw new WrappedException((Exception)exception);
        }
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.openDatabase(options);
        this.readContentsFromDatabase(options);
    }

    protected void doUnload() {
        EclipseLinkContentTreeIterator allContents = new EclipseLinkContentTreeIterator(new ArrayList<EObject>((Collection<EObject>)this.getContents()), false);
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        while (allContents.hasNext()) {
            InternalEObject eObject = (InternalEObject)allContents.next();
            this.unloaded(eObject);
        }
        this.closeDatabase();
    }

    public final boolean isTrackingModification() {
        return false;
    }

    public final void setTrackingModification(boolean isTrackingModification) {
    }

    public boolean isModified() {
        return false;
    }

    public void setModified(boolean isModified) {
    }

    protected void initDefaultOptions() {
        this.defaultSaveOptions = new HashMap();
        this.defaultLoadOptions = new HashMap();
        this.defaultLoadOptions.put("eclipselink.logging.level", "FINE");
    }

    protected void openDatabase(Map<?, ?> options) {
        if (options == null) {
            String msg = "Argument for parameter 'options' must not be null.";
            throw new WrappedException((Exception)new IllegalArgumentException(msg));
        }
        try {
            EntityManagerFactoryInstance entityManagerFactoryInstance;
            if (!persistenceUnitNameToEntityManagerFactoryInstanceMap.containsKey(this.persistenceUnitName)) {
                if (!options.containsKey("eclipselink.classloader")) {
                    throw new RuntimeException("Persistence unit property 'PersistenceUnitProperties.CLASSLOADER' must be initialized with some classloader which has persistence unit named '" + this.persistenceUnitName + "' on its classpath.");
                }
                EntityManagerFactory entityManagerFactory = new PersistenceProvider().createEntityManagerFactory(this.persistenceUnitName, options);
                if (entityManagerFactory == null) {
                    throw new RuntimeException("Unable to create entity manager factory for persistence unit named '" + this.persistenceUnitName + "'.");
                }
                entityManagerFactoryInstance = new EntityManagerFactoryInstance(entityManagerFactory);
                persistenceUnitNameToEntityManagerFactoryInstanceMap.put(this.persistenceUnitName, entityManagerFactoryInstance);
            } else {
                entityManagerFactoryInstance = persistenceUnitNameToEntityManagerFactoryInstanceMap.get(this.persistenceUnitName);
            }
            int count = entityManagerFactoryInstance.getResourceInstanceCount();
            entityManagerFactoryInstance.setResourceInstanceCount(++count);
            EntityManagerFactory entityManagerFactory = entityManagerFactoryInstance.getEntityManagerFactory();
            this.entityManager = entityManagerFactory.createEntityManager();
            this.entityManager.getTransaction().begin();
        }
        catch (RuntimeException exception) {
            this.closeDatabase();
            throw new WrappedException((Exception)exception);
        }
    }

    protected void readContentsFromDatabase(Map<?, ?> options) {
        try {
            this.readingContentsFromDatabase = true;
            List contents = this.entityManager.createQuery(this.contentsQuery).getResultList();
            this.getContents().addAll((Collection)contents);
            this.readingContentsFromDatabase = false;
        }
        catch (RuntimeException exception) {
            throw new WrappedException((Exception)exception);
        }
    }

    protected void closeDatabase() {
        if (this.entityManager != null && this.entityManager.isOpen()) {
            this.entityManager.close();
        }
        if (persistenceUnitNameToEntityManagerFactoryInstanceMap.containsKey(this.persistenceUnitName)) {
            EntityManagerFactoryInstance entityManagerFactoryInstance = persistenceUnitNameToEntityManagerFactoryInstanceMap.get(this.persistenceUnitName);
            int count = entityManagerFactoryInstance.getResourceInstanceCount();
            if (count > 0) {
                entityManagerFactoryInstance.setResourceInstanceCount(--count);
            }
            if (count == 0) {
                EntityManagerFactory entityManagerFactory = entityManagerFactoryInstance.getEntityManagerFactory();
                entityManagerFactory.close();
                persistenceUnitNameToEntityManagerFactoryInstanceMap.remove(this.persistenceUnitName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DatabaseContentsEList<E>
    extends ResourceImpl.ContentsEList<E> {
        private static final long serialVersionUID = 1L;

        protected DatabaseContentsEList() {
            super((ResourceImpl)EclipseLinkResourceImpl.this);
        }

        protected void loaded() {
            if (!EclipseLinkResourceImpl.this.isLoaded()) {
                Map options = EclipseLinkResourceImpl.this.defaultLoadOptions;
                ResourceSet resourceSet = EclipseLinkResourceImpl.this.getResourceSet();
                if (resourceSet != null) {
                    options = EclipseLinkResourceImpl.mergeMaps((Map)resourceSet.getLoadOptions(), (Map)options);
                }
                EclipseLinkResourceImpl.this.openDatabase(options);
            }
            super.loaded();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EclipseLinkContentTreeIterator<E>
    extends EcoreUtil.ContentTreeIterator<E> {
        private static final long serialVersionUID = 1L;
        private boolean loadOnDemand;

        public EclipseLinkContentTreeIterator(Collection<?> emfObjects, boolean loadOnDemand) {
            super(emfObjects);
            this.loadOnDemand = loadOnDemand;
        }

        public Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
            Iterator result;
            if (!this.loadOnDemand) {
                ArrayList<EReference> eLoadedContainmentReferences = new ArrayList<EReference>();
                for (EReference eReference : eObject.eClass().getEAllContainments()) {
                    if (eReference.isMany()) {
                        EList eChildrenList = (EList)eObject.eGet((EStructuralFeature)eReference);
                        if (eChildrenList instanceof IndirectEContainer) {
                            IndirectEContainer indirectEContainer = (IndirectEContainer)eChildrenList;
                            if (!indirectEContainer.isInstantiated()) continue;
                            eLoadedContainmentReferences.add(eReference);
                            continue;
                        }
                        eLoadedContainmentReferences.add(eReference);
                        continue;
                    }
                    eLoadedContainmentReferences.add(eReference);
                }
                result = new EContentsEList(eObject, eLoadedContainmentReferences).iterator();
            } else {
                result = super.getEObjectChildren(eObject);
            }
            return result;
        }
    }

    protected class EntityManagerFactoryInstance {
        private EntityManagerFactory entityManagerFactory;
        private int resourceInstanceCount;

        public EntityManagerFactoryInstance(EntityManagerFactory entityManagerFactory) {
            this.entityManagerFactory = entityManagerFactory;
            this.resourceInstanceCount = 0;
        }

        public EntityManagerFactory getEntityManagerFactory() {
            return this.entityManagerFactory;
        }

        public int getResourceInstanceCount() {
            return this.resourceInstanceCount;
        }

        public void setResourceInstanceCount(int resourceInstanceCount) {
            this.resourceInstanceCount = resourceInstanceCount;
        }
    }
}

